/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.testrunner.api.TestMethodRunnerProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodDebuggerProvider {
    private final String command = "debug.single.method";

    public abstract boolean canHandle(Node var1);

    public abstract SingleMethod getTestMethod(Document var1, int var2);

    public final void debugTestMethod(Node activatedNode) {
        int caret;
        Document doc;
        final Node activeNode = activatedNode;
        EditorCookie ec = (EditorCookie)activeNode.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
            if (pane != null) {
                doc = pane.getDocument();
                caret = pane.getCaret().getDot();
            } else {
                doc = null;
                caret = -1;
            }
        } else {
            doc = null;
            caret = -1;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                ActionProvider ap;
                SingleMethod sm = (SingleMethod)activeNode.getLookup().lookup(SingleMethod.class);
                if (sm == null) {
                    sm = TestMethodDebuggerProvider.this.getTestMethod(doc, caret);
                }
                if (sm != null && (ap = TestMethodRunnerProvider.getActionProvider(sm.getFile())) != null && Arrays.asList(ap.getSupportedActions()).contains("debug.single.method") && ap.isActionEnabled("debug.single.method", Lookups.singleton((Object)sm))) {
                    ap.invokeAction("debug.single.method", Lookups.singleton((Object)sm));
                }
            }
        });
    }
}

