/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.gsf.testrunner.CommonTestsCfgOfCreate;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class TestCreatorAction
extends NodeAction {
    private ArrayList<String> testingFrameworksToAdd = new ArrayList();

    public TestCreatorAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(TestCreatorAction.class, (String)"LBL_CreateCommonTestAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : providers) {
            boolean enable = ((TestCreatorProvider)provider.getInstance()).enable(activatedNodes);
            if (!enable) continue;
            return true;
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        DataObject[] modified = DataObject.getRegistry().getModified();
        CommonTestsCfgOfCreate cfg = new CommonTestsCfgOfCreate(activatedNodes);
        cfg.createCfgPanel(modified.length != 0);
        this.testingFrameworksToAdd.clear();
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : providers) {
            this.testingFrameworksToAdd.add(provider.getDisplayName());
        }
        cfg.addTestingFrameworks(this.testingFrameworksToAdd);
        if (!cfg.configure()) {
            return;
        }
        this.saveAll(modified);
        String selected = cfg.getSelectedTestingFramework();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals(selected)) continue;
            TestCreatorProvider.Context context = new TestCreatorProvider.Context(activatedNodes);
            context.setSingleClass(cfg.isSingleClass());
            context.setTargetFolder(cfg.getTargetFolder());
            context.setTestClassName(cfg.getTestClassName());
            ((TestCreatorProvider)provider.getInstance()).createTests(context);
            cfg = null;
            break;
        }
    }

    private void saveAll(DataObject[] dataObjects) {
        for (DataObject dataObject : dataObjects) {
            SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
            if (saveCookie == null) continue;
            try {
                saveCookie.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

