/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner;

import java.text.MessageFormat;

public final class MessageStack {
    public static final int LAYER_VOLATILE = -1;
    private final String[] messageLayers;
    private int visibleLayerIndex = -1;
    private String volatileMsg;

    public MessageStack(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("number of layers must be positive");
        }
        this.messageLayers = new String[size];
    }

    public String getDisplayedMessage() {
        return this.volatileMsg != null ? this.volatileMsg : this.getTopmostStackMessage();
    }

    private String getTopmostStackMessage() {
        return this.visibleLayerIndex != -1 ? this.messageLayers[this.visibleLayerIndex] : null;
    }

    public void clear() {
        this.volatileMsg = null;
        if (this.visibleLayerIndex != -1) {
            for (int i = this.visibleLayerIndex; i < this.messageLayers.length; ++i) {
                this.messageLayers[i] = null;
            }
            this.visibleLayerIndex = -1;
        }
    }

    public String setMessage(int layer, String message) throws IllegalArgumentException {
        if (layer == -1) {
            return this.setVolatileMessage(message);
        }
        if (layer < 0 || layer >= this.messageLayers.length) {
            throw new IllegalArgumentException(MessageFormat.format("Message type out of bounds (0 .. {1}): {0}", new Integer(layer), new Integer(this.messageLayers.length)));
        }
        if (message != null && message.trim().length() == 0) {
            message = null;
        }
        String oldDisplayed = this.getDisplayedMessage();
        this.volatileMsg = null;
        this.messageLayers[layer] = message;
        if (message != null) {
            if (this.visibleLayerIndex == -1 || layer < this.visibleLayerIndex) {
                this.visibleLayerIndex = layer;
            }
        } else if (layer == this.visibleLayerIndex) {
            for (int i = layer + 1; i < this.messageLayers.length; ++i) {
                if (this.messageLayers[i] == null) continue;
                this.visibleLayerIndex = i;
                break;
            }
            if (this.visibleLayerIndex == layer) {
                this.visibleLayerIndex = -1;
            }
        }
        return this.checkDisplayModified(oldDisplayed, this.getDisplayedMessage());
    }

    public String clearMessage(int layer) {
        return this.setMessage(layer, null);
    }

    public String setVolatileMessage(String message) {
        if (message != null && message.trim().length() == 0) {
            message = null;
        }
        String oldDisplayed = this.getDisplayedMessage();
        this.volatileMsg = message;
        return this.checkDisplayModified(oldDisplayed, this.getDisplayedMessage());
    }

    public String clearVolatileMessage() {
        return this.setVolatileMessage(null);
    }

    private String checkDisplayModified(String oldDisplay, String newDisplay) {
        if (newDisplay == null && oldDisplay != null) {
            return "";
        }
        if (newDisplay != null && !newDisplay.equals(oldDisplay)) {
            return newDisplay;
        }
        return null;
    }
}

