/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.folb.GroupInfoServiceBase;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IiopFolbGmsClient
implements CallBack {
    private static final Logger _logger = LogDomains.getLogger(IiopFolbGmsClient.class, (String)"javax.enterprise.resource.corba");
    private Habitat habitat;
    private Domain domain;
    private Server myServer;
    private Nodes nodes;
    private GMSAdapterService gmsAdapterService;
    private GMSAdapter gmsAdapter;
    private Map<String, ClusterInstanceInfo> currentMembers;
    private GroupInfoService gis;

    private void fineLog(String fmt, java.lang.Object ... args) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, fmt, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IiopFolbGmsClient(Habitat habitat) {
        block7: {
            block6: {
                this.fineLog("IiopFolbGmsClient: constructor: habitat {0}", habitat);
                this.habitat = habitat;
                this.gmsAdapterService = (GMSAdapterService)habitat.getComponent(GMSAdapterService.class);
                if (this.gmsAdapterService != null) break block6;
                this.fineLog("IiopFolbGmsClient: gmsAdapter {0}", this.gmsAdapter);
                return;
            }
            try {
                this.gmsAdapter = this.gmsAdapterService.getGMSAdapter();
                this.fineLog("IiopFolbGmsClient: gmsAdapter {0}", this.gmsAdapter);
                if (this.gmsAdapter != null) {
                    this.domain = (Domain)habitat.getComponent(Domain.class);
                    this.fineLog("IiopFolbGmsClient: domain {0}", this.domain);
                    Servers servers = (Servers)habitat.getComponent(Servers.class);
                    this.fineLog("IiopFolbGmsClient: servers {0}", servers);
                    this.nodes = (Nodes)habitat.getComponent(Nodes.class);
                    this.fineLog("IiopFolbGmsClient: nodes {0}", this.nodes);
                    String instanceName = this.gmsAdapter.getModule().getInstanceName();
                    this.fineLog("IiopFolbGmsClient: instanceName {0}", instanceName);
                    this.myServer = servers.getServer(instanceName);
                    this.fineLog("IiopFolbGmsClient: myServer {0}", this.myServer);
                    this.gis = new GroupInfoServiceGMSImpl();
                    this.fineLog("IiopFolbGmsClient: IIOP GIS created", new java.lang.Object[0]);
                    this.currentMembers = this.getAllClusterInstanceInfo();
                    this.fineLog("IiopFolbGmsClient: currentMembers = ", this.currentMembers);
                    this.fineLog("iiop instance info = " + this.getIIOPEndpoints(), new java.lang.Object[0]);
                    this.gmsAdapter.registerFailureNotificationListener(this);
                    this.gmsAdapter.registerJoinedAndReadyNotificationListener(this);
                    this.gmsAdapter.registerPlannedShutdownListener(this);
                    this.fineLog("IiopFolbGmsClient: GMS action factories added", new java.lang.Object[0]);
                    break block7;
                }
                this.fineLog("IiopFolbGmsClient: gmsAdapterService is null", new java.lang.Object[0]);
                this.gis = new GroupInfoServiceNoGMSImpl();
            }
            catch (Throwable t) {
                try {
                    _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
                }
                catch (Throwable throwable) {
                    this.fineLog("IiopFolbGmsClient: gmsAdapter {0}", this.gmsAdapter);
                    throw throwable;
                }
                this.fineLog("IiopFolbGmsClient: gmsAdapter {0}", this.gmsAdapter);
            }
        }
        this.fineLog("IiopFolbGmsClient: gmsAdapter {0}", this.gmsAdapter);
    }

    public void setORB(ORB orb) {
        try {
            orb.register_initial_reference("FolbServerGroupInfoService", (Object)this.gis);
            this.fineLog(".initGIS: naming registration complete: {0}", this.gis);
            GroupInfoService gisRef = (GroupInfoService)orb.resolve_initial_references("FolbServerGroupInfoService");
            List lcii = gisRef.getClusterInstanceInfo(null);
            this.fineLog("Results from getClusterInstanceInfo:", new java.lang.Object[0]);
            if (lcii != null) {
                for (ClusterInstanceInfo cii : lcii) {
                    this.fineLog(cii.toString(), new java.lang.Object[0]);
                }
            }
        }
        catch (InvalidName e) {
            this.fineLog(".initGIS: registering GIS failed: {0}", new java.lang.Object[]{e});
        }
    }

    public GroupInfoService getGroupInfoService() {
        return this.gis;
    }

    public boolean isGMSAvailable() {
        return this.gmsAdapter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotification(Signal signal) {
        try {
            this.fineLog("processNotification: signal {0}", signal);
            signal.acquire();
            this.handleSignal(signal);
        }
        catch (SignalAcquireException e) {
            _logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        finally {
            try {
                signal.release();
            }
            catch (SignalReleaseException e) {
                _logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
    }

    private void handleSignal(Signal signal) {
        this.fineLog("IiopFolbGmsClient.handleSignal: signal from: {0}", signal.getMemberToken());
        this.fineLog("IiopFolbGmsClient.handleSignal: map entryset: {0}", signal.getMemberDetails().entrySet());
        if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
            this.removeMember(signal);
        } else if (signal instanceof JoinedAndReadyNotificationSignal) {
            this.addMember(signal);
        } else {
            _logger.log(Level.SEVERE, "IiopFolbGmsClient.handleSignal: unknown signal: {0}", signal.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            this.fineLog("IiopFolbGmsClient.removeMember->: {0}", instanceName);
            IiopFolbGmsClient iiopFolbGmsClient = this;
            synchronized (iiopFolbGmsClient) {
                if (this.currentMembers.get(instanceName) != null) {
                    this.currentMembers.remove(instanceName);
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} removed - notifying listeners", instanceName);
                    this.gis.notifyObservers();
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} - notification complete", instanceName);
                } else {
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} not present: no action", instanceName);
                }
            }
        }
        catch (Throwable throwable) {
            this.fineLog("IiopFolbGmsClient.removeMember<-: {0}", instanceName);
            throw throwable;
        }
        this.fineLog("IiopFolbGmsClient.removeMember<-: {0}", instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            this.fineLog("IiopFolbGmsClient.addMember->: {0}", instanceName);
            IiopFolbGmsClient iiopFolbGmsClient = this;
            synchronized (iiopFolbGmsClient) {
                if (this.currentMembers.get(instanceName) != null) {
                    this.fineLog("IiopFolbGmsClient.addMember: {0} already present: no action", instanceName);
                } else {
                    ClusterInstanceInfo clusterInstanceInfo = this.getClusterInstanceInfo(instanceName);
                    this.currentMembers.put(clusterInstanceInfo.name(), clusterInstanceInfo);
                    this.fineLog("IiopFolbGmsClient.addMember: {0} added - notifying listeners", instanceName);
                    this.gis.notifyObservers();
                    this.fineLog("IiopFolbGmsClient.addMember: {0} - notification complete", instanceName);
                }
            }
        }
        catch (Throwable throwable) {
            this.fineLog("IiopFolbGmsClient.addMember<-: {0}", instanceName);
            throw throwable;
        }
        this.fineLog("IiopFolbGmsClient.addMember<-: {0}", instanceName);
    }

    private int resolvePort(Server server, IiopListener listener) {
        this.fineLog("resolvePort: server {0} listener {1}", server, listener);
        IiopListener ilRaw = (IiopListener)GlassFishConfigBean.getRawView((ConfigBeanProxy)listener);
        this.fineLog("resolvePort: ilRaw {0}", ilRaw);
        PropertyResolver pr = new PropertyResolver(this.domain, server.getName());
        this.fineLog("resolvePort: pr {0}", pr);
        String port = pr.getPropertyValue(ilRaw.getPort());
        this.fineLog("resolvePort: port {0}", port);
        return Integer.parseInt(port);
    }

    private ClusterInstanceInfo getClusterInstanceInfo(Server server, Config config, boolean assumeInstanceIsRunning) {
        Node node;
        String nodeName;
        if (server == null) {
            return null;
        }
        if (!assumeInstanceIsRunning && !server.isRunning()) {
            return null;
        }
        this.fineLog("getClusterInstanceInfo: server {0}, config {1}", server, config);
        String name = server.getName();
        this.fineLog("getClusterInstanceInfo: name {0}", name);
        int weight = Integer.parseInt(server.getLbWeight());
        this.fineLog("getClusterInstanceInfo: weight {0}", weight);
        String hostName = nodeName = server.getNodeRef();
        if (this.nodes != null && (node = this.nodes.getNode(nodeName)) != null) {
            if (node.isLocal()) {
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException exc) {
                    this.fineLog("getClusterInstanceInfo: caught exception for localhost lookup {0}", exc);
                }
            } else {
                hostName = node.getNodeHost();
            }
        }
        this.fineLog("getClusterInstanceInfo: host {0}", hostName);
        IiopService iservice = config.getIiopService();
        this.fineLog("getClusterInstanceInfo: iservice {0}", iservice);
        List listeners = iservice.getIiopListener();
        this.fineLog("getClusterInstanceInfo: listeners {0}", listeners);
        ArrayList<SocketInfo> sinfos = new ArrayList<SocketInfo>();
        for (IiopListener il : listeners) {
            SocketInfo sinfo = new SocketInfo(il.getId(), hostName, this.resolvePort(server, il));
            sinfos.add(sinfo);
        }
        this.fineLog("getClusterInstanceInfo: sinfos {0}", sinfos);
        ClusterInstanceInfo result = new ClusterInstanceInfo(name, weight, sinfos);
        this.fineLog("getClusterInstanceInfo: result {0}", result);
        return result;
    }

    private Config getConfigForServer(Server server) {
        this.fineLog("getConfigForServer: server {0}", server);
        String configRef = server.getConfigRef();
        this.fineLog("getConfigForServer: configRef {0}", configRef);
        Configs configs = (Configs)this.habitat.getComponent(Configs.class);
        this.fineLog("getConfigForServer: configs {0}", configs);
        Config config = configs.getConfigByName(configRef);
        this.fineLog("getConfigForServer: config {0}", config);
        return config;
    }

    private ClusterInstanceInfo getClusterInstanceInfo(String instanceName) {
        this.fineLog("getClusterInstanceInfo: instanceName {0}", instanceName);
        Servers servers = (Servers)this.habitat.getComponent(Servers.class);
        this.fineLog("getClusterInstanceInfo: servers {0}", servers);
        Server server = servers.getServer(instanceName);
        this.fineLog("getClusterInstanceInfo: server {0}", server);
        Config config = this.getConfigForServer(server);
        this.fineLog("getClusterInstanceInfo: servers {0}", servers);
        ClusterInstanceInfo result = this.getClusterInstanceInfo(server, config, true);
        this.fineLog("getClusterInstanceInfo: result {0}", result);
        return result;
    }

    private Map<String, ClusterInstanceInfo> getAllClusterInstanceInfo() {
        Cluster myCluster = this.myServer.getCluster();
        this.fineLog("getAllClusterInstanceInfo: myCluster {0}", myCluster);
        Config myConfig = this.getConfigForServer(this.myServer);
        this.fineLog("getAllClusterInstanceInfo: myConfig {0}", myConfig);
        HashMap<String, ClusterInstanceInfo> result = new HashMap<String, ClusterInstanceInfo>();
        for (Server server : myCluster.getInstances()) {
            ClusterInstanceInfo cii = this.getClusterInstanceInfo(server, myConfig, false);
            if (cii == null) continue;
            result.put(server.getName(), cii);
        }
        this.fineLog("getAllClusterInstanceInfo: result {0}", result);
        return result;
    }

    public final String getIIOPEndpoints() {
        Map<String, ClusterInstanceInfo> cinfos = this.getAllClusterInstanceInfo();
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (ClusterInstanceInfo cinfo : cinfos.values()) {
            for (SocketInfo sinfo : cinfo.endpoints()) {
                if (sinfo.type().startsWith("SSL")) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(sinfo.host()).append(':').append(sinfo.port());
            }
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupInfoServiceGMSImpl
    extends GroupInfoServiceBase {
        GroupInfoServiceGMSImpl() {
        }

        public List<ClusterInstanceInfo> internalClusterInstanceInfo(List<String> endpoints) {
            IiopFolbGmsClient.this.fineLog("internalClusterInstanceInfo: currentMembers {0}", new java.lang.Object[]{IiopFolbGmsClient.this.currentMembers});
            if (IiopFolbGmsClient.this.currentMembers == null) {
                return new ArrayList<ClusterInstanceInfo>();
            }
            return new ArrayList<ClusterInstanceInfo>(IiopFolbGmsClient.this.currentMembers.values());
        }
    }

    class GroupInfoServiceNoGMSImpl
    extends GroupInfoServiceGMSImpl {
        GroupInfoServiceNoGMSImpl() {
        }

        public boolean addObserver(GroupInfoServiceObserver x) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public void notifyObservers() {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public boolean shouldAddAddressesToNonReferenceFactory(String[] x) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public boolean shouldAddMembershipLabel(String[] adapterName) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }
    }
}

