/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.XMLDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeUtilities;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class GenerateDTDSupport
implements XMLGenerateCookie {
    static final String DTD_EXT = "dtd";
    private final DataObject template;
    private ElementInfo current;
    private Stack elementStack;
    private Map elementInfos;
    private String warning;
    private String rootQName;

    public GenerateDTDSupport(XMLDataObject template) {
        this.template = template;
        this.rootQName = null;
        this.warning = null;
        this.current = null;
    }

    public void generate() {
        try {
            SaveCookie save = (SaveCookie)this.template.getCookie(SaveCookie.class);
            if (save != null) {
                save.save();
            }
            FileObject primFile = this.template.getPrimaryFile();
            String name = primFile.getName();
            FileObject folder = primFile.getParent();
            FileObject generFile = new SelectFileDialog(folder, name, DTD_EXT, Util.NONEMPTY_CHECK).getFileObject();
            name = generFile.getName();
            String encoding = EncodingUtil.getProjectEncoding((FileObject)primFile);
            this.generateDTDContent(encoding, name, generFile);
            GuiUtil.performDefaultAction((FileObject)generFile);
        }
        catch (UserCancelException e) {
        }
        catch (Exception exc) {
            GuiUtil.notifyException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDTDContent(String encoding, String name, FileObject dtdFile) throws IOException {
        FileLock lock = null;
        Writer writer = null;
        try {
            String dtd = this.xml2dtd(name, encoding);
            if (dtd == null) {
                String msg = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"BK0009");
                GuiUtil.notifyWarning((String)(msg + "\n" + this.warning));
                return;
            }
            lock = dtdFile.lock();
            encoding = TreeUtilities.iana2java((String)(encoding == null ? "UTF-8" : encoding));
            OutputStream output = dtdFile.getOutputStream(lock);
            try {
                writer = new OutputStreamWriter(output, encoding);
            }
            catch (UnsupportedEncodingException e) {
                writer = new OutputStreamWriter(output);
            }
            writer = new PrintWriter(writer);
            writer.write(dtd.toString());
            lock.releaseLock();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    String xml2dtd(String name, String encoding) {
        StringBuffer sb = new StringBuffer();
        this.elementStack = new Stack();
        this.elementInfos = new LinkedHashMap(101);
        if (!this.scanTemplate()) {
            return null;
        }
        if (encoding != null) {
            sb.append("<?xml version='1.0' encoding='").append(encoding).append("'?>\n\n");
        }
        String todo = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"TODO", (Object)(name + "." + DTD_EXT));
        sb.append("<!--\n    ").append(todo).append("\n\n-->\n\n");
        String usage = NbBundle.getMessage((Class)GenerateDTDSupport.class, (String)"BK0010");
        sb.append("<!--\n").append("    " + usage + "\n\n").append("    <?xml version=\"1.0\"?>\n\n").append("    <!DOCTYPE ").append(this.rootQName).append(" SYSTEM \"").append(name).append(".").append(DTD_EXT).append("\">\n\n").append("    <").append(this.rootQName).append(">\n    ...\n").append("    </").append(this.rootQName).append(">\n").append("-->\n");
        Iterator it = this.elementInfos.values().iterator();
        while (it.hasNext()) {
            sb.append("\n");
            ElementInfo elem = (ElementInfo)it.next();
            sb.append("<!--- " + NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$tools$generator$GenerateDTDSupport == null ? GenerateDTDSupport.class$("org.netbeans.modules.xml.tools.generator.GenerateDTDSupport") : class$org$netbeans$modules$xml$tools$generator$GenerateDTDSupport), (String)"FMT_DTDDoc") + " -->\n");
            sb.append("<!ELEMENT ").append(elem.name.qName).append(" ");
            if (elem.empty) {
                sb.append("EMPTY");
            } else {
                Collection<Object> collect = elem.children;
                if (elem.pcdata || collect.size() == 0) {
                    Vector<XName> vect = new Vector<XName>(collect);
                    vect.insertElementAt(new XName("", "", "#PCDATA"), 0);
                    collect = vect;
                }
                Iterator itc = collect.iterator();
                XName elemName = (XName)itc.next();
                sb.append("(").append(elemName.qName);
                while (itc.hasNext()) {
                    elemName = (XName)itc.next();
                    sb.append("|").append(elemName.qName);
                }
                if (!sb.toString().endsWith("#PCDATA")) {
                    sb.append(")*");
                } else {
                    sb.append(")");
                }
            }
            sb.append(">\n");
            if (elem.attributes.size() == 0) continue;
            sb.append("<!ATTLIST ").append(elem.name.qName).append("\n");
            Iterator ita = elem.attributes.iterator();
            while (ita.hasNext()) {
                XName attName = (XName)ita.next();
                sb.append("    ").append(attName.qName).append(" CDATA #IMPLIED\n");
            }
            sb.append("  >\n");
        }
        return sb.toString();
    }

    private boolean scanTemplate() {
        URL url = null;
        XMLReader parser = null;
        try {
            url = this.template.getPrimaryFile().getURL();
        }
        catch (FileStateInvalidException e) {
            this.warning = e.getLocalizedMessage();
            return false;
        }
        String system = url.toExternalForm();
        try {
            EntityResolver resolver;
            parser = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            Impl impl = new Impl();
            parser.setContentHandler(impl);
            parser.setErrorHandler(impl);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            UserCatalog catalog = UserCatalog.getDefault();
            if (catalog != null && (resolver = catalog.getEntityResolver()) != null) {
                parser.setEntityResolver(resolver);
            }
        }
        catch (SAXException e) {
            this.warning = e.getLocalizedMessage();
            return false;
        }
        InputSource input = new InputSource(system);
        try {
            parser.parse(input);
            return true;
        }
        catch (IOException e) {
            this.warning = e.getLocalizedMessage();
            return false;
        }
        catch (SAXException e) {
            this.warning = e.getLocalizedMessage();
            return false;
        }
    }

    private boolean wsOnly(String s) {
        if (s == null) {
            return true;
        }
        char[] data = s.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (Character.isWhitespace(data[i])) continue;
            return false;
        }
        return true;
    }

    private boolean wsOnly(char[] data, int from, int length) {
        for (int i = from; i < from + length; ++i) {
            if (Character.isWhitespace(data[i])) continue;
            return false;
        }
        return true;
    }

    private class ElementInfo {
        XName name;
        Set children;
        Set attributes;
        boolean pcdata;
        boolean empty;

        public ElementInfo(String uri, String localName, String qName) {
            this.name = new XName(uri, localName, qName);
            this.children = new HashSet();
            this.attributes = new HashSet();
            this.pcdata = false;
            this.empty = true;
        }

        public void hasPCDATA() {
            this.pcdata = true;
            this.empty = false;
        }

        public boolean isTextAllowed() {
            return this.pcdata;
        }

        public void addChild(ElementInfo info) {
            this.empty = false;
            this.children.add(info.name);
        }

        public void addAttribute(String uri, String localName, String qName) {
            this.attributes.add(new XName(uri, localName, qName));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ElementInfo) {
                ElementInfo info = (ElementInfo)obj;
                return this.name.equals(info.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class Impl
    implements ContentHandler,
    ErrorHandler {
        private Impl() {
        }

        public void characters(char[] chars, int i, int i1) throws SAXException {
            if (!GenerateDTDSupport.this.wsOnly(chars, i, i1) && GenerateDTDSupport.this.current != null) {
                GenerateDTDSupport.this.current.hasPCDATA();
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String s, String s1, String s2) throws SAXException {
            GenerateDTDSupport.this.current = (ElementInfo)GenerateDTDSupport.this.elementStack.pop();
        }

        public void endPrefixMapping(String s) throws SAXException {
        }

        public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        }

        public void processingInstruction(String s, String s1) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String s) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (GenerateDTDSupport.this.rootQName == null) {
                GenerateDTDSupport.this.rootQName = qName;
            }
            XName xName = new XName(uri, localName, qName);
            ElementInfo info = (ElementInfo)GenerateDTDSupport.this.elementInfos.get(xName);
            if (info == null) {
                info = new ElementInfo(uri, localName, qName);
                GenerateDTDSupport.this.elementInfos.put(xName, info);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                info.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
            }
            if (GenerateDTDSupport.this.current != null) {
                GenerateDTDSupport.this.current.addChild(info);
            }
            GenerateDTDSupport.this.elementStack.push(GenerateDTDSupport.this.current);
            GenerateDTDSupport.this.current = info;
        }

        public void startPrefixMapping(String s, String s1) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }

    private static class XName {
        private String uri;
        private String localName;
        private String qName;

        public XName(String uri, String localName, String qName) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
        }

        public boolean equals(Object peer) {
            if (peer == this) {
                return true;
            }
            if (peer instanceof XName) {
                XName id = (XName)peer;
                return this.uri.equals(id.uri) && this.localName.equals(id.localName) && this.qName.equals(id.qName);
            }
            return false;
        }

        public int hashCode() {
            return this.uri.hashCode() ^ this.localName.hashCode() ^ this.qName.hashCode();
        }
    }
}

