/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.core.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.api.SQEAnnotationProcessor;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class AnnotationToggleListener
implements PropertyChangeListener {
    private QualityProvider qualityProvider;
    private Project project;

    AnnotationToggleListener(QualityProvider qualityProvider, Project project) {
        this.qualityProvider = qualityProvider;
        this.project = project;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName != null && !propertyName.equals(SQECodedefectProperties.getPropertyNameAnnotateActive(this.qualityProvider)) && !propertyName.equals("Result")) {
            return;
        }
        if (!SQECodedefectProperties.isQualityProviderAnnotateActive(this.project, this.qualityProvider)) {
            SQEAnnotationProcessor processor = (SQEAnnotationProcessor)this.qualityProvider.getLookup().lookup(SQEAnnotationProcessor.class);
            processor.clearAllAnnotations(this.project);
        } else {
            final SQEAnnotationProcessor processor = (SQEAnnotationProcessor)this.qualityProvider.getLookup().lookup(SQEAnnotationProcessor.class);
            if (propertyName.equals("Result")) {
                processor.clearAllAnnotations(this.project);
            }
            final QualitySession session = (QualitySession)this.project.getLookup().lookup(this.qualityProvider.getQualitySessionClass());
            for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                FileObject fo;
                JavaSource javaSource;
                DataObject dao = (DataObject)topComponent.getLookup().lookup(DataObject.class);
                if (null == dao || null == (javaSource = JavaSource.forFileObject((FileObject)(fo = dao.getPrimaryFile())))) continue;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        processor.annotateSourceFile(javaSource, AnnotationToggleListener.this.project, session.getResult());
                    }
                });
            }
        }
    }
}

