/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.core.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.spi.AnnotationToggleListener;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.WeakListeners;

public abstract class AbstractQualitySession
implements QualitySession {
    private final PropertyChangeSupport propSupport;
    private final Project project;
    private final QualityProvider provider;

    public AbstractQualitySession(QualityProvider provider, Project project) {
        this.provider = provider;
        this.project = project;
        this.propSupport = new PropertyChangeSupport(this);
        AnnotationToggleListener listener = new AnnotationToggleListener(provider, project);
        SQECodedefectProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, SQECodedefectProperties.class));
        this.addPropertyChangeListener("Result", listener);
    }

    public QualityProvider getProvider() {
        return this.provider;
    }

    public Project getProject() {
        return this.project;
    }

    public String getName() {
        return ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public String getDisplayName() {
        return ProjectUtils.getInformation((Project)this.project).getName();
    }

    protected final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    protected final void fireResultChanged(QualityResult oldResult, QualityResult newResult) {
        this.getPropertyChangeSupport().firePropertyChange("Result", oldResult, newResult);
    }
}

