/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.core.api.install;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.api.SQEAnnotationProcessor;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

final class OpenTopComponentsListener
implements PropertyChangeListener {
    static PropertyChangeListener INSTANCE = new OpenTopComponentsListener();
    private static final RequestProcessor RP = new RequestProcessor(OpenTopComponentsListener.class.getName());

    OpenTopComponentsListener() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("opened".equals(event.getPropertyName())) {
            Set oldComponents = (Set)event.getOldValue();
            Set newComponents = (Set)event.getNewValue();
            newComponents.removeAll(oldComponents);
            for (TopComponent tc : newComponents) {
                final DataObject dao = (DataObject)tc.getLookup().lookup(DataObject.class);
                if (null == dao) continue;
                RP.post(new Runnable(){

                    public void run() {
                        block2: for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                            SourceGroup[] sgs;
                            for (SourceGroup sg : sgs = ProjectUtilities.getJavaSourceGroups((Project)project)) {
                                try {
                                    if (!sg.contains(dao.getPrimaryFile())) continue;
                                    JavaSource javaSource = JavaSource.forFileObject((FileObject)dao.getPrimaryFile());
                                    if (null == javaSource) continue block2;
                                    for (QualitySession qualitySession : project.getLookup().lookupAll(QualitySession.class)) {
                                        assert (qualitySession != null) : "Illegal null QualitySession in QualitySessionManager-Storage for Project " + project;
                                        SQEAnnotationProcessor sqeAnnotationProcessor = (SQEAnnotationProcessor)qualitySession.getProvider().getLookup().lookup(SQEAnnotationProcessor.class);
                                        if (null == sqeAnnotationProcessor || !SQECodedefectProperties.isQualityProviderAnnotateActive(project, qualitySession.getProvider())) continue;
                                        sqeAnnotationProcessor.annotateSourceFile(javaSource, project, qualitySession.getResult());
                                    }
                                    continue block2;
                                }
                                catch (IllegalArgumentException iaex) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

