/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.EolCanonicalizingInputStream;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

public class StatusCommand
extends GitCommand {
    private final LinkedHashMap<File, GitStatus> statuses;
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final StatusListener listener;
    private static final String PROP_TRACK_SYMLINKS = "org.netbeans.libs.git.trackSymLinks";

    public StatusCommand(Repository repository, GitClassFactory gitFactory, File[] roots, ProgressMonitor monitor, StatusListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.statuses = new LinkedHashMap();
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git status");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        return this.getRepository().getDirectory().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.readDirCache();
            ObjectInserter oi = repository.newObjectInserter();
            try {
                boolean autocrlf;
                String workTreePath = repository.getWorkTree().getAbsolutePath();
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                Map<String, DiffEntry> renames = this.detectRenames(repository, cache);
                TreeWalk treeWalk = new TreeWalk(repository);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(false);
                treeWalk.reset();
                ObjectId headId = repository.resolve("HEAD");
                if (headId != null) {
                    treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
                } else {
                    treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                boolean T_HEAD = false;
                boolean T_INDEX = true;
                int T_WORKSPACE = 2;
                String lastPath = null;
                GitStatus[] conflicts = new GitStatus[3];
                LinkedList<GitStatus> symLinks = new LinkedList<GitStatus>();
                boolean checkExecutable = Utils.checkExecutable(repository);
                boolean trackSymLinks = Boolean.valueOf(System.getProperty(PROP_TRACK_SYMLINKS, Boolean.FALSE.toString()));
                WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                boolean bl = autocrlf = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE;
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    GitStatus.Status statusIndexWC;
                    GitStatus.Status statusHeadWC;
                    boolean isFolder;
                    DirCacheEntry indexEntry;
                    GitStatus.Status statusHeadIndex;
                    boolean tracked;
                    int mWorking;
                    int mHead;
                    File file;
                    boolean symlink;
                    String path;
                    block18: {
                        path = treeWalk.getPathString();
                        symlink = false;
                        if (path.equals(lastPath)) {
                            symlink = this.isKnownSymlink(symLinks, path);
                        } else {
                            this.handleConflict(conflicts, workTreePath);
                            this.handleSymlink(symLinks, workTreePath);
                        }
                        lastPath = path;
                        file = new File(workTreePath + File.separator + path);
                        mHead = treeWalk.getRawMode(0);
                        int mIndex = treeWalk.getRawMode(1);
                        mWorking = treeWalk.getRawMode(2);
                        boolean bl2 = tracked = mWorking != FileMode.TREE.getBits() && (mHead != FileMode.MISSING.getBits() || mIndex != FileMode.MISSING.getBits());
                        statusHeadIndex = mHead == FileMode.MISSING.getBits() && mIndex != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_ADDED : (mIndex == FileMode.MISSING.getBits() && mHead != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mHead != mIndex || mIndex != FileMode.TREE.getBits() && !treeWalk.idEqual(0, 1) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                        FileTreeIterator fti = (FileTreeIterator)treeWalk.getTree(2, FileTreeIterator.class);
                        DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
                        indexEntry = indexIterator != null ? indexIterator.getDirCacheEntry() : null;
                        isFolder = false;
                        if (!symlink && treeWalk.isSubtree()) {
                            if (mWorking == FileMode.TREE.getBits() && fti.isEntryIgnored()) {
                                Collection<TreeFilter> subTreeFilters = StatusCommand.getSubtreeFilters(pathFilters, path);
                                if (!subTreeFilters.isEmpty()) {
                                    treeWalk.setFilter(AndTreeFilter.create((TreeFilter)treeWalk.getFilter(), (TreeFilter)OrTreeFilter.create((TreeFilter)NotTreeFilter.create((TreeFilter)PathFilter.create((String)path)), (TreeFilter)(subTreeFilters.size() > 1 ? OrTreeFilter.create(subTreeFilters) : subTreeFilters.iterator().next()))));
                                    treeWalk.enterSubtree();
                                }
                                if (!StatusCommand.includes(pathFilters, treeWalk)) continue;
                                statusIndexWC = statusHeadWC = GitStatus.Status.STATUS_IGNORED;
                                isFolder = true;
                                break block18;
                            } else {
                                treeWalk.enterSubtree();
                                continue;
                            }
                        }
                        statusIndexWC = mWorking == FileMode.MISSING.getBits() && mIndex != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mIndex == FileMode.MISSING.getBits() && mWorking != FileMode.MISSING.getBits() ? (fti.isEntryIgnored() ? GitStatus.Status.STATUS_IGNORED : GitStatus.Status.STATUS_ADDED) : (!this.isExistingSymlink(mIndex, mWorking) && (this.differ(mIndex, mWorking, checkExecutable) || mWorking != 0 && mWorking != FileMode.TREE.getBits() && (autocrlf && fti.isModified(indexEntry, false) && (fti.compareMetadata(indexEntry) == WorkingTreeIterator.MetadataDiff.DIFFER_BY_METADATA || this.differ(indexEntry.getObjectId(), fti, oi)) || !autocrlf && fti.isModified(indexEntry, true))) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                        statusHeadWC = mWorking == FileMode.MISSING.getBits() && mHead != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mHead == FileMode.MISSING.getBits() && mWorking != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_ADDED : (!(this.isExistingSymlink(mIndex, mWorking) || !this.differ(mHead, mWorking, checkExecutable) && (mWorking == 0 || mWorking == FileMode.TREE.getBits() || indexEntry != null && indexEntry.isAssumeValid() || statusIndexWC == GitStatus.Status.STATUS_NORMAL && statusHeadIndex == GitStatus.Status.STATUS_NORMAL || treeWalk.getObjectId(0).equals((AnyObjectId)fti.getEntryObjectId()))) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                    }
                    int stage = indexEntry == null ? 0 : indexEntry.getStage();
                    GitStatus status = this.getClassFactory().createStatus(tracked, path, workTreePath, file, statusHeadIndex, statusIndexWC, statusHeadWC, null, isFolder, renames.get(path));
                    if (stage == 0) {
                        if (!trackSymLinks && this.isSymlinkFolder(mHead, mWorking, symlink)) {
                            symLinks.add(status);
                            continue;
                        }
                        this.addStatus(file, status);
                        continue;
                    }
                    conflicts[stage - 1] = status;
                }
                this.handleConflict(conflicts, workTreePath);
                this.handleSymlink(symLinks, workTreePath);
                return;
            }
            finally {
                oi.release();
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public Map<File, GitStatus> getStatuses() {
        return this.statuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DiffEntry> detectRenames(Repository repository, DirCache cache) {
        List entries;
        TreeWalk treeWalk = new TreeWalk(repository);
        try {
            treeWalk.setRecursive(true);
            treeWalk.reset();
            ObjectId headId = repository.resolve("HEAD");
            if (headId != null) {
                treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
            } else {
                treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            entries = DiffEntry.scan((TreeWalk)treeWalk);
            RenameDetector d = new RenameDetector(repository);
            d.addAll((Collection)entries);
            entries = d.compute();
        }
        catch (IOException ex) {
            entries = Collections.emptyList();
        }
        finally {
            treeWalk.release();
        }
        HashMap<String, DiffEntry> renames = new HashMap<String, DiffEntry>();
        for (DiffEntry e : entries) {
            if (!e.getChangeType().equals((Object)DiffEntry.ChangeType.COPY) && !e.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME)) continue;
            renames.put(e.getNewPath(), e);
        }
        return renames;
    }

    protected final void handleConflict(GitStatus[] conflicts, String workTreePath) {
        if (conflicts[0] != null || conflicts[1] != null || conflicts[2] != null) {
            GitStatus status;
            GitConflictDescriptor.Type type;
            if (conflicts[1] == null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.BOTH_DELETED;
                status = conflicts[0];
            } else if (conflicts[1] == null && conflicts[2] != null) {
                type = GitConflictDescriptor.Type.DELETED_BY_US;
                status = conflicts[2];
            } else if (conflicts[1] != null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.DELETED_BY_THEM;
                status = conflicts[1];
            } else if (conflicts[0] == null) {
                type = GitConflictDescriptor.Type.BOTH_ADDED;
                status = conflicts[1];
            } else {
                type = GitConflictDescriptor.Type.BOTH_MODIFIED;
                status = conflicts[1];
            }
            GitConflictDescriptor desc = this.getClassFactory().createConflictDescriptor(type);
            status = this.getClassFactory().createStatus(true, status.getRelativePath(), workTreePath, status.getFile(), GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, desc, status.isFolder(), null);
            this.addStatus(status.getFile(), status);
        }
        Arrays.fill(conflicts, null);
    }

    protected final void addStatus(File file, GitStatus status) {
        this.statuses.put(file, status);
        this.listener.notifyStatus(status);
    }

    public static boolean includes(Collection<PathFilter> filters, TreeWalk treeWalk) {
        boolean retval = filters.isEmpty();
        for (PathFilter filter : filters) {
            if (!filter.include(treeWalk) || treeWalk.getPathString().length() < filter.getPath().length()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private static Collection<TreeFilter> getSubtreeFilters(Collection<PathFilter> filters, String path) {
        LinkedList<TreeFilter> subtreeFilters = new LinkedList<TreeFilter>();
        for (PathFilter filter : filters) {
            if (!filter.getPath().startsWith(path + "/")) continue;
            subtreeFilters.add((TreeFilter)filter);
        }
        return subtreeFilters;
    }

    private boolean differ(int fileMode1, int fileModeWorking, boolean checkFileMode) {
        boolean differ;
        if (this.isExistingSymlink(fileMode1, fileModeWorking)) {
            differ = false;
        } else {
            int difference = fileMode1 ^ fileModeWorking;
            differ = checkFileMode ? difference != 0 : (difference & 0xFFFFFFB6) != 0;
        }
        return differ;
    }

    private boolean isExistingSymlink(int fileMode1, int fileModeWorking) {
        return (fileModeWorking & 0x8000) == 32768 && (fileMode1 & 0xA000) == 40960;
    }

    private boolean isKnownSymlink(List<GitStatus> symLinks, String path) {
        return !symLinks.isEmpty() && path.equals(symLinks.get(0).getRelativePath());
    }

    private boolean isSymlinkFolder(int mHead, int mWorking, boolean isSymlink) {
        return mWorking == 0 && (mHead & 0xA000) == 40960 || isSymlink && mHead == 0 && (mWorking & 0x4000) == 16384;
    }

    private void handleSymlink(List<GitStatus> symLinks, String workTreePath) {
        if (!symLinks.isEmpty()) {
            boolean removed = symLinks.size() == 1;
            GitStatus status = symLinks.get(0);
            status = this.getClassFactory().createStatus(true, status.getRelativePath(), workTreePath, status.getFile(), status.getStatusHeadIndex(), !removed || status.getStatusHeadIndex() == GitStatus.Status.STATUS_REMOVED ? GitStatus.Status.STATUS_NORMAL : GitStatus.Status.STATUS_REMOVED, removed ? GitStatus.Status.STATUS_REMOVED : GitStatus.Status.STATUS_NORMAL, null, status.isFolder(), null);
            this.addStatus(status.getFile(), status);
            symLinks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean differ(ObjectId objectId, FileTreeIterator fti, ObjectInserter oi) throws IOException {
        InputStream s1 = null;
        InputStream s2 = null;
        try {
            s1 = fti.openEntryStream();
            ByteBuffer buf = IO.readWholeStream((InputStream)s1, (int)((int)fti.getEntryLength()));
            ObjectId hash1 = oi.idFor(3, buf.array());
            ObjectLoader loader = this.getRepository().getObjectDatabase().open((AnyObjectId)objectId);
            s2 = new EolCanonicalizingInputStream((InputStream)loader.openStream());
            ByteBuffer buf2 = IO.readWholeStream((InputStream)s2, (int)((int)fti.getEntryLength()));
            ObjectId hash2 = oi.idFor(3, buf2.array());
            boolean bl = !hash1.equals((AnyObjectId)hash2);
            return bl;
        }
        finally {
            if (s1 != null) {
                try {
                    s1.close();
                }
                catch (IOException ex) {}
            }
            if (s2 != null) {
                try {
                    s2.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

