/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class RemoveCommand
extends GitCommand {
    private final File[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final boolean cached;

    public RemoveCommand(Repository repository, GitClassFactory gitFactory, File[] roots, boolean cached, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.cached = cached;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval && this.roots.length == 0) {
            retval = false;
            this.monitor.notifyWarning(EMPTY_ROOTS);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.lockDirCache();
            try {
                DirCacheEditor edit = cache.editor();
                TreeWalk treeWalk = new TreeWalk(repository);
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(false);
                treeWalk.setPostOrderTraversal(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    File path = new File(repository.getWorkTree(), treeWalk.getPathString());
                    if (!treeWalk.isPostChildren()) {
                        if (treeWalk.isSubtree()) {
                            treeWalk.enterSubtree();
                            if (Utils.isUnderOrEqual(treeWalk, pathFilters)) {
                                if (!this.cached) {
                                    this.listener.notifyFile(path, treeWalk.getPathString());
                                }
                                edit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(treeWalk.getPathString()));
                            }
                        } else {
                            this.listener.notifyFile(path, treeWalk.getPathString());
                            edit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(treeWalk.getPathString()));
                        }
                    }
                    if (this.cached || Utils.isFromNested(treeWalk.getFileMode(1).getBits()) || treeWalk.isSubtree() && (!treeWalk.isPostChildren() || !Utils.isUnderOrEqual(treeWalk, pathFilters)) || path.delete() || !path.exists()) continue;
                    this.monitor.notifyError(MessageFormat.format(Utils.getBundle(RemoveCommand.class).getString("MSG_Error_CannotDeleteFile"), path.getAbsolutePath()));
                }
                edit.commit();
            }
            finally {
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git rm");
        if (this.cached) {
            sb.append(" --cached");
        }
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }
}

