/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.ListRemoteObjectsCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListRemoteBranchesCommand
extends ListRemoteObjectsCommand {
    private HashMap<String, GitBranch> remoteBranches;
    private final String remoteUrl;

    public ListRemoteBranchesCommand(Repository repository, GitClassFactory gitFactory, String remoteRepositoryUrl, ProgressMonitor monitor) {
        super(repository, gitFactory, remoteRepositoryUrl, monitor);
        this.remoteUrl = remoteRepositoryUrl;
    }

    @Override
    protected void processRefs() {
        this.remoteBranches = new HashMap();
        this.remoteBranches.putAll(Utils.refsToBranches(this.getRefs(), "refs/heads/", this.getClassFactory()));
    }

    @Override
    protected String getCommandDescription() {
        return "git ls-remote --heads " + this.remoteUrl.toString();
    }

    public Map<String, GitBranch> getBranches() {
        return this.remoteBranches;
    }
}

