/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListBranchCommand
extends GitCommand {
    private final boolean all;
    private HashMap<String, GitBranch> branches;

    public ListBranchCommand(Repository repository, GitClassFactory gitFactory, boolean all, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.all = all;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        Map refs = repository.getAllRefs();
        Ref head = (Ref)refs.get("HEAD");
        this.branches = new HashMap();
        StoredConfig cfg = repository.getConfig();
        if (head != null) {
            String current = head.getLeaf().getName();
            if (current.equals("HEAD")) {
                String name = "(no branch)";
                this.branches.put(name, this.getClassFactory().createBranch(name, false, true, head.getLeaf().getObjectId()));
            }
            this.branches.putAll(this.getRefs(refs.values(), "refs/heads/", false, current, (Config)cfg));
        }
        Map<String, GitBranch> allBranches = this.getRefs(refs.values(), "refs/remotes/", true, null, (Config)cfg);
        allBranches.putAll(this.branches);
        this.setupTracking(this.branches, allBranches, (Config)repository.getConfig());
        if (this.all) {
            this.branches.putAll(allBranches);
        }
    }

    private Map<String, GitBranch> getRefs(Collection<Ref> allRefs, String prefix, boolean isRemote, String activeBranch, Config config) {
        HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>();
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith(prefix)) continue;
            String name = refName.substring(refName.indexOf(47, 5) + 1);
            branches.put(name, this.getClassFactory().createBranch(name, isRemote, refName.equals(activeBranch), ref.getLeaf().getObjectId()));
        }
        return branches;
    }

    @Override
    protected String getCommandDescription() {
        return "git branch";
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    private void setupTracking(Map<String, GitBranch> branches, Map<String, GitBranch> allBranches, Config cfg) {
        for (GitBranch b : branches.values()) {
            this.getClassFactory().setBranchTracking(b, Utils.getTrackedBranch(cfg, b.getName(), allBranches));
        }
    }
}

