/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ExportDiffCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final GitClient.DiffMode mode;
    private final OutputStream out;
    private final FileListener listener;

    public ExportDiffCommand(Repository repository, GitClassFactory gitFactory, File[] roots, GitClient.DiffMode mode, OutputStream out, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.mode = mode;
        this.out = out;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        DiffFormatter formatter = new DiffFormatter(this.out);
        formatter.setRepository(repository);
        ObjectReader or = null;
        String workTreePath = repository.getWorkTree().getAbsolutePath();
        try {
            List diffEntries;
            FileTreeIterator secondTree;
            DirCacheIterator firstTree;
            Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
            if (!pathFilters.isEmpty()) {
                formatter.setPathFilter(PathFilterGroup.create(pathFilters));
            }
            switch (this.mode) {
                case HEAD_VS_INDEX: {
                    or = repository.newObjectReader();
                    firstTree = this.getHeadIterator(or);
                    secondTree = new DirCacheIterator(repository.readDirCache());
                    break;
                }
                case HEAD_VS_WORKINGTREE: {
                    or = repository.newObjectReader();
                    firstTree = this.getHeadIterator(or);
                    secondTree = new FileTreeIterator(repository);
                    break;
                }
                case INDEX_VS_WORKINGTREE: {
                    firstTree = new DirCacheIterator(repository.readDirCache());
                    secondTree = new FileTreeIterator(repository);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown diff mode: " + (Object)((Object)this.mode));
                }
            }
            if (secondTree instanceof WorkingTreeIterator) {
                formatter.setDetectRenames(false);
                diffEntries = formatter.scan((AbstractTreeIterator)firstTree, (AbstractTreeIterator)secondTree);
                formatter.setDetectRenames(true);
                RenameDetector detector = formatter.getRenameDetector();
                detector.reset();
                detector.addAll((Collection)diffEntries);
                if (or == null) {
                    or = repository.newObjectReader();
                }
                diffEntries = detector.compute(new ContentSource.Pair(ContentSource.create((ObjectReader)or), ContentSource.create((WorkingTreeIterator)((WorkingTreeIterator)secondTree))), (org.eclipse.jgit.lib.ProgressMonitor)NullProgressMonitor.INSTANCE);
            } else {
                formatter.setDetectRenames(true);
                diffEntries = formatter.scan((AbstractTreeIterator)firstTree, (AbstractTreeIterator)secondTree);
            }
            for (DiffEntry ent : diffEntries) {
                if (this.monitor.isCanceled()) break;
                this.listener.notifyFile(new File(workTreePath + File.separator + ent.getNewPath()), ent.getNewPath());
                formatter.format(ent);
            }
            formatter.flush();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (or != null) {
                or.release();
            }
            formatter.release();
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git diff");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }

    private AbstractTreeIterator getHeadIterator(ObjectReader or) throws IOException {
        Repository repository = this.getRepository();
        ObjectId headId = repository.resolve("HEAD");
        Object headIterator = headId != null ? new CanonicalTreeParser(null, or, (AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId).getId()) : new EmptyTreeIterator();
        return headIterator;
    }
}

