/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CreateTagCommand
extends GitCommand {
    private final boolean forceUpdate;
    private final String tagName;
    private final String taggedObject;
    private final String message;
    private final boolean signed;
    private GitTag tag;

    public CreateTagCommand(Repository repository, GitClassFactory gitFactory, String tagName, String taggedObject, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.tagName = tagName;
        this.taggedObject = taggedObject;
        this.message = message;
        this.signed = signed;
        this.forceUpdate = forceUpdate;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            RevObject obj = Utils.findObject(repository, this.taggedObject);
            if ((this.message == null || this.message.isEmpty()) && !this.signed) {
                this.tag = this.createLightWeight(obj, repository);
            } else {
                TagCommand cmd = new Git(repository).tag();
                cmd.setName(this.tagName);
                cmd.setMessage(this.message);
                cmd.setObjectId(obj);
                cmd.setForceUpdate(this.forceUpdate);
                cmd.setSigned(this.signed);
                RevTag revTag = cmd.call();
                this.tag = this.getClassFactory().createTag(revTag);
            }
        }
        catch (JGitInternalException ex) {
            throw new GitException(ex);
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git tag");
        if (this.signed) {
            sb.append(" -s");
        }
        if (this.forceUpdate) {
            sb.append(" -f");
        }
        if (this.message != null && !this.message.isEmpty()) {
            sb.append(" -m ").append(this.message.replace("\n", "\\n"));
        }
        sb.append(' ').append(this.tagName);
        if (this.taggedObject != null) {
            sb.append(' ').append(this.taggedObject);
        }
        return sb.toString();
    }

    public GitTag getTag() {
        return this.tag;
    }

    private GitTag createLightWeight(RevObject revObject, Repository repository) throws GitException, IOException {
        RevWalk revWalk = new RevWalk(repository);
        try {
            String refName = "refs/tags/" + this.tagName;
            RefUpdate tagRef = repository.updateRef(refName);
            tagRef.setNewObjectId((AnyObjectId)revObject);
            tagRef.setForceUpdate(this.forceUpdate);
            tagRef.setRefLogMessage("tagged " + this.tagName, false);
            RefUpdate.Result updateResult = tagRef.update(revWalk);
            switch (updateResult) {
                case NEW: 
                case FORCED: {
                    GitTag gitTag = revObject instanceof RevCommit ? this.getClassFactory().createTag(this.tagName, this.getClassFactory().createRevisionInfo((RevCommit)revObject, repository)) : this.getClassFactory().createTag(this.tagName, revObject);
                    return gitTag;
                }
                case LOCK_FAILURE: {
                    throw new GitException.RefUpdateException("Cannot lock ref " + refName, GitRefUpdateResult.valueOf(updateResult.name()));
                }
            }
            throw new GitException.RefUpdateException("Updating ref " + refName + " failed", GitRefUpdateResult.valueOf(updateResult.name()));
        }
        finally {
            revWalk.release();
        }
    }
}

