/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class BlameCommand
extends GitCommand {
    private final String revision;
    private final File file;
    private final ProgressMonitor monitor;
    private GitBlameResult result;

    public BlameCommand(Repository repository, GitClassFactory gitFactory, File file, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.BlameCommand cmd = new Git(repository).blame();
        cmd.setFilePath(Utils.getRelativePath(this.getRepository().getWorkTree(), this.file));
        if (this.revision != null) {
            cmd.setStartCommit((AnyObjectId)Utils.findCommit(repository, this.revision));
        } else if (((WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY)).getAutoCRLF() != CoreConfig.AutoCRLF.FALSE) {
            cmd.setTextComparator((RawTextComparator)new WAComparator());
        }
        cmd.setFollowFileRenames(true);
        BlameResult cmdResult = cmd.call();
        if (cmdResult != null) {
            this.result = this.getClassFactory().createBlameResult(cmdResult, repository);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git blame -l -f ");
        if (this.revision != null) {
            sb.append(this.revision).append(" ");
        }
        sb.append(this.file);
        return sb.toString();
    }

    public GitBlameResult getResult() {
        return this.result;
    }

    private static class WAComparator
    extends RawTextComparator {
        private WAComparator() {
        }

        public boolean equals(RawText a, int ai, RawText b, int bi) {
            String line1 = a.getString(ai);
            String line2 = b.getString(bi);
            line1 = WAComparator.trimTrailingEoL(line1);
            line2 = WAComparator.trimTrailingEoL(line2);
            return line1.equals(line2);
        }

        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            end = WAComparator.trimTrailingEoL(raw, ptr, end);
            while (ptr < end) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }

        private static String trimTrailingEoL(String line) {
            int end;
            for (end = line.length() - 1; end >= 0 && WAComparator.isNewLine(line.charAt(end)); --end) {
            }
            return line.substring(0, end + 1);
        }

        private static int trimTrailingEoL(byte[] raw, int start, int end) {
            int ptr;
            for (ptr = end - 1; start <= ptr && (raw[ptr] == 13 || raw[ptr] == 10); --ptr) {
            }
            return ptr + 1;
        }

        private static boolean isNewLine(char ch) {
            return ch == '\n' || ch == '\r';
        }
    }
}

