/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.netbeans.libs.git.jgit.JGitCredentialsProvider;

public class JGitSshSessionFactory
extends JschConfigSessionFactory {
    private OpenSshConfig sshConfig;
    private static SshSessionFactory INSTANCE;
    private JSch defaultJSch;
    private final Map<String, JSch> byHostName = new HashMap<String, JSch>();

    public static synchronized SshSessionFactory getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JGitSshSessionFactory();
        }
        return INSTANCE;
    }

    protected void configure(OpenSshConfig.Host host, Session sn) {
    }

    public synchronized RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        if (credentialsProvider != null) {
            String host = uri.getHost();
            JGitCredentialsProvider.IdentityFileItem identityFile = new JGitCredentialsProvider.IdentityFileItem("Identity file for " + host, false);
            if (credentialsProvider.isInteractive() && credentialsProvider.get(uri, new CredentialItem[]{identityFile}) && identityFile.getValue() != null) {
                if (this.sshConfig == null) {
                    this.sshConfig = OpenSshConfig.get((FS)fs);
                }
                OpenSshConfig.Host hc = this.sshConfig.lookup(host);
                try {
                    JSch jsch = this.getJSch(hc, fs);
                    jsch.removeAllIdentity();
                    jsch.addIdentity(identityFile.getValue());
                }
                catch (JSchException ex) {
                    throw new TransportException(uri, ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return super.getSession(uri, credentialsProvider, fs, tms);
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        String hostName;
        JSch jsch;
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch(fs);
            this.defaultJSch.removeAllIdentity();
        }
        if ((jsch = this.byHostName.get(hostName = hc.getHostName())) == null) {
            jsch = new JSch();
            jsch.setHostKeyRepository(this.defaultJSch.getHostKeyRepository());
            this.byHostName.put(hostName, jsch);
        }
        return jsch;
    }
}

