/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRefUpdateResult;

public final class GitTransportUpdate {
    private final String localName;
    private final String remoteName;
    private final String oldObjectId;
    private final String newObjectId;
    private final GitRefUpdateResult result;
    private final String uri;
    private final Type type;

    GitTransportUpdate(URIish uri, TrackingRefUpdate update) {
        this.localName = GitTransportUpdate.stripRefs(update.getLocalName());
        this.remoteName = GitTransportUpdate.stripRefs(update.getRemoteName());
        this.oldObjectId = update.getOldObjectId() == null || ObjectId.zeroId().equals((AnyObjectId)update.getOldObjectId()) ? null : update.getOldObjectId().getName();
        this.newObjectId = update.getNewObjectId() == null || ObjectId.zeroId().equals((AnyObjectId)update.getNewObjectId()) ? null : update.getNewObjectId().getName();
        this.result = GitRefUpdateResult.valueOf(update.getResult().name());
        this.uri = uri.toString();
        this.type = this.getType(update.getLocalName());
    }

    GitTransportUpdate(URIish uri, RemoteRefUpdate update, Map<String, GitBranch> remoteBranches) {
        this.localName = GitTransportUpdate.stripRefs(update.getSrcRef());
        this.remoteName = GitTransportUpdate.stripRefs(update.getRemoteName());
        this.oldObjectId = this.getOldRevisionId(remoteBranches.get(this.remoteName));
        this.newObjectId = update.getNewObjectId() == null || ObjectId.zeroId().equals((AnyObjectId)update.getNewObjectId()) ? null : update.getNewObjectId().getName();
        this.result = GitRefUpdateResult.valueOf(update.getStatus().name());
        this.uri = uri.toString();
        this.type = this.getType(update.getRemoteName());
    }

    public String getRemoteUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getOldObjectId() {
        return this.oldObjectId;
    }

    public String getNewObjectId() {
        return this.newObjectId;
    }

    public GitRefUpdateResult getResult() {
        return this.result;
    }

    public Type getType() {
        return this.type;
    }

    private static String stripRefs(String refName) {
        if (refName != null) {
            if (refName.startsWith("refs/heads/")) {
                refName = refName.substring("refs/heads/".length());
            } else if (refName.startsWith("refs/tags/")) {
                refName = refName.substring("refs/tags/".length());
            } else if (refName.startsWith("refs/remotes/")) {
                refName = refName.substring("refs/remotes/".length());
            } else if (refName.startsWith("refs/")) {
                refName = refName.substring("refs/".length());
            } else {
                throw new IllegalArgumentException("Unknown refName: " + refName);
            }
        }
        return refName;
    }

    private Type getType(String refName) {
        Type retval;
        if (refName.startsWith("refs/tags/")) {
            retval = Type.TAG;
        } else if (refName.startsWith("refs/remotes/")) {
            retval = Type.BRANCH;
        } else if (refName.startsWith("refs/heads/")) {
            retval = Type.BRANCH;
        } else {
            throw new IllegalArgumentException("Unknown type for: " + refName);
        }
        return retval;
    }

    private String getOldRevisionId(GitBranch branch) {
        return branch == null ? null : branch.getId();
    }

    public static enum Type {
        BRANCH,
        TAG;

    }
}

