/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitClassFactoryImpl;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitUser;

public final class GitRevisionInfo {
    private RevCommit revCommit;
    private Repository repository;
    private GitFileInfo[] modifiedFiles;
    private static final Logger LOG = Logger.getLogger(GitRevisionInfo.class.getName());

    GitRevisionInfo(RevCommit commit, Repository repository) {
        this.revCommit = commit;
        this.repository = repository;
    }

    public String getRevision() {
        return ObjectId.toString((ObjectId)this.revCommit.getId());
    }

    public String getShortMessage() {
        return this.revCommit.getShortMessage();
    }

    public String getFullMessage() {
        return this.revCommit.getFullMessage();
    }

    public long getCommitTime() {
        return (long)this.revCommit.getCommitTime() * 1000L;
    }

    public GitUser getAuthor() {
        return GitClassFactoryImpl.getInstance().createUser(this.revCommit.getAuthorIdent());
    }

    public GitUser getCommitter() {
        return GitClassFactoryImpl.getInstance().createUser(this.revCommit.getCommitterIdent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, GitFileInfo> getModifiedFiles() throws GitException {
        if (this.modifiedFiles == null) {
            GitRevisionInfo gitRevisionInfo = this;
            synchronized (gitRevisionInfo) {
                this.listFiles();
            }
        }
        HashMap<File, GitFileInfo> files = new HashMap<File, GitFileInfo>(this.modifiedFiles.length);
        for (GitFileInfo info : this.modifiedFiles) {
            files.put(info.getFile(), info);
        }
        return files;
    }

    public String[] getParents() {
        String[] parents = new String[this.revCommit.getParentCount()];
        for (int i = 0; i < this.revCommit.getParentCount(); ++i) {
            parents[i] = ObjectId.toString((ObjectId)this.revCommit.getParent(i).getId());
        }
        return parents;
    }

    private void listFiles() throws GitException {
        RevWalk revWalk = new RevWalk(this.repository);
        TreeWalk walk = new TreeWalk(this.repository);
        try {
            ArrayList<GitFileInfo> result = new ArrayList<GitFileInfo>();
            walk.reset();
            walk.setRecursive(true);
            RevCommit parentCommit = null;
            if (this.revCommit.getParentCount() > 0) {
                for (RevCommit commit : this.revCommit.getParents()) {
                    revWalk.markStart(revWalk.lookupCommit((AnyObjectId)commit));
                }
                revWalk.setRevFilter(RevFilter.MERGE_BASE);
                Iterator it = revWalk.iterator();
                if (it.hasNext()) {
                    parentCommit = (RevCommit)it.next();
                }
                if (parentCommit != null) {
                    walk.addTree((AnyObjectId)parentCommit.getTree().getId());
                }
            }
            walk.addTree((AnyObjectId)this.revCommit.getTree().getId());
            walk.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.ANY_DIFF));
            if (parentCommit != null) {
                List entries = DiffEntry.scan((TreeWalk)walk);
                RenameDetector rd = new RenameDetector(this.repository);
                rd.addAll((Collection)entries);
                entries = rd.compute();
                for (DiffEntry e : entries) {
                    GitFileInfo.Status status;
                    File oldFile = null;
                    String oldPath = null;
                    String path = e.getOldPath();
                    if (path == null) {
                        path = e.getNewPath();
                    }
                    switch (e.getChangeType()) {
                        case ADD: {
                            status = GitFileInfo.Status.ADDED;
                            path = e.getNewPath();
                            break;
                        }
                        case COPY: {
                            status = GitFileInfo.Status.COPIED;
                            oldFile = new File(this.repository.getWorkTree(), e.getOldPath());
                            oldPath = e.getOldPath();
                            path = e.getNewPath();
                            break;
                        }
                        case DELETE: {
                            status = GitFileInfo.Status.REMOVED;
                            path = e.getOldPath();
                            break;
                        }
                        case MODIFY: {
                            status = GitFileInfo.Status.MODIFIED;
                            path = e.getOldPath();
                            break;
                        }
                        case RENAME: {
                            status = GitFileInfo.Status.RENAMED;
                            oldFile = new File(this.repository.getWorkTree(), e.getOldPath());
                            oldPath = e.getOldPath();
                            path = e.getNewPath();
                            break;
                        }
                        default: {
                            status = GitFileInfo.Status.UNKNOWN;
                        }
                    }
                    if (status == GitFileInfo.Status.RENAMED) {
                        result.add(new GitFileInfo(new File(this.repository.getWorkTree(), e.getOldPath()), e.getOldPath(), GitFileInfo.Status.REMOVED, null, null));
                    }
                    result.add(new GitFileInfo(new File(this.repository.getWorkTree(), path), path, status, oldFile, oldPath));
                }
            } else {
                while (walk.next()) {
                    result.add(new GitFileInfo(new File(this.repository.getWorkTree(), walk.getPathString()), walk.getPathString(), GitFileInfo.Status.ADDED, null, null));
                }
            }
            this.modifiedFiles = result.toArray(new GitFileInfo[result.size()]);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            revWalk.release();
            walk.release();
        }
    }

    public static final class GitFileInfo {
        private final String relativePath;
        private final String originalPath;
        private final Status status;
        private final File file;
        private final File originalFile;

        GitFileInfo(File file, String relativePath, Status status, File originalFile, String originalPath) {
            this.relativePath = relativePath;
            this.status = status;
            this.file = file;
            this.originalFile = originalFile;
            this.originalPath = originalPath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public String getOriginalPath() {
            return this.originalPath;
        }

        public Status getStatus() {
            return this.status;
        }

        public File getFile() {
            return this.file;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        public static enum Status {
            ADDED,
            MODIFIED,
            RENAMED,
            COPIED,
            REMOVED,
            UNKNOWN;

        }
    }
}

