/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api.validation;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.openide.filesystems.FileObject;

public final class ValidationContext {
    private String source;
    private FileObject file;
    private HtmlVersion version;
    private SyntaxAnalyzerResult result;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();

    public ValidationContext(String source, HtmlVersion version, FileObject file, SyntaxAnalyzerResult result) {
        this.source = source;
        this.file = file;
        this.version = version;
        this.result = result;
    }

    public FileObject getFile() {
        return this.file;
    }

    public String getSource() {
        return this.source;
    }

    public HtmlVersion getVersion() {
        return this.version;
    }

    public SyntaxAnalyzerResult getSyntaxAnalyzerResult() {
        return this.result;
    }

    public boolean isFeatureEnabled(String featureName) {
        Boolean val = this.features != null ? this.features.get(featureName) : null;
        return val != null ? val : false;
    }

    public void enableFeature(String featureName, boolean enabled) {
        this.features.put(featureName, enabled);
    }
}

