/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.FeaturedNode;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.elements.TreePath;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.web.common.api.LexerUtils;

public class ElementUtils {
    private static final char ELEMENT_PATH_ELEMENTS_DELIMITER = '/';
    private static final char ELEMENT_PATH_INDEX_DELIMITER = '|';
    private static final String INDENT = "   ";

    private ElementUtils() {
    }

    public static Collection<HtmlTag> getPossibleOpenTags(HtmlModel model, Element afterNode) {
        if (afterNode.type() != ElementType.OPEN_TAG) {
            return Collections.emptyList();
        }
        OpenTag openTag = (OpenTag)afterNode;
        HtmlTag tag = model.getTag(((Object)openTag.unqualifiedName()).toString());
        if (tag == null) {
            return Collections.emptyList();
        }
        while (tag != null && tag.isEmpty()) {
            if ((afterNode = afterNode.parent()) == null) {
                return Collections.emptyList();
            }
            if (afterNode.type() != ElementType.OPEN_TAG) {
                return Collections.emptyList();
            }
            OpenTag ot = (OpenTag)afterNode;
            tag = model.getTag(((Object)ot.unqualifiedName()).toString());
        }
        if (tag == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<HtmlTag> possibleChildren = new LinkedHashSet<HtmlTag>();
        ElementUtils.addPossibleTags(tag, possibleChildren);
        return possibleChildren;
    }

    public static Map<HtmlTag, OpenTag> getPossibleCloseTags(HtmlModel model, Element node) {
        if (node.type() != ElementType.OPEN_TAG && (node = node.parent()) == null) {
            return Collections.emptyMap();
        }
        OpenTag openTag = (OpenTag)node;
        String openTagName = ((Object)openTag.unqualifiedName()).toString();
        HtmlTag tag = model.getTag(openTagName);
        if (tag == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<HtmlTag, OpenTag> possible = new LinkedHashMap<HtmlTag, OpenTag>();
        do {
            if (ElementUtils.isVirtualNode(node)) continue;
            String tName = ((Object)((OpenTag)node).unqualifiedName()).toString();
            tag = model.getTag(tName);
            if (!tag.isEmpty()) {
                possible.put(tag, (OpenTag)node);
            }
            if (!tag.hasOptionalEndTag()) break;
        } while ((node = node.parent()) != null && node.type() == ElementType.OPEN_TAG);
        return possible;
    }

    private static void addPossibleTags(HtmlTag tag, Collection<HtmlTag> possible) {
        Collection<HtmlTag> children = tag.getChildren();
        possible.addAll(children);
        for (HtmlTag child : children) {
            if (!child.hasOptionalOpenTag()) continue;
            ElementUtils.addPossibleTags(child, possible);
        }
    }

    public static String getNamespace(Element element) {
        FeaturedNode root = ElementUtils.getRoot(element);
        return (String)root.getProperty("namespace");
    }

    public static Node findBySemanticRange(Node node, int offset, boolean forward) {
        for (OpenTag child : node.children(OpenTag.class)) {
            Node n;
            if (ElementUtils.isVirtualNode(child) && (n = ElementUtils.findBySemanticRange(child, offset, forward)) != null) {
                return n;
            }
            if (!ElementUtils.matchesNodeRange(child, offset, forward, false)) continue;
            return ElementUtils.findBySemanticRange(child, offset, forward);
        }
        return ElementUtils.isVirtualNode(node) ? null : node;
    }

    public static Element findByPhysicalRange(Node base, int offset, boolean forward) {
        for (Element child : base.children()) {
            Node childNode;
            Element candidate;
            if (ElementUtils.matchesNodeRange(child, offset, forward, true)) {
                return child;
            }
            if (base.from() > offset) {
                return null;
            }
            if (!(child instanceof Node) || (candidate = ElementUtils.findByPhysicalRange(childNode = (Node)child, offset, forward)) == null) continue;
            return candidate;
        }
        return null;
    }

    public static boolean isVirtualNode(Element node) {
        return node.from() == -1 && node.to() == -1;
    }

    private static boolean matchesNodeRange(Element node, int offset, boolean forward, boolean physicalNodeRangeOnly) {
        int to;
        int lt;
        int lf;
        switch (node.type()) {
            case OPEN_TAG: {
                OpenTag t = (OpenTag)node;
                lf = t.from();
                lt = t.semanticEnd();
                break;
            }
            default: {
                lf = node.from();
                lt = node.to();
            }
        }
        int from = physicalNodeRangeOnly || lf == -1 ? node.from() : lf;
        int n = to = physicalNodeRangeOnly || lt == -1 ? node.to() : lt;
        return forward ? offset >= from && offset < to : offset > from && offset <= to;
    }

    public static String dumpTree(Element node) {
        return ElementUtils.dumpTree(node, (CharSequence)null);
    }

    public static String dumpTree(Element node, CharSequence source) {
        StringBuffer buf = new StringBuffer();
        ElementUtils.dumpTree(node, buf, source);
        System.out.println(buf.toString());
        return buf.toString();
    }

    public static void dumpTree(Element node, StringBuffer buf) {
        ElementUtils.dumpTree(node, buf, null);
    }

    public static void dumpTree(Element node, StringBuffer buf, CharSequence source) {
        ElementUtils.dump(node, "", buf, source);
    }

    private static void dump(Element element, String prefix, StringBuffer buf, CharSequence source) {
        buf.append(prefix);
        buf.append(element.toString());
        if (source != null && element.from() != -1 && element.to() != -1) {
            buf.append(" (");
            buf.append(source.subSequence(element.from(), element.to()));
            buf.append(")");
        }
        buf.append('\n');
        if (element instanceof Node) {
            Node node = (Node)element;
            for (Element child : node.children()) {
                ElementUtils.dump(child, prefix + INDENT, buf, source);
            }
        }
    }

    public static FeaturedNode getRoot(Element node) {
        while (node.parent() != null) {
            node = node.parent();
        }
        return (FeaturedNode)node;
    }

    public static List<Node> getAncestors(Node node, ElementFilter filter) {
        ArrayList<Node> matching = new ArrayList<Node>();
        Node n = node;
        do {
            if (!filter.accepts(n)) continue;
            matching.add(n);
        } while ((n = n.parent()) != null);
        return matching;
    }

    public static List<Element> getChildrenRecursivelly(Element element, ElementFilter filter, boolean recurseOnlyMatching) {
        ArrayList<Element> matching = new ArrayList<Element>();
        ElementUtils.getChildrenRecursivelly(matching, element, filter, recurseOnlyMatching);
        return matching;
    }

    private static void getChildrenRecursivelly(List<Element> found, Element element, ElementFilter filter, boolean recurseOnlyMatching) {
        if (!(element instanceof Node)) {
            return;
        }
        Node node = (Node)element;
        for (Element child : node.children()) {
            if (filter.accepts(child)) {
                found.add(child);
                ElementUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
                continue;
            }
            if (recurseOnlyMatching) continue;
            ElementUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
        }
    }

    public static String encodeToString(TreePath treePath) {
        StringBuilder sb = new StringBuilder();
        List<Element> p = treePath.path();
        for (int i = p.size() - 2; i >= 0; --i) {
            Element node = p.get(i);
            Node parent = node.parent();
            int myIndex = parent == null ? 0 : ElementUtils.getIndexInSimilarNodes(node.parent(), node);
            sb.append(node.id());
            if (myIndex > 0) {
                sb.append('|');
                sb.append(myIndex);
            }
            if (i <= 0) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    private static int getIndexInSimilarNodes(Node parent, Element node) {
        int index = -1;
        for (Element child : parent.children()) {
            if (node.id().equals(child.id()) && node.type() == child.type()) {
                ++index;
            }
            if (child != node) continue;
            break;
        }
        return index;
    }

    public static OpenTag query(Node base, String path) {
        return ElementUtils.query(base, path, false);
    }

    public static OpenTag query(Node base, String path, boolean caseInsensitive) {
        StringTokenizer st = new StringTokenizer(path, Character.toString('/'));
        Node found = base;
        while (st.hasMoreTokens()) {
            String nodeName;
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String string = nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            if (caseInsensitive) {
                nodeName = nodeName.toLowerCase(Locale.ENGLISH);
            }
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1, token.length()) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            OpenTag foundLocal = null;
            for (Element child : found.children(ElementType.OPEN_TAG)) {
                OpenTag openTag = (OpenTag)child;
                if (!LexerUtils.equals((CharSequence)openTag.name(), (CharSequence)nodeName, (boolean)caseInsensitive, (boolean)false) || count++ != index) continue;
                foundLocal = openTag;
                break;
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                OpenTag openTag = (OpenTag)found;
                assert (LexerUtils.equals((CharSequence)openTag.name(), (CharSequence)nodeName, (boolean)false, (boolean)false));
                return openTag;
            }
            return null;
        }
        return null;
    }

    public static boolean isDescendant(Node ancestor, Node descendant) {
        if (ancestor == descendant) {
            return false;
        }
        Node node = descendant;
        while ((node = node.parent()) != null) {
            if (ancestor != node) continue;
            return true;
        }
        return false;
    }

    public static void visitChildren(Element element, ElementVisitor visitor, ElementType nodeType) {
        if (!(element instanceof Node)) {
            return;
        }
        Node node = (Node)element;
        for (Element n : node.children()) {
            if (nodeType == null || n.type() == nodeType) {
                visitor.visit(n);
            }
            ElementUtils.visitChildren(n, visitor, nodeType);
        }
    }

    public static void visitChildren(Node node, ElementVisitor visitor) {
        ElementUtils.visitChildren(node, visitor, null);
    }

    public static void visitAncestors(Element node, ElementVisitor visitor) {
        Node parent = node.parent();
        if (parent != null) {
            visitor.visit(parent);
            ElementUtils.visitAncestors(parent, visitor);
        }
    }
}

