/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.ElementsIteratorHandle;
import org.netbeans.modules.html.editor.lib.ElementsParserCache;
import org.netbeans.modules.html.editor.lib.EmptyResult;
import org.netbeans.modules.html.editor.lib.HtmlSourceVersionQuery;
import org.netbeans.modules.html.editor.lib.XmlSyntaxTreeBuilder;
import org.netbeans.modules.html.editor.lib.api.DefaultParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParser;
import org.netbeans.modules.html.editor.lib.api.HtmlParserFactory;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.MaskedAreas;
import org.netbeans.modules.html.editor.lib.api.ParseException;
import org.netbeans.modules.html.editor.lib.api.ParseResult;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzer;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerElements;
import org.netbeans.modules.html.editor.lib.api.UndeclaredContentResolver;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Declaration;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SyntaxAnalyzerResult {
    private static final Logger LOG = Logger.getLogger(SyntaxAnalyzerResult.class.getSimpleName());
    private AtomicReference<Declaration> declaration;
    private HtmlVersion detectedHtmlVersion;
    private HtmlParseResult htmlParseResult;
    private Map<String, ParseResult> embeddedCodeParseResults;
    private Map<String, Collection<String>> namespaces;
    private ParseResult undeclaredEmbeddedCodeParseResult;
    private Set<String> allPrefixes;
    private UndeclaredContentResolver resolver;
    private HtmlSource source;
    private ElementsParserCache elementsParserCache;
    private static final char REPLACE_CHAR = ' ';

    SyntaxAnalyzerResult(HtmlSource source) {
        this(source, null);
    }

    SyntaxAnalyzerResult(HtmlSource source, UndeclaredContentResolver resolver) {
        this.source = source;
        this.resolver = resolver;
    }

    public HtmlSource getSource() {
        return this.source;
    }

    public Iterator<Element> getElementsIterator() {
        return this.getElementsParserCache().createElementsIterator();
    }

    private synchronized ElementsParserCache getElementsParserCache() {
        if (this.elementsParserCache == null) {
            CharSequence sourceCode = this.source.getSourceCode();
            Snapshot snapshot = this.source.getSnapshot();
            TokenHierarchy hi = snapshot != null ? snapshot.getTokenHierarchy() : TokenHierarchy.create((CharSequence)sourceCode, (Language)HTMLTokenId.language());
            TokenSequence tokenSequence = hi.tokenSequence(HTMLTokenId.language());
            this.elementsParserCache = new ElementsParserCache(this.source.getSourceCode(), (TokenSequence<HTMLTokenId>)tokenSequence);
        }
        return this.elementsParserCache;
    }

    @Deprecated
    public SyntaxAnalyzerElements getElements() {
        return SyntaxAnalyzer.create(this.source).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlVersion getHtmlVersion() {
        HtmlVersion detected;
        long start;
        block3: {
            HtmlVersion htmlVersion;
            start = System.currentTimeMillis();
            try {
                detected = this.getDetectedHtmlVersion();
                HtmlVersion found = HtmlSourceVersionQuery.getSourceCodeVersion(this, detected);
                if (found == null) break block3;
                htmlVersion = found;
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                this.log(String.format("getHtmlVersion() took %s ms.", end - start));
                throw throwable;
            }
            long end = System.currentTimeMillis();
            this.log(String.format("getHtmlVersion() took %s ms.", end - start));
            return htmlVersion;
        }
        HtmlVersion htmlVersion = detected != null ? detected : (this.mayBeXhtml() ? HtmlVersion.getDefaultXhtmlVersion() : HtmlVersion.getDefaultVersion());
        long end = System.currentTimeMillis();
        this.log(String.format("getHtmlVersion() took %s ms.", end - start));
        return htmlVersion;
    }

    public HtmlModel getHtmlModel() {
        return HtmlModelFactory.getModel(this.getHtmlVersion());
    }

    public synchronized HtmlVersion getDetectedHtmlVersion() {
        if (this.detectedHtmlVersion == null) {
            this.detectedHtmlVersion = this.detectHtmlVersion();
        }
        return this.detectedHtmlVersion;
    }

    public boolean mayBeXhtml() {
        FileObject fo = this.getSource().getSourceFileObject();
        String mimeType = fo != null ? fo.getMIMEType() : null;
        return this.getHtmlTagDefaultNamespace() != null || "text/xhtml".equals(mimeType);
    }

    private HtmlVersion detectHtmlVersion() {
        Declaration doctypeDeclaration = this.getDoctypeDeclaration();
        if (doctypeDeclaration == null) {
            return null;
        }
        String publicId = this.getPublicID();
        String namespace = this.getHtmlTagDefaultNamespace();
        return HtmlVersion.find(publicId, namespace);
    }

    public Collection<ParseResult> getAllParseResults() throws ParseException {
        ArrayList<ParseResult> all = new ArrayList<ParseResult>();
        all.add(this.parseHtml());
        for (String ns : this.getAllDeclaredNamespaces().keySet()) {
            all.add(this.parseEmbeddedCode(ns));
        }
        all.add(this.parseUndeclaredEmbeddedCode());
        return all;
    }

    public synchronized HtmlParseResult parseHtml() throws ParseException {
        if (this.htmlParseResult == null) {
            this.htmlParseResult = this.doParseHtml();
        }
        return this.htmlParseResult;
    }

    private HtmlParser findParser() {
        HtmlVersion version = this.getHtmlVersion();
        HtmlParser parser = HtmlParserFactory.findParser(version);
        if (parser == null) {
            throw new IllegalStateException("Cannot find an HtmlParser implementation for " + this.getHtmlVersion().name());
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlParseResult doParseHtml() throws ParseException {
        HtmlParseResult htmlParseResult;
        this.log("doParseHtml()...");
        long start = System.currentTimeMillis();
        long justParsingStart = 0L;
        try {
            HtmlVersion version = this.getHtmlVersion();
            HtmlParser parser = this.findParser();
            final Collection<String> prefixes = version.getDefaultNamespace() != null ? this.getAllDeclaredNamespaces().get(version.getDefaultNamespace()) : null;
            Iterator<Element> original = this.getElementsIterator();
            final FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

                @Override
                public boolean accepts(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: 
                        case CLOSE_TAG: {
                            Named named = (Named)node;
                            CharSequence prefix = named.namespacePrefix();
                            if (prefix == null) {
                                return true;
                            }
                            return prefixes != null && prefixes.contains(((Object)prefix).toString());
                        }
                        default: {
                            return true;
                        }
                    }
                }
            });
            MaskedAreas maskedAreas = this.findMaskedAreas(new TagsFilter(){

                @Override
                public boolean accepts(Named tag, CharSequence prefix) {
                    if (prefix == null) {
                        return true;
                    }
                    return prefixes != null && prefixes.contains(((Object)prefix).toString());
                }
            });
            HtmlSource newSource = new HtmlSource(this.source.getSourceCode(), this.source.getSnapshot(), this.source.getSourceFileObject());
            InstanceContent content = new InstanceContent();
            content.add((Object)maskedAreas);
            content.add((Object)new ElementsIteratorHandle(){

                @Override
                public Iterator<Element> getIterator() {
                    return filteredIterator;
                }
            });
            AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)content);
            justParsingStart = System.currentTimeMillis();
            this.log("really parsing...");
            htmlParseResult = parser.parse(newSource, this.getHtmlVersion(), (Lookup)lookup);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("doParseHtml() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("doParseHtml() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
        return htmlParseResult;
    }

    public synchronized ParseResult parseEmbeddedCode(String namespace) throws ParseException {
        ParseResult result;
        if (this.embeddedCodeParseResults == null) {
            this.embeddedCodeParseResults = new HashMap<String, ParseResult>();
        }
        if ((result = this.embeddedCodeParseResults.get(namespace)) == null) {
            result = this.doParseEmbeddedCode(namespace);
            this.embeddedCodeParseResults.put(namespace, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult doParseEmbeddedCode(String namespace) throws ParseException {
        Collection<String> prefixes;
        long justParsingStart;
        long start;
        block3: {
            EmptyResult emptyResult;
            start = System.currentTimeMillis();
            justParsingStart = 0L;
            try {
                prefixes = this.getAllDeclaredNamespaces().get(namespace);
                if (prefixes != null && !prefixes.isEmpty()) break block3;
                emptyResult = new EmptyResult(this.getSource());
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
                throw throwable;
            }
            long end = System.currentTimeMillis();
            this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
            return emptyResult;
        }
        Iterator<Element> original = this.getElementsIterator();
        FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

            @Override
            public boolean accepts(Element node) {
                switch (node.type()) {
                    case OPEN_TAG: 
                    case CLOSE_TAG: {
                        Named named = (Named)node;
                        CharSequence prefix = named.namespacePrefix();
                        return prefix != null && prefixes.contains(((Object)prefix).toString());
                    }
                    default: {
                        return true;
                    }
                }
            }
        });
        justParsingStart = System.currentTimeMillis();
        Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, namespace, filteredIterator);
        DefaultParseResult defaultParseResult = new DefaultParseResult(this.source, root, Collections.<ProblemDescription>emptyList());
        long end = System.currentTimeMillis();
        this.log(String.format("doParseEmbeddedCode() took %s ms (clear parsing time %s)", end - start, end - justParsingStart));
        return defaultParseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseResult parsePlain() {
        DefaultParseResult defaultParseResult;
        long start = System.currentTimeMillis();
        try {
            Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, null, this.getElementsIterator());
            defaultParseResult = new DefaultParseResult(this.source, root, Collections.<ProblemDescription>emptyList());
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("parsePlain() took %s ms", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("parsePlain() took %s ms", end - start));
        return defaultParseResult;
    }

    public ParseResult parseUndeclaredEmbeddedCode() throws ParseException {
        if (this.undeclaredEmbeddedCodeParseResult == null) {
            this.undeclaredEmbeddedCodeParseResult = this.doParseUndeclaredEmbeddedCode();
        }
        return this.undeclaredEmbeddedCodeParseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult doParseUndeclaredEmbeddedCode() throws ParseException {
        DefaultParseResult defaultParseResult;
        long start = System.currentTimeMillis();
        try {
            final Set<String> prefixes = this.getAllDeclaredPrefixes();
            Iterator<Element> original = this.getElementsIterator();
            FilteredIterator filteredIterator = new FilteredIterator(original, new ElementFilter(){

                @Override
                public boolean accepts(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: 
                        case CLOSE_TAG: {
                            Named named = (Named)node;
                            CharSequence prefix = named.namespacePrefix();
                            return prefix != null && !prefixes.contains(((Object)prefix).toString());
                        }
                        default: {
                            return true;
                        }
                    }
                }
            });
            Node root = XmlSyntaxTreeBuilder.makeUncheckedTree(this.source, null, filteredIterator);
            defaultParseResult = new DefaultParseResult(this.source, root, Collections.<ProblemDescription>emptyList());
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("doParseUndeclaredEmbeddedCode() took %s ms", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("doParseUndeclaredEmbeddedCode() took %s ms", end - start));
        return defaultParseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaskedAreas findMaskedAreas(TagsFilter filter) {
        MaskedAreas maskedAreas;
        this.log("findMaskedAreas...");
        long start = System.currentTimeMillis();
        try {
            ArrayList<MaskedArea> ignoredAreas = new ArrayList<MaskedArea>();
            Iterator<Element> itr = this.getElementsIterator();
            while (itr.hasNext()) {
                Element e = itr.next();
                if (e.type() != ElementType.OPEN_TAG && e.type() != ElementType.CLOSE_TAG) continue;
                Named tag = (Named)e;
                CharSequence tagNamePrefix = tag.namespacePrefix();
                if (filter.accepts(tag, tagNamePrefix)) {
                    if (e.type() != ElementType.OPEN_TAG) continue;
                    OpenTag ot = (OpenTag)tag;
                    for (Attribute a : ot.attributes()) {
                        CharSequence value;
                        if (!LexerUtils.startsWith((CharSequence)a.name(), (CharSequence)"xmlns:", (boolean)true, (boolean)false) || (value = a.value()) == null) continue;
                        ignoredAreas.add(new MaskedArea(a.nameOffset(), a.valueOffset() + value.length()));
                    }
                    continue;
                }
                ignoredAreas.add(new MaskedArea(e.from(), e.to()));
            }
            int[] positions = new int[ignoredAreas.size()];
            int[] lens = new int[ignoredAreas.size()];
            for (int i = 0; i < positions.length; ++i) {
                MaskedArea ia = (MaskedArea)ignoredAreas.get(i);
                positions[i] = ia.from;
                lens[i] = ia.to - ia.from;
            }
            maskedAreas = new MaskedAreas(positions, lens);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("findMaskedAreas() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("findMaskedAreas() took %s ms.", end - start));
        return maskedAreas;
    }

    public String getPublicID() {
        Declaration decl = this.getDoctypeDeclaration();
        if (decl == null) {
            return null;
        }
        CharSequence pid = this.getDoctypeDeclaration().publicId();
        return pid == null ? null : ((Object)pid).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Declaration getDoctypeDeclaration() {
        Declaration declaration;
        long start = System.currentTimeMillis();
        try {
            if (this.declaration == null) {
                Declaration declarationElement = null;
                int limitCountdown = 20;
                Iterator<Element> elementsIterator = this.getElementsIterator();
                while (elementsIterator.hasNext() && limitCountdown-- != 0) {
                    Element e = elementsIterator.next();
                    if (e.type() != ElementType.DECLARATION) continue;
                    Declaration decl = (Declaration)e;
                    if (!SyntaxAnalyzerResult.isValidDoctype(decl)) break;
                    declarationElement = (Declaration)e;
                    break;
                }
                this.declaration = new AtomicReference<Object>(declarationElement);
            }
            declaration = this.declaration.get();
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("getDoctypeDeclaration() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("getDoctypeDeclaration() took %s ms.", end - start));
        return declaration;
    }

    private static boolean isValidDoctype(Declaration decl) {
        return "doctype".equalsIgnoreCase(((Object)decl.declarationName()).toString()) && decl.rootElementName() != null;
    }

    @Deprecated
    public Map<String, String> getDeclaredNamespaces() {
        Map<String, Collection<String>> all = this.getAllDeclaredNamespaces();
        HashMap<String, String> firstPrefixOnly = new HashMap<String, String>();
        for (String namespace : all.keySet()) {
            Collection<String> prefixes = all.get(namespace);
            if (prefixes == null || prefixes.size() <= 0) continue;
            firstPrefixOnly.put(namespace, prefixes.iterator().next());
        }
        return firstPrefixOnly;
    }

    public synchronized Set<String> getAllDeclaredPrefixes() {
        if (this.allPrefixes == null) {
            this.allPrefixes = this.findAllDeclaredPrefixes();
        }
        return this.allPrefixes;
    }

    private Set<String> findAllDeclaredPrefixes() {
        HashSet<String> all = new HashSet<String>();
        for (Collection<String> prefixes : this.getAllDeclaredNamespaces().values()) {
            all.addAll(prefixes);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHtmlTagDefaultNamespace() {
        block4: {
            this.log("getHtmlTagDefaultNamespace()...");
            start = System.currentTimeMillis();
            try {
                limitCountdown = 100;
                elementsIterator = this.getElementsIterator();
                while (elementsIterator.hasNext() && limitCountdown-- != 0) {
                    se = elementsIterator.next();
                    if (se.type() != ElementType.OPEN_TAG || (xmlns = (tag = (OpenTag)se).getAttribute("xmlns")) == null || (value = xmlns.unquotedValue()) == null) continue;
                    var9_9 = value.toString();
                    break block4;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var12_11) {
                end = System.currentTimeMillis();
                this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
                throw var12_11;
            }
        }
        end = System.currentTimeMillis();
        this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
        return var9_9;
lbl-1000:
        // 1 sources

        {
            var5_4 = null;
        }
        end = System.currentTimeMillis();
        this.log(String.format("getHtmlTagDefaultNamespace() took %s ms.", new Object[]{end - start}));
        return var5_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Collection<String>> getAllDeclaredNamespaces() {
        Map<String, Collection<String>> map;
        this.log("getAllDeclaredNamespaces...");
        long start = System.currentTimeMillis();
        try {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, Collection<String>>();
                if (this.resolver != null) {
                    this.namespaces.putAll(this.resolver.getUndeclaredNamespaces(this.getSource()));
                }
                Iterator<Element> iterator = this.getElementsIterator();
                while (iterator.hasNext()) {
                    Element se = iterator.next();
                    if (se.type() != ElementType.OPEN_TAG) continue;
                    OpenTag tag = (OpenTag)se;
                    for (Attribute attr : tag.attributes()) {
                        String nsPrefix;
                        String attrName = ((Object)attr.name()).toString();
                        if (!attrName.startsWith("xmlns")) continue;
                        int colonIndex = attrName.indexOf(58);
                        String string = nsPrefix = colonIndex == -1 ? null : attrName.substring(colonIndex + 1);
                        CharSequence value = attr.unquotedValue();
                        if (value == null) continue;
                        String key = ((Object)value).toString();
                        Collection<String> prefixes = this.namespaces.get(key);
                        if (prefixes == null) {
                            prefixes = new LinkedList<String>();
                            prefixes.add(nsPrefix);
                            this.namespaces.put(key, prefixes);
                            continue;
                        }
                        if (prefixes.contains(key)) continue;
                        prefixes.add(nsPrefix);
                    }
                }
            }
            map = this.namespaces;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.log(String.format("getAllDeclaredNamespaces() took %s ms.", end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log(String.format("getAllDeclaredNamespaces() took %s ms.", end - start));
        return map;
    }

    private void log(String message) {
        LOG.log(Level.FINE, "HtmlSource(" + this.source.hashCode() + "):" + message);
    }

    private static class FilteredIterator
    implements Iterator<Element> {
        private Iterator<Element> source;
        private ElementFilter filter;
        private Element next;

        public FilteredIterator(Iterator<Element> source, ElementFilter filter) {
            this.source = source;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.source.hasNext();
            if (!hasNext) {
                return false;
            }
            while (this.source.hasNext()) {
                this.next = this.source.next();
                if (!this.filter.accepts(this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Element next() {
            return this.next;
        }

        @Override
        public void remove() {
        }
    }

    private static class MaskedArea {
        int from;
        int to;

        public MaskedArea(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    private static interface TagsFilter {
        public boolean accepts(Named var1, CharSequence var2);
    }
}

