/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.html.editor.lib.XmlSTElements;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.web.common.api.LexerUtils;

public class XmlSyntaxTreeBuilder {
    public static Node makeUncheckedTree(HtmlSource source, String namespace, Iterator<Element> elements) {
        assert (elements != null) : "passed elements list cannot but null";
        int lastEndOffset = source.getSourceCode().length();
        XmlSTElements.Root rootNode = new XmlSTElements.Root(namespace, lastEndOffset);
        LinkedList<XmlSTElements.OT> stack = new LinkedList<XmlSTElements.OT>();
        stack.add(rootNode);
        while (elements.hasNext()) {
            Element element = elements.next();
            if (element.type() == ElementType.OPEN_TAG) {
                OpenTag plainOpenTag = (OpenTag)element;
                XmlSTElements.EmptyOT openTagNode = plainOpenTag.isEmpty() ? new XmlSTElements.EmptyOT(plainOpenTag.attributes(), plainOpenTag.name(), plainOpenTag.from(), plainOpenTag.to()) : new XmlSTElements.OT(plainOpenTag.attributes(), plainOpenTag.name(), plainOpenTag.from(), plainOpenTag.to());
                XmlSTElements.OT peek = (XmlSTElements.OT)stack.getLast();
                if (!plainOpenTag.isEmpty()) {
                    stack.addLast((XmlSTElements.OT)openTagNode);
                }
                peek.addChild(openTagNode);
                continue;
            }
            if (element.type() != ElementType.CLOSE_TAG) continue;
            CloseTag plainElement = (CloseTag)element;
            CharSequence tagName = plainElement.name();
            XmlSTElements.ET endTagNode = new XmlSTElements.ET(plainElement.name(), plainElement.from(), plainElement.to());
            int matched_index = -1;
            for (int i = stack.size() - 1; i >= 0; --i) {
                OpenTag node = (OpenTag)stack.get(i);
                if (!LexerUtils.equals((CharSequence)tagName, (CharSequence)node.name(), (boolean)false, (boolean)false)) continue;
                matched_index = i;
                break;
            }
            assert (matched_index != 0);
            if (matched_index > 0) {
                XmlSTElements.OT match = (XmlSTElements.OT)stack.get(matched_index);
                for (int i = stack.size() - 1; i > matched_index; --i) {
                    XmlSTElements.OT node = (XmlSTElements.OT)stack.get(i);
                    node.setLogicalEndOffset(endTagNode.from());
                    stack.remove(i);
                }
                XmlSTElements.OT match_parent = (XmlSTElements.OT)stack.get(matched_index - 1);
                match_parent.addChild(endTagNode);
                match.setMatchingEndTag(endTagNode);
                match.setLogicalEndOffset(endTagNode.to());
                endTagNode.setMatchingOpenTag(match);
                stack.removeLast();
                continue;
            }
            ((XmlSTElements.OT)stack.getLast()).addChild(endTagNode);
        }
        for (int i = stack.size() - 1; i > 0; --i) {
            XmlSTElements.OT node = (XmlSTElements.OT)stack.get(i);
            node.setLogicalEndOffset(lastEndOffset);
        }
        return rootNode;
    }
}

