/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.LivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public class SnapshotLivenessResultsPanel
extends LivenessResultsPanel
implements ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_GoSourcePopupItem");
    private static final String STACK_TRACES_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_StackTracesPopupItem");
    private JMenuItem popupShowStacks;
    private JPopupMenu popup;
    private LivenessMemoryResultsSnapshot snapshot;
    private int allocTrackEvery;

    public SnapshotLivenessResultsPanel(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler, int n) {
        super(memoryResUserActionsHandler);
        this.snapshot = livenessMemoryResultsSnapshot;
        this.allocTrackEvery = n;
        this.fetchResultsFromSnapshot();
        this.initColumnsData();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        }
    }

    protected String getClassName(int n) {
        return this.snapshot.getClassName(n);
    }

    protected String[] getClassNames() {
        return this.snapshot.getClassNames();
    }

    protected int getPercentsTracked() {
        return 100 / this.allocTrackEvery;
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            if (this.snapshot.containsStacks()) {
                this.popup.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(STACK_TRACES_POPUP_ITEM);
                this.popup.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
        }
        return this.popup;
    }

    protected void performDefaultAction(int n) {
    }

    private void fetchResultsFromSnapshot() {
        this.nTrackedAllocObjects = UIUtils.copyArray(this.snapshot.getNTrackedAllocObjects());
        this.nTrackedLiveObjects = UIUtils.copyArray(this.snapshot.getNTrackedLiveObjects());
        this.trackedLiveObjectsSize = UIUtils.copyArray(this.snapshot.getTrackedLiveObjectsSize());
        this.nTotalAllocObjects = UIUtils.copyArray(this.snapshot.getnTotalAllocObjects());
        this.avgObjectAge = UIUtils.copyArray(this.snapshot.getAvgObjectAge());
        this.maxSurvGen = UIUtils.copyArray(this.snapshot.getMaxSurvGen());
        this.nInstrClasses = this.snapshot.getNInstrClasses();
        this.nTrackedItems = this.snapshot.getNTrackedItems();
        this.maxValue = this.snapshot.getMaxValue();
        this.nTotalTrackedBytes = this.snapshot.getNTotalTrackedBytes();
        this.nTotalTracked = this.snapshot.getNTotalTracked();
        this.initDataUponResultsFetch();
    }
}

