/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public abstract class ReverseMemCallGraphPanel
extends ResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String METHOD_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_MethodColumnName");
    private static final String LIVE_BYTES_REL_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveBytesRelColumnName");
    private static final String LIVE_BYTES_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveBytesColumnName");
    private static final String LIVE_OBJECTS_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveObjectsColumnName");
    private static final String ALLOC_OBJECTS_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_AllocObjectsColumnName");
    private static final String AVG_AGE_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_AvgAgeColumnName");
    private static final String SURVGEN_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_SurvGenColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_MethodColumnToolTip");
    private static final String LIVE_BYTES_REL_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveBytesRelColumnToolTip");
    private static final String LIVE_BYTES_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveBytesColumnToolTip");
    private static final String LIVE_OBJECTS_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveObjectsColumnToolTip");
    private static final String ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_AllocObjectsColumnToolTip");
    private static final String AVG_AGE_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_AvgAgeColumnToolTip");
    private static final String SURVGEN_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_SurvGenColumnToolTip");
    private static final String BYTES_ALLOC_REL_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_BytesAllocRelColumnName");
    private static final String BYTES_ALLOC_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_BytesAllocColumnName");
    private static final String OBJECTS_ALLOC_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_ObjectsAllocColumnName");
    private static final String BYTES_ALLOC_REL_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_BytesAllocRelColumnToolTip");
    private static final String BYTES_ALLOC_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_BytesAllocColumnToolTip");
    private static final String OBJECTS_ALLOC_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_ObjectsAllocColumnToolTip");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("ReverseMemCallGraphPanel_GoSourcePopupItem");
    protected ExtendedTreeTableModel treeTableModel;
    protected JButton cornerButton;
    protected JPopupMenu headerPopup;
    protected JPopupMenu popupMenu;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected MemoryResUserActionsHandler actionsHandler;
    protected TreePath treePath;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected int[] columnWidths;
    protected boolean extendedResults;
    protected int columnCount = 0;
    protected int minNamesColumnWidth;
    CustomBarCellRenderer customBarCellRenderer;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ImageIcon leafIcon = new ImageIcon(ReverseMemCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));
    private ImageIcon nodeIcon = new ImageIcon(ReverseMemCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));

    public ReverseMemCallGraphPanel(MemoryResUserActionsHandler memoryResUserActionsHandler, boolean bl) {
        this.extendedResults = bl;
        this.actionsHandler = memoryResUserActionsHandler;
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.headerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.headerPopup);
        this.popupMenu = this.initPopupMenu();
        this.initColumnsData();
    }

    public void setFindString(String string) {
        if (this.treeTable != null) {
            this.treeTable.setFindParameters(string, 0);
        }
    }

    public String getFindString() {
        if (this.treeTable == null) {
            return null;
        }
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.isFindStringDefined();
    }

    public boolean findFirst() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findPrevious();
    }

    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReverseMemCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    protected void setColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.treeTable != null) {
                boolean bl = this.treeTableModel.isRealColumnVisible(i);
                jCheckBoxMenuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.headerPopup.add(jCheckBoxMenuItem);
        }
        this.headerPopup.pack();
    }

    protected JPopupMenu initPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    void performDefaultAction(TreePath treePath) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treePath.getLastPathComponent();
        String[] stringArray = presoObjAllocCCTNode.getMethodClassNameAndSig();
        this.actionsHandler.showSourceForMethod(stringArray[0], stringArray[1], stringArray[2]);
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                boolean bl2 = ReverseMemCallGraphPanel.this.treeTable.getSortingOrder();
                int n2 = ReverseMemCallGraphPanel.this.treeTable.getSortingColumn();
                int n3 = ReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                boolean bl3 = ReverseMemCallGraphPanel.this.treeTableModel.isRealColumnVisible(n);
                if (bl3 && n == n3) {
                    n2 = n2 + 1 == ReverseMemCallGraphPanel.this.treeTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = ReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                    bl = true;
                }
                ReverseMemCallGraphPanel.this.treeTableModel.setRealColumnVisibility(n, !bl3);
                ReverseMemCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                ReverseMemCallGraphPanel.this.treeTable.updateTreeTableHeader();
                n2 = ReverseMemCallGraphPanel.this.treeTableModel.getVirtualColumn(n3);
                if (bl) {
                    bl2 = ReverseMemCallGraphPanel.this.treeTableModel.getInitialSorting(n2);
                    ReverseMemCallGraphPanel.this.treeTableModel.sortByColumn(n2, bl2);
                    ReverseMemCallGraphPanel.this.treeTable.updateTreeTable();
                }
                ReverseMemCallGraphPanel.this.treeTable.setSortingColumn(n2);
                ReverseMemCallGraphPanel.this.treeTable.setSortingOrder(bl2);
                ReverseMemCallGraphPanel.this.treeTable.getTableHeader().repaint();
                ReverseMemCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void initColumnsData() {
        int n;
        if (this.extendedResults) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, LIVE_BYTES_REL_COLUMN_NAME, LIVE_BYTES_COLUMN_NAME, LIVE_OBJECTS_COLUMN_NAME, ALLOC_OBJECTS_COLUMN_NAME, AVG_AGE_COLUMN_NAME, SURVGEN_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, LIVE_BYTES_REL_COLUMN_TOOLTIP, LIVE_BYTES_COLUMN_TOOLTIP, LIVE_OBJECTS_COLUMN_TOOLTIP, ALLOC_OBJECTS_COLUMN_TOOLTIP, AVG_AGE_COLUMN_TOOLTIP, SURVGEN_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, BYTES_ALLOC_REL_COLUMN_NAME, BYTES_ALLOC_COLUMN_NAME, OBJECTS_ALLOC_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, BYTES_ALLOC_REL_COLUMN_TOOLTIP, BYTES_ALLOC_COLUMN_TOOLTIP, OBJECTS_ALLOC_COLUMN_TOOLTIP};
        }
        this.columnCount = this.columnNames.length;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        int n2 = this.extendedResults ? this.getFontMetrics(this.getFont()).charWidth('W') * 10 : this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n2;
        this.columnRenderers[1] = null;
        for (n = 2; n < 4; ++n) {
            this.columnWidths[n - 1] = n2;
            this.columnRenderers[n] = labelBracketTableCellRenderer;
        }
        for (n = 4; n < this.columnNames.length; ++n) {
            this.columnWidths[n - 1] = n2;
            this.columnRenderers[n] = labelTableCellRenderer;
        }
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }
}

