/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;

public abstract class CPUResultsPanel
extends ResultsPanel
implements CommonConstants {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String GO_TO_SOURCE_ITEM_NAME = messages.getString("CPUResultsPanel_GoToSourceItemName");
    private static final String BACKTRACES_ITEM_NAME = messages.getString("CPUResultsPanel_BackTracesItemName");
    private static final String SUBTREE_ITEM_NAME = messages.getString("CPUResultsPanel_SubtreeItemName");
    private static final String ROOT_METHODS_ITEM_NAME = messages.getString("CPUResultsPanel_RootMethodsItemName");
    protected CPUResUserActionsHandler actionsHandler;
    protected JMenuItem popupFind;
    protected JMenuItem popupShowReverse;
    protected JMenuItem popupShowSubtree;
    protected JPopupMenu callGraphPopupMenu;
    protected JPopupMenu cornerPopup;
    protected TreePath popupPath;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected int[] columnWidths;
    protected boolean[] columnsVisibility;
    protected int columnCount = 0;
    protected int currentView;
    protected int methodId;

    public CPUResultsPanel(CPUResUserActionsHandler cPUResUserActionsHandler) {
        this.actionsHandler = cPUResUserActionsHandler;
        this.callGraphPopupMenu = this.createPopupMenu();
        if (this.popupFind != null) {
            this.popupFind.setVisible(false);
        }
    }

    public abstract int getCurrentThreadId();

    public int getCurrentView() {
        return this.currentView;
    }

    public JMenuItem getPopupFindItem() {
        return this.popupFind;
    }

    public boolean getSortingOrder() {
        return false;
    }

    public void changeView(int n) {
        if (this.currentView == n) {
            return;
        }
        this.currentView = n;
        this.actionsHandler.viewChanged(n);
    }

    public abstract void reset();

    public int getSortingColumn() {
        return -1;
    }

    protected boolean isAddToRootsAvailable() {
        return this.currentView == 0;
    }

    protected abstract String[] getMethodClassNameAndSig(int var1, int var2);

    protected abstract String getSelectedMethodName();

    protected boolean isShowSourceAvailable() {
        return false;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.popupFind = new JMenuItem();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPUResultsPanel.this.menuActionPerformed(actionEvent);
            }
        };
        boolean bl = true;
        if (this.supportsSubtreeCallGraph()) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            this.popupShowSubtree = new JMenuItem();
            this.popupShowSubtree.setText(SUBTREE_ITEM_NAME);
            jPopupMenu.add(this.popupShowSubtree);
            this.popupShowSubtree.addActionListener(actionListener);
        }
        if (this.supportsReverseCallGraph()) {
            if (!bl) {
                jPopupMenu.addSeparator();
                bl = true;
            }
            this.popupShowReverse = new JMenuItem();
            this.popupShowReverse.setText(BACKTRACES_ITEM_NAME);
            jPopupMenu.add(this.popupShowReverse);
            this.popupShowReverse.addActionListener(actionListener);
        }
        jPopupMenu.add(this.popupFind);
        this.popupFind.addActionListener(actionListener);
        return jPopupMenu;
    }

    protected void performDefaultAction() {
        if (this.popupPath != null) {
            this.showSourceForMethod(this.popupPath);
        } else {
            this.showSourceForMethod(this.methodId);
        }
    }

    protected void showSourceForMethod(int n) {
        if (this.currentView != 2) {
            boolean bl = this.currentView == 0;
            String[] stringArray = this.getMethodClassNameAndSig(n, this.currentView);
            this.actionsHandler.showSourceForMethod(stringArray[0], bl ? stringArray[1] : null, bl ? stringArray[2] : null);
        }
    }

    protected void showSourceForMethod(TreePath treePath) {
        if (this.currentView != 2) {
            boolean bl = this.currentView == 0;
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treePath.getLastPathComponent();
            String[] stringArray = this.getMethodClassNameAndSig(prestimeCPUCCTNode.getMethodId(), this.currentView);
            this.actionsHandler.showSourceForMethod(stringArray[0], bl ? stringArray[1] : null, bl ? stringArray[2] : null);
        }
    }

    protected abstract boolean supportsReverseCallGraph();

    protected abstract boolean supportsSubtreeCallGraph();

    protected void showReverseCallGraph(int n, int n2, int n3, int n4, boolean bl) {
    }

    protected void showSubtreeCallGraph(CCTNode cCTNode, int n, int n2, boolean bl) {
    }

    void menuActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.popupShowReverse) {
            int n = 0;
            if (this.popupPath != null) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.popupPath.getLastPathComponent();
                if (prestimeCPUCCTNode.getParent() == null) {
                    return;
                }
                if (prestimeCPUCCTNode.isSelfTimeNode()) {
                    prestimeCPUCCTNode = (PrestimeCPUCCTNode)prestimeCPUCCTNode.getParent();
                }
                if (prestimeCPUCCTNode == null) {
                    return;
                }
                if (prestimeCPUCCTNode.getMethodId() == 0) {
                    if (prestimeCPUCCTNode.getNChildren() > 0) {
                        this.methodId = ((PrestimeCPUCCTNode)prestimeCPUCCTNode.getChild(0)).getMethodId();
                    }
                } else {
                    this.methodId = prestimeCPUCCTNode.getMethodId();
                }
                n = prestimeCPUCCTNode.getThreadId();
            } else {
                n = this.getCurrentThreadId();
            }
            this.showReverseCallGraph(n, this.methodId, this.currentView, this.getSortingColumn(), this.getSortingOrder());
        } else if (object == this.popupShowSubtree) {
            if (this.popupPath != null) {
                if (this.popupPath.getParentPath() == null) {
                    return;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.popupPath.getLastPathComponent();
                if (prestimeCPUCCTNode.isSelfTimeNode()) {
                    prestimeCPUCCTNode = (PrestimeCPUCCTNode)prestimeCPUCCTNode.getParent();
                }
                if (prestimeCPUCCTNode == null) {
                    return;
                }
                this.showSubtreeCallGraph((CCTNode)prestimeCPUCCTNode, this.currentView, this.getSortingColumn(), this.getSortingOrder());
            }
        } else if (object == this.popupFind) {
            this.actionsHandler.find(this, this.getSelectedMethodName());
        }
    }
}

