/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TomcatInstallUtil {
    private static final String BUNDLED_DEFAULT_URI_ENCODING = "utf-8";
    private static final Boolean BUNDLED_DEFAULT_AUTO_DEPLOY = Boolean.FALSE;
    private static final String ATTR_URI_ENCODING = "URIEncoding";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_AUTO_DEPLOY = "autoDeploy";
    private static final String ATTR_SCHEME = "scheme";
    private static final String ATTR_SECURE = "secure";
    private static final String PROP_CONNECTOR = "Connector";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String TRUE = "true";

    private TomcatInstallUtil() {
    }

    public static String getShutdownPort(Server server) {
        String port = server.getAttributeValue(ATTR_PORT);
        return port != null ? port : String.valueOf(8005);
    }

    public static String getPort(Server server) {
        Service service = server.getService(0);
        int defCon = -1;
        for (int i = 0; i < service.sizeConnector(); ++i) {
            String secure;
            String scheme;
            String protocol = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_PROTOCOL);
            if (!TomcatInstallUtil.isHttpConnector(protocol, scheme = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SCHEME), secure = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SECURE))) continue;
            defCon = i;
            break;
        }
        if (defCon == -1 && service.sizeConnector() > 0) {
            defCon = 0;
        }
        String port = service.getAttributeValue(PROP_CONNECTOR, defCon, ATTR_PORT);
        return port;
    }

    public static String getHost(Server server) {
        String host = null;
        Service service = server.getService(0);
        if (service != null) {
            host = service.getAttributeValue("Engine", 0, "defaultHost");
        }
        return host;
    }

    public static File getBundledHome() {
        FileObject fo = FileUtil.getConfigFile((String)"J2EE/BundledTomcat/Setting");
        if (fo != null) {
            InstalledFileLocator ifl = InstalledFileLocator.getDefault();
            return ifl.locate(fo.getAttribute("bundled_home").toString(), null, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentText(org.w3c.dom.Document doc) {
        OutputFormat format = new OutputFormat();
        format.setPreserveSpace(true);
        StringWriter sw = new StringWriter();
        Element rootElement = doc.getDocumentElement();
        if (rootElement == null) {
            return null;
        }
        try {
            XMLSerializer ser = new XMLSerializer((Writer)sw, format);
            ser.serialize(rootElement);
            sw.write(10);
            String string = sw.toString();
            return string;
        }
        catch (IOException ex) {
            System.out.println("ex=" + ex);
            String string = rootElement.toString();
            return string;
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException ex) {
                System.out.println("ex=" + ex);
            }
        }
    }

    public static void updateDocument(final Document doc, final String newDocInput, final String prefixMark) throws BadLocationException {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                try {
                    String newDoc = newDocInput;
                    int origLen = doc.getLength();
                    String origDoc = doc.getText(0, origLen);
                    int prefixInd = 0;
                    if (prefixMark != null) {
                        prefixInd = origDoc.indexOf(prefixMark);
                        if (prefixInd > 0) {
                            origDoc = doc.getText(prefixInd, origLen - prefixInd);
                        } else {
                            prefixInd = 0;
                        }
                        int prefixIndNewDoc = newDoc.indexOf(prefixMark);
                        if (prefixIndNewDoc > 0) {
                            newDoc = newDoc.substring(prefixIndNewDoc);
                        }
                    }
                    if (origDoc.equals(newDoc)) {
                        return;
                    }
                    doc.remove(prefixInd, origLen - prefixInd);
                    doc.insertString(prefixInd, newDoc, null);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(update);
        } else {
            update.run();
        }
    }

    private static boolean isHttpConnector(String protocol, String scheme, String secure) {
        return !(protocol != null && protocol.length() != 0 && !protocol.toLowerCase().startsWith(HTTP) || scheme != null && scheme.toLowerCase().equals(HTTPS) || secure != null && secure.toLowerCase().equals(TRUE));
    }

    public static boolean setServerPort(int port, File tomcatConf) {
        FileObject fo = FileUtil.toFileObject((File)tomcatConf);
        if (fo != null) {
            try {
                XMLDataObject dobj = (XMLDataObject)DataObject.find((FileObject)fo);
                org.w3c.dom.Document doc = dobj.getDocument();
                Element root = doc.getDocumentElement();
                NodeList list = root.getElementsByTagName("Service");
                int size = list.getLength();
                if (size > 0) {
                    Element service = (Element)list.item(0);
                    NodeList cons = service.getElementsByTagName(PROP_CONNECTOR);
                    for (int i = 0; i < cons.getLength(); ++i) {
                        String secure;
                        String scheme;
                        Element con = (Element)cons.item(i);
                        String protocol = con.getAttribute(ATTR_PROTOCOL);
                        if (!TomcatInstallUtil.isHttpConnector(protocol, scheme = con.getAttribute(ATTR_SCHEME), secure = con.getAttribute(ATTR_SECURE))) continue;
                        con.setAttribute(ATTR_PORT, String.valueOf(port));
                        TomcatInstallUtil.updateDocument((DataObject)dobj, doc);
                        return true;
                    }
                }
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private static void setServerAttributeValue(Server server, String attribute, String value) {
        server.setAttributeValue(attribute, value);
    }

    private static void setHttpConnectorAttributeValue(Server server, String attribute, String value) {
        Service[] services = server.getService();
        if (services != null && services.length > 0) {
            Service service = services[0];
            int sizeConnector = service.sizeConnector();
            for (int i = 0; i < sizeConnector; ++i) {
                String secure;
                String scheme;
                String protocol = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_PROTOCOL);
                if (!TomcatInstallUtil.isHttpConnector(protocol, scheme = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SCHEME), secure = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SECURE))) continue;
                service.setAttributeValue(PROP_CONNECTOR, i, attribute, value);
                return;
            }
        }
    }

    private static void setHostAttributeValue(Server server, String attribute, String value) {
        Service[] service = server.getService();
        if (service != null) {
            for (int i = 0; i < service.length; ++i) {
                Host[] host;
                Engine engine = service[i].getEngine();
                if (engine == null || (host = engine.getHost()) == null || host.length <= 0) continue;
                host[0].setAttributeValue(attribute, value);
                return;
            }
        }
    }

    public static void patchBundledServerXml(File serverXml) {
        try {
            Server server = Server.createGraph(serverXml);
            TomcatInstallUtil.setServerAttributeValue(server, ATTR_PORT, String.valueOf(8025));
            TomcatInstallUtil.setHttpConnectorAttributeValue(server, ATTR_PORT, String.valueOf(8084));
            TomcatInstallUtil.setHttpConnectorAttributeValue(server, ATTR_URI_ENCODING, BUNDLED_DEFAULT_URI_ENCODING);
            TomcatInstallUtil.setHostAttributeValue(server, ATTR_AUTO_DEPLOY, BUNDLED_DEFAULT_AUTO_DEPLOY.toString());
            server.write(serverXml);
        }
        catch (IOException e) {
            Logger.getLogger(TomcatInstallUtil.class.getName()).log(Level.INFO, null, e);
        }
        catch (RuntimeException e) {
            Logger.getLogger(TomcatInstallUtil.class.getName()).log(Level.INFO, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchCatalinaProperties(File catalinaProperties) throws IOException {
        EditableProperties props = new EditableProperties(false);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(catalinaProperties));
        try {
            props.load((InputStream)is);
            String COMMON_LOADER = "common.loader";
            String commonLoader = props.getProperty(COMMON_LOADER);
            if (commonLoader != null) {
                String NB_LIB;
                if ((commonLoader = commonLoader.trim()).contains(NB_LIB = "${catalina.base}/nblib/*.jar")) {
                    return;
                }
                StringBuilder commonLoaderValue = new StringBuilder(commonLoader);
                if (!commonLoader.endsWith(",")) {
                    commonLoaderValue.append(",");
                }
                commonLoaderValue.append(NB_LIB);
                props.setProperty(COMMON_LOADER, commonLoaderValue.toString());
            }
        }
        finally {
            ((InputStream)is).close();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(catalinaProperties));
        try {
            props.store((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNBLibDirectory(File catalinaBase) throws IOException {
        new File(catalinaBase, "nblib").mkdir();
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(catalinaBase, "nblib/README")));
        try {
            for (String line : NbBundle.getMessage(TomcatInstallUtil.class, (String)"MSG_NBLibReadmeContent").split("\n")) {
                writer.write(line);
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    public static boolean setShutdownPort(int port, File tomcatConf) {
        FileObject fo = FileUtil.toFileObject((File)tomcatConf);
        if (fo != null) {
            try {
                XMLDataObject dobj = (XMLDataObject)DataObject.find((FileObject)fo);
                org.w3c.dom.Document doc = dobj.getDocument();
                Element root = doc.getDocumentElement();
                root.setAttribute(ATTR_PORT, String.valueOf(port));
                TomcatInstallUtil.updateDocument((DataObject)dobj, doc);
                return true;
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    public static void updateDocument(DataObject dobj, org.w3c.dom.Document doc) throws BadLocationException, IOException {
        EditorCookie editor = (EditorCookie)dobj.getCookie(EditorCookie.class);
        StyledDocument textDoc = editor.getDocument();
        if (textDoc == null) {
            textDoc = editor.openDocument();
        }
        TomcatInstallUtil.updateDocument(textDoc, TomcatInstallUtil.getDocumentText(doc), "<Server");
        SaveCookie savec = (SaveCookie)dobj.getCookie(SaveCookie.class);
        if (savec != null) {
            savec.save();
        }
    }
}

