/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen.generators;

import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.generators.Object_to_WDO4JS_as_JS_compact;
import com.ibm.odcb.jrender.mediators.gen.generators.Object_to_WDO4JS_as_XMI;
import com.ibm.odcb.jrender.misc.FileUtil;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public abstract class Generator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String[] MEDIATOR_KEYS = new String[]{MediatorFactory.GenTypeKey("Object", "_wdo4js_js"), MediatorFactory.GenTypeKey("Object", "_wdo4js_xmi")};
    public static final Generator[] GENS = new Generator[]{new Object_to_WDO4JS_as_JS_compact(), new Object_to_WDO4JS_as_XMI()};
    protected static HashMap _Generators = new HashMap(57);

    protected static final void GenWarning(Writer writer) {
        try {
            writer.write("//     *********************************************************\n");
            writer.write("//     ** THIS CODE IS GENERATED AND **MUST NOT** BE MODIFIED **\n");
            writer.write("//     *********************************************************\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected final void GenVersionHistory(Writer writer) {
        try {
            writer.write("\n");
            writer.write("\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("//\n");
            Generator.GenWarning(writer);
            writer.write("//\n");
            this.PrintVersionHistory(writer);
            writer.write("//\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("\n");
            writer.write("\n");
            Generator.GenWarning(writer);
            writer.write("\n");
            writer.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void genMediator(EClassMap eClassMap, String string, String string2, boolean bl) throws FileNotFoundException, ExportException {
        String string3 = eClassMap.getEPackageName() + "_" + eClassMap.getExport() + this.getIdentifier();
        String string4 = string + File.separator + string3 + ".java";
        Streamer.debug.Header().println("FileName =" + string4 + ", and ClassName =" + string3);
        File file = new File(string4);
        if (!FileUtil.isOlder(file, eClassMap.getSourceEmapName()) && !bl) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string4);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        this.GenVersionHistory(printWriter);
        printWriter.write("package " + string2 + ";\n");
        printWriter.write("\n");
        printWriter.write("import java.io.Writer;\n");
        printWriter.write("import com.ibm.odcb.jrender.mediators.Mediator;\n");
        printWriter.write("import com.ibm.odcb.jrender.mediators.PageContext;\n");
        printWriter.write("import com.ibm.odcb.jrender.mediators.ExportException;\n");
        this.AddOtherImports(printWriter);
        printWriter.write("\n");
        Generator.GenWarning(printWriter);
        printWriter.write("\n");
        printWriter.write("public class " + string3 + " extends Mediator\n");
        printWriter.write(" {\n");
        String string5 = this.getArrayVarDelimiter();
        printWriter.write("   public " + string3 + "() { super(\"" + eClassMap.getExport() + "\", \"" + string5 + "\"); }");
        printWriter.write("\n");
        printWriter.write("   public String getSignature(Object O, String modelName, boolean First, int ComplexPropertyCount)\n");
        printWriter.write("    {\n");
        printWriter.write("      if (O == null) return \"\";\n");
        printWriter.write("      try\n");
        printWriter.write("       {\n");
        String string6 = eClassMap.getBaseType().replace('$', '.');
        printWriter.write("         " + string6 + " Obj = (" + string6 + ") O;\n");
        printWriter.write("         StringBuffer SigStr = new StringBuffer(128);\n");
        String string7 = eClassMap.getKeySignature("Obj");
        printWriter.write(string7);
        printWriter.write("\n");
        printWriter.write("         return First == true ? modelName+\"`" + eClassMap.getJavaComplexName() + "\"+SigStr.toString() : SigStr.toString();\n");
        printWriter.write("       }\n");
        printWriter.write("      catch (Exception e)\n");
        printWriter.write("       {\n");
        printWriter.write("         if (e instanceof java.lang.ClassCastException)\n");
        printWriter.write("          {\n");
        printWriter.write("            System.out.println(\"ClassCastException: Expecting type '" + eClassMap.getBaseType() + "' but found object of type '\"+O.getClass().getName()+\"'\"); \n");
        printWriter.write("            System.out.println(\"Please make sure that the ecore and emap are defined correctly.\"); \n");
        printWriter.write("          }\n");
        printWriter.write("         e.printStackTrace();\n");
        printWriter.write("         return null; \n");
        printWriter.write("       }\n");
        printWriter.write("    }\n");
        printWriter.write("\n");
        Generator.GenWarning(printWriter);
        printWriter.write("\n");
        printWriter.write("   public void Export(Writer Out, PageContext Ctx, Object O) throws ExportException\n");
        printWriter.write("     {\n");
        printWriter.write("      try\n");
        printWriter.write("      {\n");
        this.GenSchema(printWriter, eClassMap);
        printWriter.write("      }\n");
        printWriter.write("      catch (Exception e)\n");
        printWriter.write("      {\n");
        printWriter.write("        e.printStackTrace();\n");
        printWriter.write("      }\n");
        printWriter.write("     }\n");
        printWriter.write("\n");
        Generator.GenWarning(printWriter);
        printWriter.write("\n");
        printWriter.write("   public void ExportXMILoader(Writer Out, PageContext Ctx) throws ExportException");
        printWriter.write("     {\n");
        printWriter.write("      try\n");
        printWriter.write("      {\n");
        printWriter.write("        boolean FirstTime = Ctx.isFirstSchemaExport();\n");
        printWriter.write("        if (FirstTime == true)\n");
        printWriter.write("        {\n");
        printWriter.write("          Out.write(\"<SCRIPT>\");\n");
        printWriter.write("          Out.write(\"var WDO4JSModelRoot_\"); Out.write(Ctx.getLastModelName()); Out.write(\"=new XMILoader(WDO4JSModel_\"); Out.write(Ctx.getSchemaExportName()); Out.write(\", '" + eClassMap.getExport() + "', '" + eClassMap.getClientEcoreName() + "');\\n\");\n");
        printWriter.write("          Out.write(\"</SCRIPT>\\n\");\n");
        printWriter.write("         }\n");
        printWriter.write("      }\n");
        printWriter.write("      catch (Exception e)\n");
        printWriter.write("      {\n");
        printWriter.write("        e.printStackTrace();\n");
        printWriter.write("      }\n");
        printWriter.write("     }\n");
        printWriter.write("\n");
        Generator.GenWarning(printWriter);
        printWriter.write("\n");
        printWriter.write("   public void Export(Writer Out, PageContext Ctx, Object O, String Var, boolean DebugMode) throws ExportException\n");
        printWriter.write("     {\n");
        printWriter.write("      try\n");
        printWriter.write("        {\n");
        printWriter.write("       " + string6 + " Obj = (" + string6 + ") O;\n");
        printWriter.write("\n");
        this.GenData(printWriter, eClassMap);
        printWriter.write("      }\n");
        printWriter.write("      catch (Exception e)\n");
        printWriter.write("      {\n");
        printWriter.write("        e.printStackTrace();\n");
        printWriter.write("      }\n");
        printWriter.write("     }\n");
        printWriter.write(" }\n");
        printWriter.close();
    }

    public void AddOtherImports(Writer writer) {
    }

    public String getArrayVarDelimiter() {
        return ",";
    }

    public abstract String getIdentifier();

    public abstract void PrintVersionHistory(Writer var1);

    public abstract void GenSchema(Writer var1, EClassMap var2);

    public abstract void GenData(Writer var1, EClassMap var2);

    public static Generator getGenerator(String string) {
        return (Generator)_Generators.get(string);
    }

    public static void Init() {
        int n = 0;
        while (n < MEDIATOR_KEYS.length) {
            _Generators.put(MEDIATOR_KEYS[n], GENS[n]);
            ++n;
        }
    }
}

