/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.DynamicMediator;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.MappingsCompiler;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.CalculateAttribute;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.ResourceHandler;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.utilities.EMapGen;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMapWriter {
    protected WDO4JSMappings universe;
    protected EPackageMap _EPM;
    protected String baseSourcePath;
    protected String baseBuildPath;
    public static final String ECLASSMAP_NOT_FOUND_MESSAGE = "ECLASSMAP_NOT_FOUND_MESSAGE";
    public static final String EFEATUREMAP_NOT_FOUND_MESSAGE = "EFEATUREMAP_NOT_FOUND_MESSAGE";
    public static final String FILE_NOT_FOUND_MESSAGE = "FILE_NOT_FOUND_MESSAGE";
    public static final String GETTER_NOT_FOUND_MESSAGE = "GETTER_NOT_FOUND_MESSAGE";
    public static final String CANNOT_REMOVE_ECLASSMAP_DUE_TO_DANGLING_REFERENCES_MESSAGE = "CANNOT_REMOVE_ECLASSMAP_DUE_TO_DANGLING_REFERENCES_MESSAGE";
    public static final String CLASS_NOT_FOUND = "CLASS_NOT_FOUND";
    public static final String SETTER_NOT_FOUND_MESSAGE = "SETTER_NOT_FOUND_MESSAGE";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_INTEGER = "int";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_DATE = "date";

    public EMapWriter(WDO4JSMappings wDO4JSMappings, String string, String string2, String string3) {
        this.universe = wDO4JSMappings;
        this._EPM = wDO4JSMappings.getEPackageMap(string);
        this.baseSourcePath = string2;
        this.baseBuildPath = string3;
    }

    public String addFeatureMap(String string, String string2, String string3, boolean bl) {
        return this.addFeatureMap(string, string2, string3, null, bl);
    }

    public String addFeatureMap(String string, String string2, String string3, String string4, boolean bl) {
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        String string5 = null;
        if (eClassMap == null) {
            string5 = ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
            Streamer.error.Header().println(string5);
            return string5;
        }
        EStructuralFeature eStructuralFeature = eClassMap.getEStructuralFeatureByName(string2);
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(eClassMap.getBaseTypeClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            string5 = ResourceHandler.getString(CLASS_NOT_FOUND, new String[]{eClassMap.getBaseTypeClass().getName()});
            Streamer.error.Header().println(string5);
            return string5;
        }
        if (string3 == null && (string3 = EMapGen.FindProperty(eStructuralFeature, eClassMap.getBaseTypeClass(), propertyDescriptorArray, true)).equals("CUSTOM_JAVA_CODE_FRAGMENT_NEEDED")) {
            string5 = ResourceHandler.getString(GETTER_NOT_FOUND_MESSAGE, new String[]{string2});
            Streamer.error.Header().println(string5);
            return string5;
        }
        if (string4 == null && (string4 = EMapGen.FindProperty(eStructuralFeature, eClassMap.getBaseTypeClass(), propertyDescriptorArray, false)).equals("CUSTOM_JAVA_CODE_FRAGMENT_NEEDED")) {
            string5 = ResourceHandler.getString(SETTER_NOT_FOUND_MESSAGE, new String[]{string2});
            Streamer.warning.Header().println(string5);
            string4 = null;
        }
        EFeatureMap eFeatureMap = eClassMap.getEFeatureMapByEFeatureName(string2);
        boolean bl2 = DynamicMediator.isComplexNameDynamic(eClassMap.getJavaComplexName());
        if (bl2) {
            string2 = EMapGen.getWDOFeatureName(eStructuralFeature, eClassMap.getEPackageName());
        }
        if (eFeatureMap == null) {
            eFeatureMap = new EFeatureMap(string2, bl, string3, string4, true);
        } else {
            eClassMap.removeEFeatureMap(eFeatureMap);
            eFeatureMap.setID(bl);
            eFeatureMap.setGet(string3);
        }
        eClassMap.addEFeatureMap(eFeatureMap);
        if (bl) {
            eClassMap.addEIdFeatureMap(eFeatureMap);
        }
        return null;
    }

    public String addClientFeatureMap(String string, String string2, String string3, String string4, boolean bl) {
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        String string5 = null;
        if (eClassMap == null) {
            string5 = ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
            Streamer.error.Header().println(string5);
            return string5;
        }
        EFeatureMap eFeatureMap = eClassMap.getEFeatureMapByEFeatureName(string2);
        if (eFeatureMap != null) {
            eClassMap.removeEFeatureMap(eFeatureMap);
        }
        eFeatureMap = new CalculateAttribute(string2, bl, string3, string4);
        eClassMap.addEFeatureMap(eFeatureMap);
        if (bl) {
            eClassMap.addEIdFeatureMap(eFeatureMap);
        }
        return null;
    }

    public final String addClientFeatureMap(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return this.addClientFeatureMap(string, string2, string3, string4, bl);
    }

    public String removeFeatureMap(String string, String string2) {
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        if (eClassMap == null) {
            String string3 = ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
            Streamer.error.Header().println(string3);
            return string3;
        }
        EFeatureMap eFeatureMap = eClassMap.getEFeatureMapByExport(string2);
        if (eFeatureMap == null) {
            String string4 = ResourceHandler.getString(EFEATUREMAP_NOT_FOUND_MESSAGE, new String[]{string2, string});
            Streamer.warning.Header().println(string4);
            return null;
        }
        eClassMap.removeEFeatureMap(eFeatureMap);
        return null;
    }

    public String addClassMap(String string, String string2, String string3) {
        Streamer.status.Header().println("Tracing in addClassMap() of EMapwriter.java Package name:" + this._EPM.getName() + " appClassPath: " + string + " eClassName:" + string2 + "export: " + string3);
        EClassMap eClassMap = this.universe.getEClassMapByJavaComplexName(string);
        if (eClassMap == null) {
            eClassMap = new EClassMap(this._EPM.getName(), string2, string, string3, this._EPM.getEMapXMLFileName(), this._EPM.getEMapResourceName(), true);
        } else {
            this.universe.removeEClassMap(eClassMap);
        }
        if (eClassMap.getEClass() == null || !string2.equals(eClassMap.getEClassName())) {
            eClassMap.setEClassName(string2);
            EClass eClass = (EClass)this.universe.getEClassifier(this._EPM.getName(), string2);
            eClassMap.setEClass(eClass);
        }
        eClassMap.setExport(string3);
        this.universe.addEClassMap(this._EPM, eClassMap, true);
        return null;
    }

    public String removeClassMap(String string) {
        String string2 = null;
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        if (eClassMap != null) {
            this.universe.removeEClassMap(eClassMap);
            return null;
        }
        string2 = ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
        Streamer.error.Header().println(string2);
        return string2;
    }

    public String write(boolean bl) {
        String string = null;
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this._EPM.getEMapXMLFileName()));
            EMapGen.writeEMap(printWriter, this._EPM.getName(), this._EPM.getRootEClassMap().getEClassName(), this.universe.getEClassMapsForEPackageIterator(this._EPM.getName()));
            printWriter.close();
            if (bl) {
                MappingsCompiler mappingsCompiler = MediatorFactory.BuildMediators(true, false, this.baseSourcePath, null, null, this._EPM.getName(), true);
                if (!mappingsCompiler.getVerificationStatus()) {
                    return "Error creating the ClientData: mappings are inconsistent";
                }
                if (!mappingsCompiler.getGenerationStatus()) {
                    return "Error creating the ClientData: could not generate the code artifacts";
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = ResourceHandler.getString(FILE_NOT_FOUND_MESSAGE, new String[]{this._EPM.getEMapXMLFileName()});
            Streamer.error.Header().println(string);
            return string;
        }
        return null;
    }

    public String removeClassMap(String string, boolean bl) {
        String string2 = null;
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        if (eClassMap == null) {
            string2 = ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
            Streamer.warning.Header().println(string2);
            return null;
        }
        this.universe.removeEClassMap(eClassMap);
        return null;
    }

    public String setDiffOnRefresh(String string, boolean bl) {
        EClassMap eClassMap = this.universe.getEClassMapByExport(string);
        if (eClassMap == null) {
            return ResourceHandler.getString(ECLASSMAP_NOT_FOUND_MESSAGE, new String[]{string});
        }
        eClassMap.setDiffOnRefresh(bl);
        return null;
    }
}

