/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class WebServicesEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _wsdlURL;
    protected String _friendlyName;
    protected String _webServiceOperation;
    protected ArrayList _wsInput = new ArrayList(7);
    protected ArrayList _wsOutput = new ArrayList(7);

    public WebServicesEmitter() {
        super("ODCWebService");
    }

    public WebServicesEmitter(String string, String string2, String string3) {
        super("ODCWebService");
        this.Init(string, string2, string3);
    }

    public void Init(String string, String string2, String string3) {
        this._wsdlURL = string;
        this._friendlyName = string2;
        this._webServiceOperation = string3;
        Streamer.debug.Header().println("In WebServices emitter --> \n\nwsdl URL: " + this._wsdlURL + "\n" + "friendlyName: " + this._friendlyName + "\n" + "Webservice Operation: " + this._webServiceOperation);
    }

    public void AddInputParameter(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this._wsInput.add(new WSInput(string2, string3, string4, string5, string, bl));
    }

    public void AddInputParameter(String string, String string2) {
        this._wsInput.add(new WSInput(string, string2));
    }

    public void AddOutputParameter(String string, String string2, String string3, String string4, String string5) {
        this._wsOutput.add(new WSOutput(string2, string3, string4, string, string5));
    }

    public void setWsdlURL(String string) {
        this._wsdlURL = string;
    }

    public void setFriendlyName(String string) {
        this._friendlyName = string;
    }

    public void setWebServiceOperation(String string) {
        this._webServiceOperation = string;
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Object object;
        int n;
        boolean bl;
        Streamer.trace.Header().println("Entering WebServiceEmitter export...");
        writer.write("<SCRIPT>\n");
        writer.write("ODCProgressBar.startRenderControl(webservice);\n");
        writer.write("</SCRIPT>\n");
        this._friendlyName = this._friendlyName.trim().replace(' ', '_');
        this._friendlyName = this._friendlyName.replace(':', '_');
        this._varIndex = pageContext.NextInstanceCount();
        String string = this.CONTROL_VAR + this._varIndex;
        String string2 = this.ADAPTER_VAR + this._varIndex;
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        boolean bl2 = bl = pageContext.getContextVariable("DEBUG_MODE") == "YES";
        if (!BaseEmitter.TestGuard(pageContext, "WEBSERVICES_JS_FLAG")) {
            if (bl) {
                writer.write("\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/webservice/webservice.js") + "\"></SCRIPT>");
                writer.write("\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/webservice/webserviceadapter.js") + "\"></SCRIPT>");
                Streamer.trace.Header().println("Included individual webservice JS files...");
            } else {
                writer.write("<SCRIPT language=\"JavaScript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_webservice_c.js") + "\"></SCRIPT>");
                writer.write("\n");
                Streamer.trace.Header().println("Included compressed webservice JS file...");
            }
            writer.write("<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" width=\"10\" height=\"10\" id=\"wscomp\" align=\"middle\">");
            writer.write("\n");
            writer.write("<param name=\"allowScriptAccess\" value=\"sameDomain\"/>");
            writer.write("\n");
            writer.write("<PARAM NAME=\"movie\" VALUE=\"" + uRLRewriter.Rewrite("jsl/webservice/wssample_ascript.swf") + "\">");
            writer.write("\n");
            writer.write(" <param name=\"quality\" value=\"high\"/>");
            writer.write("\n");
            writer.write("<param name=\"bgcolor\" value=\"#ffffff\"/>");
            writer.write("\n");
            writer.write(" <embed src=\"" + uRLRewriter.Rewrite("jsl/webservice/wssample_ascript.swf") + "\"  quality=\"high\" bgcolor=\"#ffffff\" width=\"10\" height=\"10\" name=\"wscomp\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />");
            writer.write("\n");
            writer.write("</object>");
        }
        writer.write("<SCRIPT>\nvar " + string + " = new WebServiceControl(window.document.wscomp);\n" + "var " + string2 + " = new WebServiceAdapter(" + string + ", '" + string + "Callback', '" + this._wsdlURL + "', '" + this._friendlyName + "', '" + this._webServiceOperation + "');");
        writer.write("\n");
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._wsInput.size() > 0) {
            n = 0;
            while (n < this._wsInput.size()) {
                object = (WSInput)this._wsInput.get(n);
                if (((WSInput)object)._constantValue != null) {
                    stringBuffer.append(",['").append("null").append("','").append(((WSInput)object)._constantValue).append("','").append("null").append("','").append(((WSInput)object)._RequestElementName).append("','").append("null").append("']");
                } else {
                    stringBuffer.append(",['").append(((WSInput)object)._eObjectID).append("','").append(((WSInput)object)._eAttributeName).append("',").append("WDO4JSModelRoot_" + ((WSInput)object)._modelName + ".Root").append(",'").append(((WSInput)object)._RequestElementName).append("','").append(((WSInput)object)._attribute).append("','").append(((WSInput)object)._useAsList).append("']");
                }
                ++n;
            }
            stringBuffer.append("]");
            stringBuffer.setCharAt(0, '[');
        } else {
            stringBuffer.append("[]");
        }
        writer.write(string2);
        writer.write(".setupParams(");
        writer.write(stringBuffer.toString());
        writer.write(",");
        stringBuffer.setLength(0);
        if (this._wsOutput.size() > 0) {
            n = 0;
            while (n < this._wsOutput.size()) {
                object = (WSOutput)this._wsOutput.get(n);
                stringBuffer.append(",['").append(((WSOutput)object)._eObjectID).append("','").append(((WSOutput)object)._eAttributeName).append("',").append("WDO4JSModelRoot_" + ((WSOutput)object)._modelName + ".Root").append(",'").append(((WSOutput)object)._ResponseElementName).append("','").append(((WSOutput)object)._attributeName).append("']");
                ++n;
            }
            stringBuffer.append("]");
            stringBuffer.setCharAt(0, '[');
        } else {
            stringBuffer.append("[]");
        }
        writer.write(stringBuffer.toString());
        stringBuffer.setLength(0);
        writer.write(");");
        writer.write("</SCRIPT>");
        writer.write("\n");
        writer.write("<SCRIPT LANGUAGE=JavaScript>");
        writer.write("\n");
        writer.write("function " + string + "Callback(){");
        writer.write("\n");
        writer.write(string2);
        writer.write(".resultHandler();");
        writer.write("\n");
        writer.write("}");
        writer.write("</SCRIPT>");
        writer.write("<SCRIPT>\n");
        writer.write("ODCProgressBar.endRenderControl(webservice);\n");
        writer.write("</SCRIPT>\n");
        Streamer.trace.Header().println("Exiting WebServiceEmitter export...");
    }

    protected static class WSOutput {
        public String _eObjectID;
        public String _eAttributeName;
        public String _ResponseElementName;
        public String _modelName;
        public String _attributeName;

        public WSOutput(String string, String string2, String string3, String string4, String string5) {
            this._eObjectID = string;
            this._eAttributeName = string2;
            this._ResponseElementName = string3;
            this._modelName = string4;
            this._attributeName = string5;
        }
    }

    protected static class WSInput {
        public String _eObjectID;
        public String _eAttributeName;
        public String _RequestElementName;
        public String _attribute;
        public String _constantValue;
        public String _modelName;
        public boolean _useAsList;

        public WSInput(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this._eObjectID = string;
            this._eAttributeName = string2;
            this._RequestElementName = string3;
            this._attribute = string4;
            this._modelName = string5;
            this._useAsList = bl;
        }

        public WSInput(String string, String string2) {
            this._RequestElementName = string2;
            this._constantValue = string;
        }
    }
}

