/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.diff.DiffProcessor;
import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.DynamicMediator;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import com.ibm.websphere.sdo.internal.DataListAccessBeanImpl;
import com.ibm.websphere.sdo.internal.DataObjectAccessBeanImpl;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreEList;

public class WDO4JSEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VERSION = "JWL 1.1.1, SDO";
    protected String modelTypeKey;
    protected String dataTypeKey;
    protected Object _O;
    protected String _BaseType;
    protected String _ExtraName;
    protected String _ModelExportMode;
    protected String _DataExportMode;
    protected String _ModelName;
    protected PageContext _PageCtx;
    protected int _ExportCount;

    public void Init(Object object, String string, String string2, boolean bl, boolean bl2, String string3) {
        Transformer.CheckO(object);
        this._O = object;
        this._BaseType = string;
        this._ExtraName = string2;
        this._ModelExportMode = bl ? "_wdo4js_js" : "_wdo4js_xmi";
        this._DataExportMode = bl2 ? "_wdo4js_js" : "_wdo4js_xmi";
        this._ModelName = string3;
        this.CONTROL_VAR = "WDO4JSModelRoot_" + this._ModelName;
        try {
            this.modelTypeKey = MediatorFactory.GenTypeKey(this._BaseType, this._ExtraName, this._ModelExportMode);
            this.dataTypeKey = MediatorFactory.GenTypeKey(this._BaseType, this._ExtraName, this._DataExportMode);
            MediatorFactory.initGenericMediator(this.modelTypeKey, this.dataTypeKey, this._O);
        }
        catch (ExportException exportException) {
            Streamer.error.Header().printStackTrace(exportException);
        }
    }

    public void Init(Object object, String string, String string2, String string3) {
        this.Init(object, string, string2, true, true, string3);
    }

    public void Init(Object object, String string, String string2) {
        this.Init(object, string, null, true, true, string2);
    }

    public void Init(Object object, String string) {
        Transformer transformer = new Transformer(object);
        this.Init(transformer._O, transformer._BaseType, transformer._ExtraName, true, true, string);
    }

    public void Export(Writer writer, PageContext pageContext) throws IOException, ExportException {
        this.exportIncludes(writer, pageContext);
        this.ExportModel(writer, pageContext);
        this.ExportData(writer, pageContext);
    }

    public void ExportModel(Writer writer, PageContext pageContext) throws IOException, ExportException {
        this.exportIncludes(writer, pageContext);
        try {
            writer.write("<SCRIPT> ODCProgressBar.startLoadModel(\"" + this._ModelName + "\");</SCRIPT> \n");
            Mediator.ExportSchema(writer, pageContext, this.modelTypeKey, this._ModelName, this._O);
            writer.write("<SCRIPT> ODCProgressBar.endLoadModel(\"" + this._ModelName + "\");</SCRIPT> \n");
        }
        catch (IOException iOException) {
            Streamer.error.Header().printStackTrace(iOException);
            throw new ExportException(iOException.toString());
        }
    }

    public void ExportData(Writer writer, PageContext pageContext) throws ExportException {
        this._PageCtx = pageContext;
        this._ExportCount = pageContext.NextInstanceCount() + 1;
        boolean bl = pageContext.getContextVariable("DEBUG_MODE") != null;
        try {
            writer.write("<SCRIPT> ODCProgressBar.startLoadDataInstance(\"" + this._ModelName + "\");</SCRIPT> \n");
            Mediator.ExportData(writer, pageContext, this._O, this.dataTypeKey, bl);
            this._ExportCount = pageContext.NextInstanceCount() - this._ExportCount;
            writer.write("<SCRIPT> ODCProgressBar.endLoadDataInstance(\"" + this._ModelName + "\");</SCRIPT> \n");
        }
        catch (IOException iOException) {
            Streamer.error.Header().printStackTrace(iOException);
            throw new ExportException(iOException.toString());
        }
    }

    public int getExportCount() {
        return this._ExportCount;
    }

    public String getExportIDByObject(Object object) throws ExportException {
        Transformer transformer = new Transformer(object);
        return Mediator.getExportID(this._PageCtx, transformer._O, MediatorFactory.GenTypeKey(transformer._BaseType, transformer._ExtraName, this._DataExportMode), this._ModelName);
    }

    public String getExportIDByName(Object object, String string, String string2) throws ExportException {
        return Mediator.getExportID(this._PageCtx, object, MediatorFactory.GenTypeKey(string, string2, this._DataExportMode), this._ModelName);
    }

    public String getReferenceName(Object object, String string) throws ExportException {
        Transformer transformer = new Transformer(object);
        return transformer._ReferenceName == null ? string : transformer._ReferenceName;
    }

    public static EClassMap getEClassMapByObject(Object object) throws ExportException {
        Transformer transformer = new Transformer(object);
        return Mediator.getEClassMapForJavaComplexName(transformer._BaseType, transformer._ExtraName);
    }

    public static EClassMap getEClassMapByName(String string, String string2) throws ExportException {
        return Mediator.getEClassMapForJavaComplexName(string, string2);
    }

    private void exportIncludes(Writer writer, PageContext pageContext) throws IOException, ExportException {
        if (!BaseEmitter.TestGuard(pageContext, "WDO4JS_JS_FLAG")) {
            URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
            if (pageContext.getContextVariable("DEBUG_MODE") == "YES") {
                writer.write("\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/eclass.js") + "\"></SCRIPT>\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/ecreator.js") + "\"></SCRIPT>\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/eobject.js") + "\"></SCRIPT>\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/xmiHandler.js") + "\"></SCRIPT>\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/binder.js") + "\"></SCRIPT>\n");
            } else {
                writer.write("<SCRIPT language=\"JavaScript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_wdo4js_c.js") + "\"></SCRIPT>\n");
            }
        }
    }

    public DiffProcessor.DiffedObjectsLists Import(String string) throws DiffException {
        return DiffProcessor.Import(this._O, string, EClassMap.MakeComplexName(this._BaseType, this._ExtraName));
    }

    public static class Transformer {
        public String _BaseType;
        public String _ExtraName;
        public Object _O;
        public String _ReferenceName;

        protected static final void CheckO(Object object) {
            if (object == null) {
                throw new Error("WDO4JSEmitter.Init(Object, ModelName) called with a null Object.");
            }
            if (object instanceof List && !(object instanceof EcoreEList) && !(object instanceof DataListAccessBeanImpl)) {
                throw new Error("WDO4JSEmitter called with a generic List (type '" + object.getClass().getName() + "'). A Root object must be supplied.");
            }
        }

        public Transformer(Object object) {
            Transformer.CheckO(object);
            Streamer.debug.Header().println("Transformer called with Object of type '" + object.getClass().getName() + "'.");
            this._O = object;
            if (this._O instanceof EcoreEList) {
                this._ReferenceName = ((EcoreEList)this._O).getEObject().eClass().getEStructuralFeature(((EcoreEList)this._O).getFeatureID()).getEType().getName();
                this._O = ((EcoreEList)this._O).getEObject();
                if (this._O instanceof EDataObject) {
                    this._O = EMFHelper.getDataObject(((EDataObject)this._O).getDataGraph(), true);
                }
            } else if (this._O instanceof DataObjectAccessBeanImpl) {
                Streamer.debug.Header().println("The object passed is a DataObjectAccessBeanImpl");
                this._O = ((DataObjectAccessBeanImpl)this._O).getEDataObject();
            } else if (this._O instanceof DataListAccessBeanImpl) {
                Streamer.debug.Header().println("The object passed is a DataListAccessBeanImpl");
                this._O = ((DataListAccessBeanImpl)this._O).getDataGraph();
                this._O = EMFHelper.getDataObject(this._O, true);
                this._ReferenceName = Transformer.getReferenceName(((EObject)this._O).eClass(), ((DataListAccessBeanImpl)object).getSchema());
            }
            if (this._O instanceof DataGraph) {
                this._O = EMFHelper.getDataObject(this._O, false);
            }
            if (this._O instanceof DataObject) {
                this._BaseType = EMFHelper.DataObject_CLASS.getName();
                this._ExtraName = DynamicMediator.MakeExtraName((EObject)this._O);
            } else {
                this._BaseType = this._O.getClass().getName();
                this._ExtraName = null;
            }
            Streamer.debug.Header().println("Transformer results: BaseType='" + this._BaseType + "'; ExtraName='" + this._ExtraName + "'.");
        }

        public static String getReferenceName(EClass eClass, EClass eClass2) {
            Streamer.debug.Header().println("Finding in '" + eClass.getName() + "' the first reference of type '" + eClass2.getName() + "'.");
            EList eList = eClass.getEAllReferences();
            int n = 0;
            while (n < eList.size()) {
                EReference eReference = (EReference)eList.get(n);
                Streamer.debug.Header().println("Comparing EClass '" + eReference.getEType().getName() + "' with '" + eClass2.getName() + "'.");
                if (eReference.getEType().equals(eClass2)) {
                    while (++n < eList.size()) {
                        EReference eReference2 = (EReference)eList.get(n);
                        if (!eReference2.getEType().equals(eClass2)) continue;
                        Streamer.warning.Header().println("We found more than one EReference of type '" + eClass2.getName() + "' under EClass '" + eClass.getName() + "'. Returning the first one found '" + eReference2.getName() + "'.");
                        break;
                    }
                    Streamer.debug.Header().println("Returning reference '" + eReference.getName() + "' of type '" + eReference.getEType().getName() + "' off Root object of type '" + eClass.getName() + "'.");
                    return eReference.getName();
                }
                ++n;
            }
            return null;
        }
    }
}

