/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class RadioButtonEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final int _defaultCheckedIndex = -1;
    protected String _modelName;
    protected String _eObjectID;
    protected String _eAttributeName;
    protected int _checkedIndex = -1;
    protected ArrayList _radioButtonValueList = new ArrayList(10);
    protected ArrayList _radioButtonTextDisplayList = new ArrayList(10);

    public RadioButtonEmitter() {
        super("ODCRadioButton");
    }

    public RadioButtonEmitter(String string, String string2, String string3, ArrayList arrayList, ArrayList arrayList2, int n) {
        super("ODCRadioButton");
        this.Init(string, string2, string3, arrayList, arrayList2, n);
    }

    public void Init(String string, String string2, String string3, ArrayList arrayList, ArrayList arrayList2, int n) {
        this._checkedIndex = n < arrayList.size() ? n : -1;
        this._radioButtonValueList = arrayList;
        this._radioButtonTextDisplayList = arrayList2;
        this._modelName = string;
        this._eObjectID = string2;
        this._eAttributeName = string3;
        Streamer.debug.Header().println("In RadioButtonEmitter --> \nmodelName: " + this._modelName + "\n" + "eObjectId: " + this._eObjectID + "\n" + "eAttributeName: " + this._eAttributeName + "\n");
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public void setEObjectID(String string) {
        this._eObjectID = string;
    }

    public void setEAttributeName(String string) {
        this._eAttributeName = string;
    }

    public void setCheckedIndex(int n) {
        this._checkedIndex = n;
    }

    public void addRadioButton(String string, String string2) {
        this._radioButtonValueList.add(string);
        this._radioButtonTextDisplayList.add(string2);
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering RadioButtonEmitter export...");
        this._varIndex = pageContext.NextInstanceCount();
        int n = Math.min(this._radioButtonValueList.size(), this._radioButtonTextDisplayList.size());
        int n2 = 0;
        while (n2 < n) {
            if (this._checkedIndex == n2) {
                writer.write("<INPUT TYPE=RADIO NAME=\"" + this.CONTROL_VAR + this._varIndex + "\" VALUE=\"" + this._radioButtonValueList.get(n2) + "\" CHECKED>");
                writer.write("\n");
            } else {
                writer.write("<INPUT TYPE=RADIO NAME=\"" + this.CONTROL_VAR + this._varIndex + "\" VALUE=\"" + this._radioButtonValueList.get(n2) + "\">");
                writer.write("\n");
            }
            String string = (String)this._radioButtonTextDisplayList.get(n2);
            writer.write(string);
            writer.write("\n");
            ++n2;
        }
        writer.write("<SCRIPT>");
        writer.write("\n");
        writer.write("\n");
        writer.write("var " + this.ADAPTER_VAR + this._varIndex + " = new PropertyBinder(" + "findEObjectByXMIID(WDO4JSModelRoot_" + this._modelName + ".Root, \"" + this._eObjectID + "\")," + "\n\t\t\"" + this._eAttributeName + "\"," + "\n\t\t document.getElementById(\"" + this.CONTROL_VAR + this._varIndex + "\")," + "\n\t\t\"value\"," + "\n\t\t\"onClick\");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".DataBind();");
        writer.write("\n");
        writer.write("</SCRIPT>");
        writer.write("\n");
        writer.write("\n");
        Streamer.trace.Header().println("Exiting RadioButtonEmitter export...");
    }
}

