/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.emitters.DataGridEmitterHelper;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class DataGridEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NAV_BAR_BOTTOM = 0;
    public static final int NAV_BAR_TOP = 1;
    public static final int NAV_BAR_BOTH = 2;
    protected String _eObjectID;
    protected String _eReferenceName;
    protected String _modelName;
    protected String _metaDataArrayString;
    protected String _width;
    protected boolean _readOnlyFlag = false;
    protected int _pageSize = -1;
    protected String _Selection = null;
    protected String _rowFilter = null;
    protected String _styleClass = null;
    protected ArrayList _colArray = new ArrayList(7);
    protected int _navBarPosition = 0;
    protected boolean _showRowIndex = false;
    protected String _onhighlight;
    protected String _onselect;
    protected String _onunselect;
    protected String _onpage;
    protected String _onsort;
    protected String _onfilter;
    protected String _onselectall;
    protected String _onunselectall;

    public DataGridEmitter() {
        super("ODCDataGrid");
    }

    public void Init(String string, String string2, String string3, boolean bl, int n) {
        this.Init(string, string2, string3, bl, null, n, false, null, false, null, "-1", null, null, 0, false, null, null, null, null, null, null, null, null);
    }

    public void Init(String string, String string2, String string3, boolean bl, int n, String string4, String string5) {
        this.Init(string, string2, string3, bl, null, n, false, null, false, null, "-1", string4, string5, 0, false, null, null, null, null, null, null, null, null);
    }

    public void Init(String string, String string2, String string3, boolean bl, String string4, int n, boolean bl2, String string5, boolean bl3, String string6, String string7, String string8, String string9, int n2, boolean bl4, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17) {
        this._eObjectID = string2;
        this._eReferenceName = string3;
        this._modelName = string;
        this._readOnlyFlag = bl;
        this._pageSize = n;
        this._width = string4;
        this._Selection = bl2 ? "[" + (string5 == null ? null : "'" + string5 + "'") + ",'" + (bl3 ? "checkbox" : "radio") + "'," + (string6 == null ? null : "'" + string6 + "'") + "," + string7 + "]" : null;
        this._rowFilter = string8;
        this._styleClass = string9;
        this._navBarPosition = n2 >= 0 && n2 <= 2 ? n2 : 0;
        this._showRowIndex = bl4;
        this._onhighlight = string10;
        this._onselect = string11;
        this._onunselect = string12;
        this._onpage = string13;
        this._onfilter = string14;
        this._onsort = string15;
        this._onselectall = string16;
        this._onunselectall = string17;
        Streamer.debug.Header().println("eObjectID: " + this._eObjectID + "\n" + "eReferenceName: " + this._eReferenceName + "\n" + "modelName: " + this._modelName + "\n" + "readOnlyFlag: " + this._readOnlyFlag + "\n" + "pageSize: " + this._pageSize + "\n" + "selection: " + this._Selection + "\n" + "rowFilter: " + this._rowFilter + "\n" + "styleClass: " + this._styleClass + "\n" + "navBarPosition " + this._navBarPosition + "\n" + "showRowIndex: " + this._showRowIndex);
    }

    public void setEObjectID(String string) {
        this._eObjectID = string;
    }

    public void setEReferenceName(String string) {
        this._eReferenceName = string;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public void setReadOnlyFlag(boolean bl) {
        this._readOnlyFlag = bl;
    }

    public void setPageSize(int n) {
        this._pageSize = n;
    }

    public void setRowFilter(String string) {
        this._rowFilter = string;
    }

    public void setStyleClass(String string) {
        this._styleClass = string;
    }

    public void addColumn(DataGridEmitterHelper dataGridEmitterHelper) {
        this._colArray.add(dataGridEmitterHelper);
    }

    public void setNavBarPosition(int n) {
        this._navBarPosition = n;
    }

    public void setShowRowIndex(boolean bl) {
        this._showRowIndex = bl;
    }

    public void setOnhighlight(String string) {
        this._onhighlight = string;
    }

    public void setOnselect(String string) {
        this._onselect = string;
    }

    public void setOnunselect(String string) {
        this._onunselect = string;
    }

    public void setOnpage(String string) {
        this._onpage = string;
    }

    public void setOnsort(String string) {
        this._onsort = string;
    }

    public void setOnfilter(String string) {
        this._onfilter = string;
    }

    public void setOnselectall(String string) {
        this._onselectall = string;
    }

    public void setOnunselectall(String string) {
        this._onunselectall = string;
    }

    public void setWidth(String string) {
        this._width = string;
    }

    public void constructMetaDataArrayString() {
        String string = "[";
        int n = 0;
        while (n < this._colArray.size()) {
            DataGridEmitterHelper dataGridEmitterHelper = (DataGridEmitterHelper)this._colArray.get(n);
            string = n == 0 ? string + dataGridEmitterHelper.getMetaDataArrayString() : string + ", " + dataGridEmitterHelper.getMetaDataArrayString();
            ++n;
        }
        this._metaDataArrayString = string = string + "]";
        Streamer.debug.Header().println("Column Metadata String: " + this._metaDataArrayString);
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        boolean bl;
        Streamer.trace.Header().println("Entering DataGridEmitter export...");
        this._varIndex = pageContext.NextInstanceCount();
        writer.write("<SCRIPT>ODCProgressBar.startRenderControl(datagrid);</SCRIPT>\n");
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        boolean bl2 = bl = pageContext.getContextVariable("DEBUG_MODE") == "YES";
        if (!BaseEmitter.TestGuard(pageContext, "DATAGRID_JS_FLAG")) {
            if (bl) {
                writer.write("\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/datagrid/datagridcontrol.js") + "\"></SCRIPT>" + "\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/datagrid/datagridadapter.js") + "\"></SCRIPT>");
                Streamer.trace.Header().println("Included individual datagrid JS control and adapter files...");
            } else {
                writer.write("<SCRIPT language=\"JavaScript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_datagrid_c.js") + "\"></SCRIPT>\n");
                Streamer.trace.Header().println("Included compressed datagrid JS file...");
            }
        }
        writer.write("<SPAN id=\"" + this.CONTROL_VAR + this._varIndex + "\"></SPAN>\n" + "<SCRIPT>\n" + "var td = document.getElementById(\"" + this.CONTROL_VAR + this._varIndex + "\");\n");
        writer.write("var " + this.CONTROL_VAR + this._varIndex + " = new DataGrid(td, new Array(");
        int n = 0;
        while (n < this._colArray.size()) {
            DataGridEmitterHelper dataGridEmitterHelper = (DataGridEmitterHelper)this._colArray.get(n);
            if (n != 0) {
                writer.write(", ");
            }
            writer.write("\"" + dataGridEmitterHelper.getDisplayLabel() + "\"");
            ++n;
        }
        writer.write("), URL_REWRITER_PREFIX);\n");
        this.constructMetaDataArrayString();
        writer.write(this.CONTROL_VAR + this._varIndex + ".metaData = " + this._metaDataArrayString + ";\n" + "var " + this.ADAPTER_VAR + this._varIndex + " = new DatagridAdapter(" + this.CONTROL_VAR + this._varIndex + ");\n" + this.ADAPTER_VAR + this._varIndex + ".setModel(WDO4JSModelRoot_" + this._modelName + ".Root);\n" + this.ADAPTER_VAR + this._varIndex + ".propertyName = \"" + this._eReferenceName + "\";\n" + "var rootObject = findEObjectByXMIID(WDO4JSModelRoot_" + this._modelName + ".Root, \"" + this._eObjectID + "\");\n" + this.ADAPTER_VAR + this._varIndex + ".parentEObject = rootObject;\n" + this.CONTROL_VAR + this._varIndex + ".ReadOnly = " + this._readOnlyFlag + ";\n");
        if (this._rowFilter != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".RowFilter = \"" + this._rowFilter + "\";\n");
        }
        if (this._styleClass != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".setStyleClass(\"" + this._styleClass + "\");\n");
        }
        writer.write(this.CONTROL_VAR + this._varIndex + ".AllowPaging = true;\n" + this.CONTROL_VAR + this._varIndex + ".PageSize = " + this._pageSize + ";\n");
        if (this._Selection != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".selectCol = " + this._Selection + ";\n");
        }
        if (this._width != null && !this._width.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".setWidth(\"" + this._width + "\");\n");
        }
        writer.write(this.CONTROL_VAR + this._varIndex + ".NavBarPosition = " + this._navBarPosition + ";\n" + this.CONTROL_VAR + this._varIndex + ".showRowIndex = " + this._showRowIndex + ";\n");
        if (this._onhighlight != null && !this._onhighlight.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnHighlight\",\"" + this._onhighlight + "\");\n");
        }
        if (this._onselect != null && !this._onselect.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnSelect\",\"" + this._onselect + "\");\n");
        }
        if (this._onunselect != null && !this._onunselect.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnUnSelect\",\"" + this._onunselect + "\");\n");
        }
        if (this._onselectall != null && !this._onselectall.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnSelectAll\",\"" + this._onselectall + "\");\n");
        }
        if (this._onunselectall != null && !this._onunselectall.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnUnSelectAll\",\"" + this._onunselectall + "\");\n");
        }
        if (this._onpage != null && !this._onpage.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnPage\",\"" + this._onpage + "\");\n");
        }
        if (this._onfilter != null && !this._onfilter.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnFilter\",\"" + this._onfilter + "\");\n");
        }
        if (this._onsort != null && !this._onsort.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"OnSort\",\"" + this._onsort + "\");\n");
        }
        writer.write(this.ADAPTER_VAR + this._varIndex + ".bind();\n" + this.CONTROL_VAR + this._varIndex + ".ShowGrid();\n" + "ODCProgressBar.endRenderControl(datagrid);\n" + "</SCRIPT>\n");
        Streamer.trace.Header().println("Exiting DataGridEmitter export...");
    }
}

