/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.NLResourceManager;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class ClientConverterHelper {
    public static final String DATESTYLE_FULL = "full";
    public static final String DATESTYLE_LONG = "long";
    public static final String DATESTYLE_MEDIUM = "medium";
    public static final String DATESTYLE_SHORT = "short";
    public static final String DATETYPE_DATE = "date";
    public static final String DATETYPE_TIME = "time";
    public static final String DATETYPE_BOTH = "both";
    public static final String NUMBERSTYLE_CURRENCY = "currency";
    public static final String NUMBERSTYLE_NUMBER = "number";
    public static final String NUMBERSTYLE_PERCENT = "percent";
    private static final Class[] GET_INSTANCE_PARAM_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClientConverterHelper.class$("java.lang.String")) : class$java$lang$String};
    private static Class currencyClass;
    private static HashMap stringsCache;
    private static final String PROPERTIES_FILE = "runtimeibm";
    static /* synthetic */ Class class$java$lang$String;

    public static final String getJsDateConverterString(String string, String string2, String string3, String string4, Locale locale) {
        Serializable serializable;
        String string5 = null;
        if (string != null && !string.equals("")) {
            string5 = string;
        } else {
            serializable = null;
            if (string2.equals(DATETYPE_BOTH)) {
                serializable = DateFormat.getDateTimeInstance(ClientConverterHelper.getStyleCode(string3), ClientConverterHelper.getStyleCode(string4), locale);
            } else if (string2.equals(DATETYPE_DATE)) {
                serializable = DateFormat.getDateInstance(ClientConverterHelper.getStyleCode(string3), locale);
            } else if (string2.equals(DATETYPE_TIME)) {
                serializable = DateFormat.getTimeInstance(ClientConverterHelper.getStyleCode(string4), locale);
            } else {
                new IllegalArgumentException("Invalid type: " + string2);
            }
            string5 = ((SimpleDateFormat)serializable).toPattern();
        }
        if (null != string5) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("new hX_2.DateTimeConverter(\"strict:1\", \"format:");
            ((StringBuffer)serializable).append(string5);
            ((StringBuffer)serializable).append("\")");
            return ((StringBuffer)serializable).toString();
        }
        return null;
    }

    private static int getStyleCode(String string) {
        int n = 2;
        if (string != null && string != "") {
            if (DATESTYLE_SHORT.equalsIgnoreCase(string)) {
                n = 3;
            } else if (DATESTYLE_MEDIUM.equalsIgnoreCase(string)) {
                n = 2;
            } else if (DATESTYLE_LONG.equalsIgnoreCase(string)) {
                n = 1;
            } else if (DATESTYLE_FULL.equalsIgnoreCase(string)) {
                n = 0;
            }
        }
        return n;
    }

    private static String getJsMaskConverterString(String string) {
        return "new MaskConverter('" + string + "')";
    }

    public static final String getJsNumberConverter(String string, String string2, String string3, String string4, Integer n, Integer n2, int n3, int n4, Boolean bl, Locale locale) {
        Object object;
        Serializable serializable;
        String string5 = null;
        try {
            serializable = ClientConverterHelper.getNumberFormat(string, string2, locale);
            if (string != null && !string.equals("") || NUMBERSTYLE_CURRENCY.equals(string2)) {
                ClientConverterHelper.configureCurrency(string3, string4, (NumberFormat)serializable);
            }
            ClientConverterHelper.configureFormatter(n, n2, n3, n4, bl, (NumberFormat)serializable);
            if (serializable instanceof DecimalFormat) {
                string5 = ((DecimalFormat)serializable).toPattern();
            } else {
                object = ((Format)serializable).format(new Double(1.111111111111111E17));
                string5 = ((String)object).replace('1', '#');
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (null != string5 && string5.length() > 0) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("new hX_2.NumberConverter(\"strict:1\", \"pattern:");
            ((StringBuffer)serializable).append(string5);
            ((StringBuffer)serializable).append("\", \"locale:");
            object = new DecimalFormatSymbols(locale);
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getGroupingSeparator());
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getDecimalSeparator());
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getPercent());
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getPerMill());
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getMinusSign());
            ((StringBuffer)serializable).append(((DecimalFormatSymbols)object).getCurrencySymbol());
            ((StringBuffer)serializable).append("\")");
            return ((StringBuffer)serializable).toString();
        }
        return null;
    }

    private static NumberFormat getNumberFormat(String string, String string2, Locale locale) {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (string != null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(string, decimalFormatSymbols);
        }
        if (string2.equals(NUMBERSTYLE_CURRENCY)) {
            return NumberFormat.getCurrencyInstance(locale);
        }
        if (string2.equals(NUMBERSTYLE_NUMBER)) {
            return NumberFormat.getNumberInstance(locale);
        }
        if (string2.equals(NUMBERSTYLE_PERCENT)) {
            return NumberFormat.getPercentInstance(locale);
        }
        throw new IllegalArgumentException(string2);
    }

    private static void configureCurrency(String string, String string2, NumberFormat numberFormat) throws Exception {
        String string3 = null;
        String string4 = null;
        if (string == null && string2 == null) {
            return;
        }
        if (string != null && string2 != null) {
            if (currencyClass != null) {
                string3 = string;
            } else {
                string4 = string2;
            }
        } else if (string == null) {
            string4 = string2;
        } else if (currencyClass != null) {
            string3 = string;
        } else {
            string4 = string;
        }
        if (string3 != null) {
            Object[] objectArray = new Object[1];
            Method method = currencyClass.getMethod("getInstance", GET_INSTANCE_PARAM_TYPES);
            objectArray[0] = string3;
            Object object = method.invoke(null, objectArray);
            Class[] classArray = new Class[]{currencyClass};
            Class<?> clazz = Class.forName("java.text.NumberFormat");
            method = clazz.getMethod("setCurrency", classArray);
            objectArray[0] = object;
            method.invoke((Object)numberFormat, objectArray);
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(string4);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    private static void configureFormatter(Integer n, Integer n2, int n3, int n4, Boolean bl, NumberFormat numberFormat) {
        if (bl != null) {
            numberFormat.setGroupingUsed(bl);
        } else {
            numberFormat.setGroupingUsed(true);
        }
        if (n != null) {
            numberFormat.setMaximumIntegerDigits(n);
        }
        if (n2 != null) {
            numberFormat.setMinimumIntegerDigits(n2);
        }
        numberFormat.setMaximumFractionDigits(n3);
        numberFormat.setMinimumFractionDigits(n4);
    }

    public static void main(String[] stringArray) {
        String string = ClientConverterHelper.getJsDateConverterString("MM/dd/yyyy HH:mm:ss z", DATETYPE_DATE, DATESTYLE_LONG, null, Locale.getDefault());
        System.out.println("DateConverterString: " + string);
        String string2 = ClientConverterHelper.getJsNumberConverter("#,##0.00;(#,##0.00)", NUMBERSTYLE_CURRENCY, "USD", "US$", null, null, 2, 2, null, Locale.getDefault());
        System.out.println("CurrncyConverterString: " + string2);
    }

    public static void initJSLibraries(Locale locale, Writer writer, PageContext pageContext) throws IOException {
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        ClientConverterHelper.initJSLibraries(locale, writer, pageContext, uRLRewriter);
    }

    public static void initJSLibraries(Locale locale, Writer writer, PageContext pageContext, URLRewriter uRLRewriter) throws IOException {
        Streamer.trace.Header().println("Entering ClientConverterHelper.initJSLibraries()");
        StringBuffer stringBuffer = new StringBuffer();
        if (!BaseEmitter.TestGuard(pageContext, "CLIENT_CONVERTER_HELPER_JS_FLAG")) {
            stringBuffer.append("\n<SCRIPT language=\"JavaScript\" src=\"").append(uRLRewriter.Rewrite("hxclient_v2.js")).append("\" type=\"text/JavaScript\"></SCRIPT>\n");
            Streamer.debug.Header().print("Output from ClientConverterHelper.initJSLibraries():" + stringBuffer.toString());
            writer.write(stringBuffer.toString());
            try {
                String string = NLResourceManager.getFile("baseurl", uRLRewriter.Rewrite("jsl/hxclient_S_BF_2"), "jsl/hxclient_S_BF_2", locale.toString());
                Streamer.debug.Header().println("hxclient_S file path --> " + string);
                writer.write("<SCRIPT src=\"" + string + "\"></SCRIPT>");
                writer.write("\n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Streamer.error.Header().printStackTrace(exception);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("<script>\n").append("hX_2.setResourceServer('" + uRLRewriter.Rewrite("") + "');").append("</script>\n");
            writer.write(stringBuffer.toString());
        }
        Streamer.trace.Header().println("Exiting ClientConverterHelper.initJSLibraries()");
    }

    public static String buildLocalizedLibName(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(PROPERTIES_FILE);
        }
        if (resourceBundle == null) {
            return string;
        }
        String string2 = resourceBundle.getString("Locale.suffix");
        if (string2 == null || string2.trim().length() == 0 || string2.equals("!Locale.suffix!")) {
            return string;
        }
        int n = string.lastIndexOf(".js");
        return string.substring(0, n) + "_" + string2 + ".js";
    }

    public static void printOnPageLoad(Writer writer, PageContext pageContext) {
        try {
            if (!BaseEmitter.TestGuard(pageContext, "CLIENT_CONVERTER_HELPER_ONLOAD_FLAG")) {
                writer.write("<script>");
                writer.write("hX_2.onPageLoad();\n");
                writer.write("</script>");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Streamer.error.Header().print("Output from ClientConverterHelper.printOnPageLoad()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        stringsCache = new HashMap();
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {}
    }
}

