/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.bf.renderkit;

import com.ibm.faces.bf.component.UIBrowserFramework;
import com.ibm.faces.bf.component.UIClientBinder;
import com.ibm.faces.bf.component.UIClientData;
import com.ibm.odcb.jrender.misc.PathTokenizer;
import com.ibm.odcb.jrender.misc.TypesUtil;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletRequest;

public class ELUtil {
    private UIComponent component;
    private String originalBindingExpression;
    private PathTokenizer ot;
    private static final String ODC_MODEL_MAP = "ODCModels";
    private String rootBindingExpression;
    private String modelName;
    private Object rootObject;
    private Object lastObject;
    private ValueBinding vb;

    public ELUtil(UIComponent uIComponent) {
        this.component = uIComponent;
        if (uIComponent instanceof UIClientBinder || uIComponent instanceof UIClientData) {
            this.createExpressionsAndTokenizers(uIComponent.getValueBinding("value"));
        } else if (uIComponent instanceof UIBrowserFramework && ((UIBrowserFramework)uIComponent).getClientBinding() != null) {
            this.createExpressionsAndTokenizers(((UIBrowserFramework)uIComponent).getClientBinding());
        }
    }

    private void createExpressionsAndTokenizers(ValueBinding valueBinding) {
        if (valueBinding == null) {
            return;
        }
        this.vb = valueBinding;
        String string = valueBinding.getExpressionString();
        if (string != null && !string.equals("") && Util.isVBExpression((String)string)) {
            string = PathTokenizer.getStrippedValueString(string);
        }
        this.originalBindingExpression = new String(string);
        this.ot = new PathTokenizer(this.originalBindingExpression);
    }

    public Object getRootObject() throws PropertyNotFoundException {
        if (this.rootObject == null) {
            this.getModelName();
            this.rootObject = ELUtil.getObject(this.rootBindingExpression);
        }
        return this.rootObject;
    }

    public Object resolveWholeExpressionToObject() throws PropertyNotFoundException {
        return ELUtil.getObject(this.originalBindingExpression);
    }

    public Object getLastObject() throws PropertyNotFoundException {
        if (this.lastObject == null) {
            this.getModelName();
            String string = this.ot.getPathToLastObject();
            String string2 = null;
            if (string.endsWith("]")) {
                string2 = string.substring(0, string.lastIndexOf(91));
            }
            this.lastObject = string.indexOf(this.rootBindingExpression) == -1 ? this.rootObject : ELUtil.getObject(string);
        }
        return this.lastObject;
    }

    public String getLastToken() {
        return this.ot.getLastToken();
    }

    public String getOriginalBindingExpression() {
        return this.originalBindingExpression;
    }

    public String getRootBindingExpression() {
        if (this.rootBindingExpression == null) {
            this.getModelName();
        }
        return this.rootBindingExpression;
    }

    public static Object getObject(String string) throws PropertyNotFoundException {
        Class clazz;
        ValueBinding valueBinding = FacesContext.getCurrentInstance().getApplication().createValueBinding("#{" + string + "}");
        Object object = valueBinding.getValue(FacesContext.getCurrentInstance());
        if (object == null && (clazz = valueBinding.getType(FacesContext.getCurrentInstance())) == null) {
            throw new PropertyNotFoundException("The EL expression = " + string + " did not resolve to an object.");
        }
        return object;
    }

    public String getModelName() {
        if (this.modelName == null) {
            if (this.component instanceof UIClientData) {
                this.modelName = ((UIClientData)this.component).getModelName();
                if (this.modelName == null || this.modelName.equals("")) {
                    this.modelName = ELUtil.createModelName(this.originalBindingExpression);
                }
                this.rootBindingExpression = this.originalBindingExpression;
                ELUtil.addModel(this.originalBindingExpression, this.modelName);
            } else {
                Map map = ELUtil.getRequestMap(ODC_MODEL_MAP);
                Iterator iterator = map.keySet().iterator();
                String string = null;
                int n = -1;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    int n2 = -1;
                    if (this.originalBindingExpression.indexOf(string2) == 0) {
                        n2 = string2.length() - 1;
                    }
                    if (n2 <= n) continue;
                    n = n2;
                    string = string2;
                }
                if (string != null) {
                    this.rootBindingExpression = string;
                    if (this.originalBindingExpression.length() >= string.length() + 3 && this.originalBindingExpression.charAt(string.length()) == '[' && this.originalBindingExpression.charAt(string.length() + 2) == ']') {
                        this.rootBindingExpression = this.originalBindingExpression.substring(0, string.length() + 3);
                    }
                    this.modelName = (String)map.get(string);
                }
            }
        }
        return this.modelName;
    }

    public boolean isListBinding() {
        if (this.vb == null) {
            return false;
        }
        if (this.vb.getType(FacesContext.getCurrentInstance()) == null) {
            return true;
        }
        boolean bl = false;
        try {
            bl = TypesUtil.isGeneralList(this.vb.getType(FacesContext.getCurrentInstance()).getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return bl;
    }

    public static void addModel(String string, String string2) {
        ELUtil.getRequestMap(ODC_MODEL_MAP).put(string, string2);
    }

    private static Map getRequestMap(String string) {
        Map map = null;
        ServletRequest servletRequest = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (servletRequest.getAttribute(string) == null) {
            map = new HashMap();
            servletRequest.setAttribute(string, map);
        } else {
            map = (Map)servletRequest.getAttribute(string);
        }
        return map;
    }

    public static String createModelName(String string) {
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        String[] stringArray = pathTokenizer.getTokens();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append('_');
            }
            if (stringArray[n].indexOf(91) != -1) {
                stringBuffer.append(stringArray[n].substring(0, stringArray[n].indexOf(91)));
                stringBuffer.append(stringArray[n].substring(stringArray[n].indexOf(91) + 1, stringArray[n].indexOf(93)));
            } else {
                stringBuffer.append(stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

