/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ServerLocationVisual
extends JPanel {
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private transient WLInstantiatingIterator instantiatingIterator;
    private JButton locationBrowseButton;
    private JLabel locationLabel;
    private JTextField locationField;
    private JPanel formattingPanel;
    private JFileChooser fileChooser;

    public ServerLocationVisual(WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.setName(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_LOCATION_STEP"));
        this.init();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        String location = this.getInstallLocation();
        if (location.trim().length() < 1) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_EMPTY_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        File serverRoot = FileUtil.normalizeFile((File)new File(location));
        if ((serverRoot = ServerLocationVisual.findServerLocation(serverRoot, wizardDescriptor)) == null) {
            return false;
        }
        location = serverRoot.getPath();
        Version version = WLPluginProperties.getServerVersion(serverRoot);
        if (!WLPluginProperties.isSupportedVersion(version)) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_VERSION");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        if (!WLPluginProperties.isGoodServerLocation(serverRoot)) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        WLPluginProperties.setLastServerRoot(location);
        this.instantiatingIterator.setServerRoot(location);
        this.instantiatingIterator.setServerVersion(version);
        return true;
    }

    public static File findServerLocation(File candidate, WizardDescriptor wizardDescriptor) {
        if (WLPluginProperties.isGoodServerLocation(candidate)) {
            return candidate;
        }
        File[] files = candidate.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.startsWith("wlserver") || !WLPluginProperties.isGoodServerLocation(file)) continue;
                String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"WARN_CHILD_SERVER_ROOT", (Object)candidate.getPath(), (Object)file.getPath());
                wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
                return file;
            }
        }
        String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_ROOT");
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
        return null;
    }

    private void init() {
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationBrowseButton = new JButton();
        this.formattingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"LBL_SERVER_LOCATION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.locationLabel.setLabelFor(this.locationField);
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationField.setColumns(10);
        this.locationField.addKeyListener(new LocationKeyListener());
        String loc = WLPluginProperties.getLastServerRoot();
        if (loc != null) {
            this.locationField.setText(loc);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.locationField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationField"));
        this.add((Component)this.locationField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.locationBrowseButton, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"LBL_BROWSE_BUTTON"));
        this.locationBrowseButton.addActionListener(new BrowseActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.locationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationBrowseButton"));
        this.add((Component)this.locationBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.formattingPanel, gridBagConstraints);
    }

    private String getInstallLocation() {
        return this.locationField.getText();
    }

    private void showFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setFileFilter(new DirectoryFileFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        File currentLocation = new File(this.locationField.getText());
        if (currentLocation.exists() && currentLocation.isDirectory()) {
            this.fileChooser.setCurrentDirectory(currentLocation.getParentFile());
            this.fileChooser.setSelectedFile(currentLocation);
        }
        if (this.fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.locationField.setText(this.fileChooser.getSelectedFile().getPath());
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ServerLocationVisual.this.showFileChooser();
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ServerLocationVisual.class, (String)"DIRECTORIES_FILTER_NAME");
        }
    }

    private class LocationKeyListener
    extends KeyAdapter {
        private LocationKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            ServerLocationVisual.this.fireChangeEvent();
        }

        @Override
        public void keyReleased(KeyEvent event) {
            ServerLocationVisual.this.fireChangeEvent();
        }
    }
}

