/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class WLJpa2SwitchSupport {
    private static final Version SWITCH_SUPPORTED_VERSION_MIN = Version.fromJsr277NotationWithFallback((String)"10.3.4");
    private static final String OEPE_CONTRIBUTIONS_JAR = "oepe-contributions.jar";
    private static final Pattern JPA_JAR_1_PATTERN = Pattern.compile("^.*javax\\.persistence.*(_2-\\d+(-\\d+)?)\\.jar$");
    private static final String JPA_JAR1_FALLBACK = "javax.persistence_1.0.0.0_2-0-0.jar";
    private static final Pattern JPA_JAR_2_PATTERN = Pattern.compile("^.*com\\.oracle\\.jpa2support.*\\.jar$");
    private static final String JPA_JAR2_FALLBACK = "com.oracle.jpa2support_1.0.0.0_2-0.jar";
    private static final Logger LOGGER = Logger.getLogger(WLJpa2SwitchSupport.class.getName());
    private final File serverRoot;
    private final WLDeploymentManager dm;
    private Version serverVersion;

    public WLJpa2SwitchSupport(File serverRoot) {
        this.dm = null;
        this.serverRoot = serverRoot;
    }

    public WLJpa2SwitchSupport(WLDeploymentManager dm) {
        this.dm = dm;
        this.serverRoot = WLPluginProperties.getServerRoot(dm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSwitchSupported() {
        Version version = null;
        WLJpa2SwitchSupport wLJpa2SwitchSupport = this;
        synchronized (wLJpa2SwitchSupport) {
            if (this.serverVersion != null) {
                version = this.serverVersion;
            } else {
                version = this.dm != null ? this.dm.getServerVersion() : WLPluginProperties.getServerVersion(this.serverRoot);
                this.serverVersion = version;
            }
        }
        return version != null && version.isAboveOrEqual(SWITCH_SUPPORTED_VERSION_MIN) && SWITCH_SUPPORTED_VERSION_MIN.getMajor().equals(version.getMajor()) && SWITCH_SUPPORTED_VERSION_MIN.getMinor().equals(version.getMinor());
    }

    public void enable() {
        ArrayList<1> actions = new ArrayList<1>();
        actions.add(new ProgressSupport.BackgroundAction(){

            protected void run(ProgressSupport.Context actionContext) {
                actionContext.progress(NbBundle.getMessage(WLJpa2SwitchSupport.class, (String)"MSG_Enabling_JPA2"));
                WLJpa2SwitchSupport.this.doEnable();
            }
        });
        ProgressSupport.invoke(actions);
    }

    public void disable() {
        ArrayList<2> actions = new ArrayList<2>();
        actions.add(new ProgressSupport.BackgroundAction(){

            protected void run(ProgressSupport.Context actionContext) {
                actionContext.progress(NbBundle.getMessage(WLJpa2SwitchSupport.class, (String)"MSG_Disabling_JPA2"));
                WLJpa2SwitchSupport.this.doDisable();
            }
        });
        ProgressSupport.invoke(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnable() {
        if (!this.isSwitchSupported()) {
            throw new IllegalStateException("JPA2 switching is not supported for WebLogic " + this.serverRoot);
        }
        try {
            String path;
            File libDir = WLPluginProperties.getServerLibDirectory(this.serverRoot);
            if (libDir != null) {
                libDir = FileUtil.normalizeFile((File)libDir);
            }
            if ((path = this.getPathToModules(libDir)).length() > 0) {
                path = path + "/";
            }
            File oepeFile = new File(libDir, OEPE_CONTRIBUTIONS_JAR);
            String relPath = path;
            Jpa2Jars jars = this.getJpa2Jars(libDir, path);
            String contribPath = path + jars.getJpa1Jar() + " " + path + jars.getJpa2Jar();
            if (!oepeFile.exists()) {
                this.createContributionsJar(oepeFile, contribPath);
            } else {
                JarFile oepeJarFile = new JarFile(oepeFile);
                try {
                    Manifest mf = oepeJarFile.getManifest();
                    String cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                    if (cp == null) {
                        cp = "";
                    }
                    if (!(JPA_JAR_1_PATTERN.matcher(cp).matches() && cp.contains(jars.getJpa1Jar()) && JPA_JAR_2_PATTERN.matcher(cp).matches() && cp.contains(jars.getJpa2Jar()))) {
                        StringBuilder updated = new StringBuilder();
                        for (String element : cp.split("\\s+")) {
                            if (JPA_JAR_1_PATTERN.matcher(element).matches() || JPA_JAR_2_PATTERN.matcher(element).matches()) continue;
                            updated.append(element).append(" ");
                        }
                        updated.insert(0, " ").insert(0, jars.getJpa2Jar()).insert(0, relPath);
                        updated.insert(0, " ").insert(0, jars.getJpa1Jar()).insert(0, relPath);
                        if (cp.length() == 0) {
                            updated.deleteCharAt(updated.length() - 1);
                        }
                        mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, updated.toString());
                        this.replaceManifest(oepeFile, mf);
                    }
                }
                finally {
                    oepeJarFile.close();
                }
            }
            File weblogicFile = WLPluginProperties.getWeblogicJar(this.serverRoot);
            JarFile weblogicJarFile = new JarFile(weblogicFile);
            try {
                Manifest wlManifest = weblogicJarFile.getManifest();
                String cp = wlManifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (cp == null) {
                    cp = "";
                }
                if (!cp.contains(OEPE_CONTRIBUTIONS_JAR)) {
                    cp = cp.length() == 0 ? OEPE_CONTRIBUTIONS_JAR : "oepe-contributions.jar " + cp;
                    wlManifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, cp);
                    this.replaceManifest(weblogicFile, wlManifest);
                }
            }
            finally {
                weblogicJarFile.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.notifyLibrariesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisable() {
        if (!this.isSwitchSupported()) {
            throw new IllegalStateException("JPA2 switching is not supported for WebLogic " + this.serverRoot);
        }
        try {
            File oepeJarFile;
            File libDir = WLPluginProperties.getServerLibDirectory(this.serverRoot);
            if (libDir != null) {
                libDir = FileUtil.normalizeFile((File)libDir);
            }
            if (!(oepeJarFile = new File(libDir, OEPE_CONTRIBUTIONS_JAR)).exists() || !oepeJarFile.isFile()) {
                return;
            }
            JarFile file = new JarFile(oepeJarFile);
            try {
                Manifest mf = file.getManifest();
                String cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (cp == null) {
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (String element : cp.split("\\s+")) {
                    if (JPA_JAR_1_PATTERN.matcher(element).matches() || JPA_JAR_2_PATTERN.matcher(element).matches()) continue;
                    builder.append(element).append(" ");
                }
                if (builder.length() > 0) {
                    mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, builder.substring(0, builder.length() - 1));
                } else {
                    mf.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
                }
                this.replaceManifest(oepeJarFile, mf);
            }
            finally {
                file.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.notifyLibrariesChanged();
        }
    }

    public boolean isEnabled() {
        if (this.dm != null) {
            return this.dm.getJ2eePlatformImpl().isJpa2Available();
        }
        List<URL> classpath = WLJ2eePlatformFactory.getWLSClassPath(this.serverRoot, WLPluginProperties.getMiddlewareHome(this.serverRoot), null);
        for (URL url : classpath) {
            URL file = FileUtil.getArchiveFile((URL)url);
            if (file == null || !JPA_JAR_1_PATTERN.matcher(file.getFile()).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledViaSmartUpdate() {
        if (this.dm != null) {
            this.dm.getJ2eePlatformImpl().getLibraries();
            for (LibraryImplementation lib : this.dm.getJ2eePlatformImpl().getLibraries()) {
                List urls = lib.getContent("classpath");
                if (!this.isEnabledViaSmartUpdate(urls)) continue;
                return true;
            }
            return false;
        }
        List<URL> urls = WLJ2eePlatformFactory.getWLSClassPath(this.serverRoot, WLPluginProperties.getMiddlewareHome(this.serverRoot), null);
        return this.isEnabledViaSmartUpdate(urls);
    }

    private boolean isEnabledViaSmartUpdate(List<URL> urls) {
        if (urls != null) {
            for (URL url : urls) {
                URL file = FileUtil.getArchiveFile((URL)url);
                if (file == null || !file.getFile().endsWith("BUG9923849_WLS103MP4.jar")) continue;
                return true;
            }
        }
        return false;
    }

    private void notifyLibrariesChanged() {
        String[] urls;
        if (this.dm != null) {
            this.dm.getJ2eePlatformImpl().notifyLibrariesChange();
        }
        for (String url : urls = Deployment.getDefault().getInstancesOfServer("WebLogic9")) {
            String serverRootValue;
            File root;
            InstanceProperties props;
            if (this.dm != null && url.equals(this.dm.getUri()) || (props = InstanceProperties.getInstanceProperties((String)url)) == null || !(root = FileUtil.normalizeFile((File)new File(serverRootValue = props.getProperty("serverRoot")))).equals(this.serverRoot)) continue;
            try {
                WLDeploymentManager manager = (WLDeploymentManager)WLDeploymentFactory.getInstance().getDisconnectedDeploymentManager(url);
                manager.getJ2eePlatformImpl().notifyLibrariesChange();
            }
            catch (DeploymentManagerCreationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceManifest(File jarFile, Manifest manifest) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)jarFile);
        String tmpName = FileUtil.findFreeFileName((FileObject)fo.getParent(), (String)jarFile.getName(), (String)"tmp");
        File tmpJar = new File(jarFile.getParentFile(), tmpName + ".tmp");
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(jarFile));
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpJar));
                try {
                    this.replaceManifest(is, os, manifest);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
            if (tmpJar.renameTo(jarFile)) {
                LOGGER.log(Level.FINE, "Successfully moved {0}", tmpJar);
                return;
            }
            LOGGER.log(Level.FINE, "Byte to byte copy {0}", tmpJar);
            this.copy(tmpJar, jarFile);
        }
        finally {
            tmpJar.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceManifest(InputStream is, OutputStream os, Manifest manifest) throws IOException {
        JarInputStream in = new JarInputStream(is);
        try {
            JarOutputStream out = new JarOutputStream(os, manifest);
            try {
                JarEntry entry = null;
                byte[] temp = new byte[32768];
                while ((entry = in.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                    out.putNextEntry(entry);
                    while (in.available() != 0) {
                        int read = in.read(temp);
                        if (read == -1) continue;
                        out.write(temp, 0, read);
                    }
                    out.closeEntry();
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContributionsJar(File jarFile, String classpath) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpath);
            JarOutputStream dest = new JarOutputStream((OutputStream)new BufferedOutputStream(os), manifest);
            try {
                dest.closeEntry();
                dest.finish();
            }
            finally {
                dest.close();
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File source, File dest) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String getPathToModules(File from) {
        String mwHome;
        File mwHomeFile = null;
        String string = mwHome = this.dm != null ? this.dm.getProductProperties().getMiddlewareHome() : WLProductProperties.getMiddlewareHome(this.serverRoot);
        if (mwHome == null) {
            if (this.serverRoot != null && this.serverRoot.getParentFile() != null) {
                mwHomeFile = this.serverRoot.getParentFile();
            }
        } else {
            mwHomeFile = new File(mwHome);
        }
        if (mwHomeFile != null) {
            File modules = FileUtil.normalizeFile((File)new File(mwHomeFile, "modules"));
            String relativePath = WLJpa2SwitchSupport.getRelativePath(from, modules);
            if (relativePath == null) {
                return modules.getAbsolutePath();
            }
            return relativePath;
        }
        return "../../../modules";
    }

    private Jpa2Jars getJpa2Jars(File libDir, String path) {
        String jar1 = null;
        String jar2 = null;
        if (libDir != null) {
            File dir = new File(libDir, path);
            for (File candidate : dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return JPA_JAR_1_PATTERN.matcher(name).matches() || JPA_JAR_2_PATTERN.matcher(name).matches();
                }
            })) {
                if (jar1 == null && JPA_JAR_1_PATTERN.matcher(candidate.getName()).matches()) {
                    jar1 = candidate.getName();
                    continue;
                }
                if (jar2 != null) continue;
                jar2 = candidate.getName();
            }
        }
        if (jar1 == null) {
            jar1 = JPA_JAR1_FALLBACK;
        }
        if (jar2 == null) {
            jar2 = JPA_JAR2_FALLBACK;
        }
        return new Jpa2Jars(jar1, jar2);
    }

    static String getRelativePath(File from, File to) {
        String fromPath;
        String toPath = to.getAbsolutePath();
        if (toPath.startsWith(fromPath = from.getAbsolutePath())) {
            if (toPath.length() == fromPath.length()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            File currentPath = to;
            while (!currentPath.equals(from)) {
                builder.insert(0, currentPath.getName());
                builder.insert(0, "/");
                currentPath = currentPath.getParentFile();
            }
            return builder.substring(1);
        }
        File parent = from.getParentFile();
        if (parent == null) {
            return null;
        }
        return "../" + WLJpa2SwitchSupport.getRelativePath(parent, to);
    }

    private static class Jpa2Jars {
        private final String Jpa1Jar;
        private final String Jpa2Jar;

        public Jpa2Jars(String Jpa1Jar, String Jpa2Jar) {
            this.Jpa1Jar = Jpa1Jar;
            this.Jpa2Jar = Jpa2Jar;
        }

        public String getJpa1Jar() {
            return this.Jpa1Jar;
        }

        public String getJpa2Jar() {
            return this.Jpa2Jar;
        }
    }
}

