/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentManager2;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLSharedState;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTarget;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WLDeploymentManager
implements DeploymentManager2 {
    public static final int MANAGER_TIMEOUT = 60000;
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentManager.class.getName());
    private static final boolean DEBUG_JSR88 = Boolean.getBoolean(WLDeploymentManager.class.getName() + ".debugJsr88");
    private static final Map<ServerProgressObject, DeploymentStatus> OBJECTS_TO_POLL = new HashMap<ServerProgressObject, DeploymentStatus>();
    private static final RequestProcessor OBJECT_POLL_RP = new RequestProcessor("ProgressObject Poll", 1);
    private final String uri;
    private final String host;
    private final String port;
    private final WLProductProperties productProperties = new WLProductProperties(this);
    private final WLSharedState mutableState;
    private final boolean disconnected;
    private InstanceProperties instanceProperties;
    private DeploymentManager manager;
    private WLJ2eePlatformFactory.J2eePlatformImplImpl j2eePlatformImpl;
    private WLConnectionSupport connectionSupport;
    private Version serverVersion;
    private Version domainVersion;
    private boolean initialized;

    public WLDeploymentManager(String uri, String host, String port, boolean disconnected, WLSharedState mutableState) {
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.disconnected = disconnected;
        this.mutableState = mutableState;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isRemote() {
        return Boolean.parseBoolean(this.getInstanceProperties().getProperty("remote"));
    }

    @CheckForNull
    public synchronized Version getServerVersion() {
        this.init();
        return this.serverVersion;
    }

    @CheckForNull
    public synchronized Version getDomainVersion() {
        this.init();
        return this.domainVersion;
    }

    public synchronized InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.uri);
        }
        return this.instanceProperties;
    }

    @NonNull
    public synchronized WLJ2eePlatformFactory.J2eePlatformImplImpl getJ2eePlatformImpl() {
        if (this.j2eePlatformImpl == null) {
            this.j2eePlatformImpl = new WLJ2eePlatformFactory.J2eePlatformImplImpl(this);
        }
        return this.j2eePlatformImpl;
    }

    @NonNull
    public synchronized WLConnectionSupport getConnectionSupport() {
        if (this.connectionSupport == null) {
            this.connectionSupport = new WLConnectionSupport(this);
        }
        return this.connectionSupport;
    }

    public void addDomainChangeListener(ChangeListener listener) {
        this.mutableState.addDomainChangeListener(listener);
    }

    public void removeDomainChangeListener(ChangeListener listener) {
        this.mutableState.removeDomainChangeListener(listener);
    }

    public boolean isRestartNeeded() {
        return this.mutableState.isRestartNeeded();
    }

    public void setRestartNeeded(boolean restartNeeded) {
        this.mutableState.setRestartNeeded(restartNeeded);
    }

    public Process getServerProcess() {
        return this.mutableState.getServerProcess();
    }

    public void setServerProcess(Process serverProcess) {
        this.mutableState.setServerProcess(serverProcess);
    }

    public WLProductProperties getProductProperties() {
        return this.productProperties;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.serverVersion = WLPluginProperties.getServerVersion(WLPluginProperties.getServerRoot(this, true));
        this.domainVersion = WLPluginProperties.getDomainVersion(this.instanceProperties);
    }

    private <T> T executeAction(final Action<T> action) throws Exception {
        WLConnectionSupport support = this.getConnectionSupport();
        return support.executeAction(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    DeploymentManager manager = WLDeploymentManager.this.getDeploymentManager(WLDeploymentManager.this.getInstanceProperties().getProperty("username"), WLDeploymentManager.this.getInstanceProperties().getProperty("password"), WLDeploymentManager.this.host, WLDeploymentManager.this.port);
                    return action.execute(manager);
                }
                catch (DeploymentManagerCreationException ex) {
                    throw new ExecutionException(ex);
                }
            }
        });
    }

    private synchronized DeploymentManager getDeploymentManager(String username, String password, String host, String port) throws DeploymentManagerCreationException {
        if (this.manager != null) {
            try {
                Method m = this.manager.getClass().getMethod("isConnected", null);
                Object o = m.invoke((Object)this.manager, (Object[])null);
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    return this.manager;
                }
            }
            catch (NoSuchMethodException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            this.manager.release();
        }
        DeploymentManagerCreationException dmce = null;
        try {
            Class<?> helperClazz = Class.forName("weblogic.deploy.api.tools.SessionHelper", false, Thread.currentThread().getContextClassLoader());
            Method m = helperClazz.getDeclaredMethod("getDeploymentManager", String.class, String.class, String.class, String.class);
            Object o = m.invoke(null, host, port, username, password);
            if (DeploymentManager.class.isAssignableFrom(o.getClass())) {
                this.manager = (DeploymentManager)o;
                return this.manager;
            }
            dmce = new DeploymentManagerCreationException("Instance created by WebLogic is not DeploymentManager instance.");
        }
        catch (Exception e) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            dmce.initCause((Throwable)e);
        }
        catch (NoClassDefFoundError err) {
            dmce = new DeploymentManagerCreationException("Cannot create weblogic DeploymentManager instance.");
            dmce.initCause((Throwable)err);
        }
        throw dmce;
    }

    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.deploy(target, file, file2, this.getHost(), this.getPort());
    }

    public ProgressObject distribute(Target[] targets, DeploymentContext deployment) {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        this.deployOptionalPackages(deployment.getRequiredLibraries());
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.deploy(targets, deployment.getModuleFile(), deployment.getDeploymentPlan(), this.getHost(), this.getPort());
    }

    public ProgressObject distribute(Target[] target, ModuleType moduleType, InputStream inputStream, InputStream inputStream0) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.redeploy(targetModuleID, file, file2);
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, DeploymentContext deployment) {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        this.deployOptionalPackages(deployment.getRequiredLibraries());
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.redeploy(tmids, deployment.getModuleFile(), deployment.getDeploymentPlan());
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.undeploy(targetModuleID);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.stop(targetModuleID);
    }

    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        return wlDeployer.start(targetModuleID);
    }

    public TargetModuleID[] getAvailableModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getAvailableModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getNonRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getNonRunningModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public TargetModuleID[] getRunningModules(final ModuleType moduleType, final Target[] target) throws TargetException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<TargetModuleID[]>(){

                @Override
                public TargetModuleID[] execute(DeploymentManager manager) throws ExecutionException {
                    try {
                        return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(manager.getRunningModules(moduleType, WLDeploymentManager.translateTargets(manager, target)));
                    }
                    catch (TargetException ex) {
                        throw new ExecutionException(ex);
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TargetException) {
                throw (TargetException)ex.getCause();
            }
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            return new TargetModuleID[0];
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            WLConnectionSupport support = this.getConnectionSupport();
            return support.executeAction(new WLConnectionSupport.JMXRuntimeAction<Target[]>(){

                @Override
                public Target[] call(MBeanServerConnection connection, ObjectName service) throws Exception {
                    ObjectName[] domainTargets;
                    ArrayList<WLTarget> targets = new ArrayList<WLTarget>();
                    ObjectName domainPending = (ObjectName)connection.getAttribute(service, "DomainPending");
                    if (domainPending != null && (domainTargets = (ObjectName[])connection.getAttribute(domainPending, "Targets")) != null) {
                        for (ObjectName singleTarget : domainTargets) {
                            String type = (String)connection.getAttribute(singleTarget, "Type");
                            if (!"Server".equals(type)) continue;
                            String name = (String)connection.getAttribute(singleTarget, "Name");
                            targets.add(new WLTarget(name));
                        }
                    }
                    return targets.toArray(new Target[targets.size()]);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            try {
                return this.executeAction(new Action<Target[]>(){

                    @Override
                    public Target[] execute(DeploymentManager manager) throws ExecutionException {
                        Target[] targets = manager.getTargets();
                        if (targets != null) {
                            ArrayList<Target> ret = new ArrayList<Target>(targets.length);
                            for (Target t : targets) {
                                if (!"server".equals(t.getDescription())) continue;
                                ret.add(t);
                            }
                            return ret.toArray(new Target[ret.size()]);
                        }
                        return targets;
                    }
                });
            }
            catch (Exception fex) {
                LOGGER.log(Level.INFO, null, fex);
                return new Target[0];
            }
        }
    }

    public void release() {
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public ProgressObject redeploy(final TargetModuleID[] targetModuleID) throws UnsupportedOperationException, IllegalStateException {
        if (this.disconnected) {
            throw new IllegalStateException("Deployment manager is disconnected");
        }
        try {
            return this.executeAction(new Action<ProgressObject>(){

                @Override
                public ProgressObject execute(DeploymentManager manager) throws ExecutionException {
                    return WLDeploymentManager.registerProgressObject(new ServerProgressObject(manager.redeploy(WLDeploymentManager.this.translateTargetModuleIDsToServer(targetModuleID), (File)null, null)));
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex.getCause());
            WLProgressObject po = new WLProgressObject(targetModuleID);
            po.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.FAILED, NbBundle.getMessage(WLDeploymentManager.class, (String)"MSG_Redeployment_Failed", (Object)ex.getMessage())));
            return po;
        }
    }

    public void deployOptionalPackages(File[] optionalPackages) {
        CommandBasedDeployer wlDeployer = new CommandBasedDeployer(this);
        if (optionalPackages.length > 0) {
            HashSet<File> files = new HashSet<File>(Arrays.asList(optionalPackages));
            ProgressObject po = wlDeployer.deployLibraries(files);
            ProgressObjectSupport.waitFor(po);
        }
    }

    private TargetModuleID[] translateTargetModuleIDsToPlugin(TargetModuleID[] ids) {
        if (ids == null) {
            return null;
        }
        TargetModuleID[] mapped = new TargetModuleID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            mapped[i] = !(ids[i] instanceof ServerTargetModuleID) ? new ServerTargetModuleID(ids[i]) : ids[i];
        }
        return mapped;
    }

    private TargetModuleID[] translateTargetModuleIDsToServer(TargetModuleID[] ids) {
        if (ids == null) {
            return null;
        }
        TargetModuleID[] mapped = new TargetModuleID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            mapped[i] = ids[i] instanceof ServerTargetModuleID ? ((ServerTargetModuleID)ids[i]).moduleId : ids[i];
        }
        return mapped;
    }

    private static Target[] translateTargets(DeploymentManager manager, Target[] originalTargets) {
        Target[] targets = manager.getTargets();
        ArrayList<Target> deployTargets = new ArrayList<Target>(originalTargets.length);
        for (Target t : targets) {
            for (Target t2 : originalTargets) {
                if (!t.getName().equals(t2.getName())) continue;
                deployTargets.add(t);
            }
        }
        return deployTargets.toArray(new Target[deployTargets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProgressObject registerProgressObject(ServerProgressObject po) {
        Class<WLDeploymentManager> clazz = WLDeploymentManager.class;
        synchronized (WLDeploymentManager.class) {
            if (OBJECTS_TO_POLL.isEmpty()) {
                OBJECT_POLL_RP.post((Runnable)new ProgressObjectPoll());
            }
            OBJECTS_TO_POLL.put(po, po.getDeploymentStatus());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return po;
        }
    }

    static {
        if (DEBUG_JSR88) {
            System.setProperty("weblogic.deployer.debug", "all");
        }
    }

    private static interface Action<T> {
        public T execute(DeploymentManager var1) throws ExecutionException;
    }

    private static class ProgressObjectPoll
    implements Runnable {
        private ProgressObjectPoll() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                DeploymentStatus status;
                HashMap current = null;
                Class<WLDeploymentManager> clazz = WLDeploymentManager.class;
                // MONITORENTER : org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager.class
                current = new HashMap(OBJECTS_TO_POLL);
                // MONITOREXIT : clazz
                for (Map.Entry entry : current.entrySet()) {
                    status = ((ServerProgressObject)entry.getKey()).getDeploymentStatus();
                    if (status == null ? entry.getValue() != null : !status.equals(entry.getValue())) {
                        ((ServerProgressObject)entry.getKey()).fireProgressEvent(status);
                    }
                    entry.setValue(status);
                }
                Class<WLDeploymentManager> i$ = WLDeploymentManager.class;
                // MONITORENTER : org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager.class
                OBJECTS_TO_POLL.putAll(current);
                Iterator iterator = OBJECTS_TO_POLL.entrySet().iterator();
                while (iterator.hasNext()) {
                    status = (DeploymentStatus)iterator.next().getValue();
                    if (!StateType.COMPLETED.equals(status.getState()) && !StateType.FAILED.equals(status.getState()) && !StateType.RELEASED.equals(status.getState())) continue;
                    iterator.remove();
                }
                if (OBJECTS_TO_POLL.isEmpty()) {
                    // MONITOREXIT : i$
                    return;
                }
                // MONITOREXIT : i$
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private class ServerProgressObject
    implements ProgressObject {
        private final ProgressObject po;
        private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();

        public ServerProgressObject(ProgressObject po) {
            this.po = po;
        }

        public boolean isStopSupported() {
            return this.po.isStopSupported();
        }

        public boolean isCancelSupported() {
            return this.po.isCancelSupported();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(this.po.getResultTargetModuleIDs());
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.po.getDeploymentStatus();
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID tmid) {
            return this.po.getClientConfiguration(tmid);
        }

        public void stop() throws OperationUnsupportedException {
            this.po.stop();
        }

        public void cancel() throws OperationUnsupportedException {
            this.po.cancel();
        }

        public void addProgressListener(ProgressListener pl) {
            this.listeners.add(pl);
        }

        public void removeProgressListener(ProgressListener pl) {
            this.listeners.remove(pl);
        }

        public void fireProgressEvent(DeploymentStatus status) {
            ProgressEvent event = new ProgressEvent((Object)this, null, status);
            for (ProgressListener listener : this.listeners) {
                listener.handleProgressEvent(event);
            }
        }
    }

    private class ServerTargetModuleID
    implements TargetModuleID {
        private final TargetModuleID moduleId;

        public ServerTargetModuleID(TargetModuleID moduleId) {
            this.moduleId = moduleId;
        }

        public String toString() {
            return this.getModuleID();
        }

        public String getWebURL() {
            String url = this.moduleId.getWebURL();
            if (url != null && url.startsWith("/")) {
                url = "http://" + WLDeploymentManager.this.getHost() + ":" + WLDeploymentManager.this.getPort() + url;
            }
            return url;
        }

        public Target getTarget() {
            return this.moduleId.getTarget();
        }

        public TargetModuleID getParentTargetModuleID() {
            if (this.moduleId.getParentTargetModuleID() == null) {
                return null;
            }
            return new ServerTargetModuleID(this.moduleId.getParentTargetModuleID());
        }

        public String getModuleID() {
            return this.moduleId.getModuleID();
        }

        public TargetModuleID[] getChildTargetModuleID() {
            return WLDeploymentManager.this.translateTargetModuleIDsToPlugin(this.moduleId.getChildTargetModuleID());
        }
    }
}

