/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.netbeans.swing.plaf.aqua.PlainAquaToolbarUI;

class AquaToolBarButtonUI
extends BasicButtonUI
implements ChangeListener {
    private final boolean isMainToolbarButtonUI;
    private static BasicButtonListener listener = new BasicButtonListener(null);
    private final Rectangle scratch = new Rectangle();
    private FontMetrics fm = null;
    private static final int minButtonSize = 32;
    private static ImageIcon bigShadow = AquaToolBarButtonUI.loadShadow("toolbar-icons-shadow-big.png");
    private static ImageIcon smallShadow = AquaToolBarButtonUI.loadShadow("toolbar-icons-shadow-small.png");
    private static final Icon bigEmptyShadow = new Icon(){

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 33;
        }

        public int getIconHeight() {
            return 13;
        }
    };
    private static final Icon smallEmptyShadow = new Icon(){

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 22;
        }

        public int getIconHeight() {
            return 7;
        }
    };

    public AquaToolBarButtonUI(boolean bl) {
        this.isMainToolbarButtonUI = bl;
    }

    public void installUI(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        abstractButton.addMouseListener(listener);
        abstractButton.addChangeListener(this);
        abstractButton.setContentAreaFilled(false);
        abstractButton.setOpaque(false);
        abstractButton.setFocusable(false);
        abstractButton.setBorderPainted(true);
        abstractButton.setBorder(BorderFactory.createEmptyBorder(6, 2, 2, 2));
        abstractButton.setRolloverEnabled(this.isMainToolbarButtonUI);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(listener);
        if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).removeChangeListener(this);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ((AbstractButton)changeEvent.getSource()).repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds(this.scratch);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        rectangle.x = 0;
        rectangle.y = 0;
        Paint paint = ((Graphics2D)graphics).getPaint();
        this.paintBackground((Graphics2D)graphics, abstractButton, rectangle);
        rectangle.height += abstractButton.getInsets().top;
        this.paintIcon(graphics, abstractButton, rectangle);
        this.paintText(graphics, abstractButton, rectangle);
        ((Graphics2D)graphics).setPaint(paint);
    }

    private void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        int n;
        String string = abstractButton.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        graphics.setColor(abstractButton.getForeground());
        Font font = abstractButton.getFont();
        if (abstractButton.isSelected()) {
            font = new Font(font.getName(), 1, font.getSize());
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.fm == null) {
            this.fm = fontMetrics;
        }
        int n2 = 0;
        Icon icon = abstractButton.getIcon();
        if (icon != null) {
            n2 = icon.getIconWidth() + 2;
        } else {
            n = fontMetrics.stringWidth(string);
            if (n <= rectangle.width) {
                n2 = rectangle.width / 2 - n / 2;
            }
        }
        n = fontMetrics.getHeight();
        int n3 = fontMetrics.getMaxAscent();
        if (n <= rectangle.height) {
            n3 += rectangle.height / 2 - n / 2;
        }
        graphics.drawString(string, n2, n3);
    }

    private void paintBackground(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        if (!abstractButton.isSelected() && !abstractButton.getModel().isPressed()) {
            return;
        }
        Color color = this.isMainToolbarButtonUI ? UIManager.getColor("NbBrushedMetal.lightShadow") : abstractButton.getParent().getBackground();
        Color color2 = this.makeDarker(color);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.height / 2, color2));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y + rectangle.height / 2 - 1, color2, rectangle.x, rectangle.height, color));
        graphics2D.fillRect(rectangle.x, rectangle.y + rectangle.height / 2 - 1, rectangle.width, rectangle.height);
        Color color3 = this.makeDarker(color2);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color2, rectangle.x, rectangle.height / 2, color3));
        graphics2D.fillRect(rectangle.x, rectangle.y, 1, rectangle.height / 2);
        graphics2D.fillRect(rectangle.x + rectangle.width - 1, rectangle.y, 1, rectangle.height / 2);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y + rectangle.height / 2 - 1, color3, rectangle.x, rectangle.height, color2));
        graphics2D.fillRect(rectangle.x, rectangle.y + rectangle.height / 2 - 1, 1, rectangle.height);
        graphics2D.fillRect(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2 - 1, 1, rectangle.height);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.height / 2, color3));
        graphics2D.fillRect(rectangle.x + 1, rectangle.y, 1, rectangle.height / 2);
        graphics2D.fillRect(rectangle.x + rectangle.width - 2, rectangle.y, 1, rectangle.height / 2);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y + rectangle.height / 2 - 1, color3, rectangle.x, rectangle.height, color));
        graphics2D.fillRect(rectangle.x + 1, rectangle.y + rectangle.height / 2 - 1, 1, rectangle.height);
        graphics2D.fillRect(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height / 2 - 1, 1, rectangle.height);
    }

    private Color makeDarker(Color color) {
        int n = 30;
        return new Color(Math.max(color.getRed() - n, 0), Math.max(color.getGreen() - n, 0), Math.max(color.getRed() - n, 0));
    }

    private void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        boolean bl;
        Icon icon = this.getIconForState(abstractButton);
        boolean bl2 = bl = abstractButton.getText() == null || abstractButton.getText().length() == 0;
        if (icon != null) {
            int n = 0;
            int n2 = 0;
            int n3 = icon.getIconWidth();
            int n4 = icon.getIconHeight();
            if (n3 <= rectangle.width && bl) {
                n = rectangle.width / 2 - n3 / 2;
            }
            if (n4 <= rectangle.height) {
                n2 = rectangle.height / 2 - n4 / 2;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            icon.paintIcon(abstractButton, graphics, n, n2);
            if (this.isMainToolbarButtonUI && abstractButton.getModel().isRollover() && !abstractButton.getModel().isPressed()) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(8, 0.2f));
                icon.paintIcon(abstractButton, graphics, n, n2);
                graphics2D.setComposite(composite);
            }
        }
    }

    private Icon getIconForState(AbstractButton abstractButton) {
        Icon icon;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon2 = null;
        boolean bl = abstractButton.getClientProperty("PreferredIconSize") != null;
        Icon icon3 = icon = bl ? bigEmptyShadow : smallEmptyShadow;
        if (!abstractButton.isEnabled()) {
            Icon icon4 = icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null && buttonModel.isSelected()) {
                icon2 = abstractButton.getDisabledIcon();
            }
            icon = bl ? bigShadow : smallShadow;
        } else {
            if (buttonModel.isArmed() && !buttonModel.isPressed() && (icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon()) == null & buttonModel.isSelected()) {
                icon2 = abstractButton.getRolloverIcon();
            }
            if (buttonModel.isPressed()) {
                icon2 = abstractButton.getPressedIcon();
            } else if (buttonModel.isSelected()) {
                icon2 = abstractButton.getSelectedIcon();
            } else {
                Icon icon5 = icon = bl ? bigShadow : smallShadow;
            }
        }
        if (icon2 == null) {
            icon2 = abstractButton.getIcon();
        }
        if (null != icon2 && this.isMainToolbarButtonUI) {
            icon2 = new ShadowedIcon(icon2, icon, abstractButton.getClientProperty("PreferredIconSize") != null);
        }
        return icon2;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Serializable serializable;
        Dimension dimension;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = abstractButton.getText() == null || abstractButton.getText().length() == 0;
        Icon icon = this.getIconForState((AbstractButton)jComponent);
        int n = 32;
        Dimension dimension2 = icon == null ? new Dimension(bl ? 32 : 0, 32) : (dimension = new Dimension(Math.max(n, icon.getIconWidth() + 1), Math.max(32, icon.getIconHeight() + 1)));
        if (!bl) {
            serializable = this.fm;
            if (serializable == null && jComponent.getGraphicsConfiguration() != null) {
                serializable = jComponent.getGraphicsConfiguration().createCompatibleImage(1, 1).getGraphics().getFontMetrics(jComponent.getFont());
            }
            if (serializable == null) {
                serializable = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(jComponent.getFont());
            }
            dimension.width += ((FontMetrics)serializable).stringWidth(abstractButton.getText());
        }
        if (null != (serializable = abstractButton.getInsets())) {
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        return dimension;
    }

    private static ImageIcon loadShadow(String string) {
        try {
            BufferedImage bufferedImage = ImageIO.read(PlainAquaToolbarUI.class.getResourceAsStream(string));
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            Logger.getLogger(PlainAquaToolbarUI.class.getName()).log(Level.FINE, exception.getLocalizedMessage(), exception);
            return new ImageIcon(new BufferedImage(1, 1, 2));
        }
    }

    private static class ShadowedIcon
    implements Icon {
        private final Icon origIcon;
        private final Icon shadowIcon;
        private final boolean bigShadow;

        public ShadowedIcon(Icon icon, Icon icon2, boolean bl) {
            this.origIcon = icon;
            this.shadowIcon = icon2;
            this.bigShadow = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = (this.origIcon.getIconWidth() - this.shadowIcon.getIconWidth()) / 2;
            this.origIcon.paintIcon(component, graphics, n + (n3 < 0 ? -n3 : 0), n2);
            this.shadowIcon.paintIcon(component, graphics, n + (n3 > 0 ? n3 : 0), n2 + this.origIcon.getIconHeight() - (this.bigShadow ? 2 : 1));
        }

        public int getIconWidth() {
            return Math.max(this.origIcon.getIconWidth(), this.shadowIcon.getIconWidth());
        }

        public int getIconHeight() {
            return this.origIcon.getIconHeight() + this.shadowIcon.getIconHeight() - (this.bigShadow ? 2 : 1);
        }
    }
}

