/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.client.protocol;

import java.util.List;
import org.apache.maven.wagon.providers.http.httpclient.annotation.NotThreadSafe;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthSchemeRegistry;
import org.apache.maven.wagon.providers.http.httpclient.client.CookieStore;
import org.apache.maven.wagon.providers.http.httpclient.client.CredentialsProvider;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.ClientContext;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieSpecRegistry;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ClientContextConfigurer
implements ClientContext {
    private final HttpContext context;

    public ClientContextConfigurer(HttpContext context) {
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        this.context = context;
    }

    public void setCookieSpecRegistry(CookieSpecRegistry registry) {
        this.context.setAttribute("http.cookiespec-registry", registry);
    }

    public void setAuthSchemeRegistry(AuthSchemeRegistry registry) {
        this.context.setAttribute("http.authscheme-registry", registry);
    }

    public void setCookieStore(CookieStore store) {
        this.context.setAttribute("http.cookie-store", store);
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.context.setAttribute("http.auth.credentials-provider", provider);
    }

    @Deprecated
    public void setAuthSchemePref(List<String> list) {
        this.context.setAttribute("http.auth.scheme-pref", list);
    }
}

