/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifierSupport;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public final class ClassPathModifier
extends ProjectClassPathModifierImplementation {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private final Project project;
    private final PropertyEvaluator eval;
    private final ClassPathSupport cs;
    private final UpdateHelper updateHelper;
    private ReferenceHelper refHelper;
    private Callback cpModifierCallback;
    private ClassPathUiSupport.Callback cpUiSupportCallback;
    private static final Logger LOG = Logger.getLogger(ClassPathModifier.class.getName());

    public ClassPathModifier(Project project, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, ClassPathSupport.Callback cpSupportCallback, Callback cpModifierCallback, ClassPathUiSupport.Callback cpUiSupportCallback) {
        assert (project != null);
        assert (helper != null);
        assert (eval != null);
        assert (refHelper != null);
        this.project = project;
        this.eval = eval;
        this.refHelper = refHelper;
        this.updateHelper = helper;
        this.cs = new ClassPathSupport(eval, refHelper, this.updateHelper.getAntProjectHelper(), helper, cpSupportCallback);
        this.cpModifierCallback = cpModifierCallback;
        this.cpUiSupportCallback = cpUiSupportCallback;
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        Sources s = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (s != null);
        return s.getSourceGroups("java");
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sg) {
        return new String[]{"classpath/compile", "classpath/execute", "classpath/endorsed", "classpath/processor"};
    }

    protected boolean removeRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        return this.removeRoots(ClassPathModifier.convertURLsToURIs((URL[])classPathRoots), sourceGroup, type);
    }

    protected boolean removeRoots(URI[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleRoots(classPathRoots, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 2);
    }

    protected boolean addRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        return this.addRoots(ClassPathModifier.convertURLsToURIs((URL[])classPathRoots), sourceGroup, type);
    }

    public boolean addRoots(URL[] classPathRoots, String classPathProperty) throws IOException, UnsupportedOperationException {
        return this.handleRoots(ClassPathModifier.convertURLsToURIs((URL[])classPathRoots), classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 1);
    }

    protected boolean addRoots(URI[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        return this.addRoots(classPathRoots, sourceGroup, type, 1);
    }

    public boolean addRoots(URI[] classPathRoots, SourceGroup sourceGroup, String type, int operation) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleRoots(classPathRoots, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), operation);
    }

    boolean handleRoots(URI[] classPathRoots, String classPathProperty, String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        assert (classPathRoots != null) : "The classPathRoots cannot be null";
        assert (classPathProperty != null);
        return ClassPathModifierSupport.handleRoots(this.project, this.updateHelper, this.cs, this.eval, this.refHelper, this.cpUiSupportCallback, classPathRoots, classPathProperty, projectXMLElementName, operation);
    }

    protected boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleAntArtifacts(artifacts, artifactElements, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 2);
    }

    protected boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleAntArtifacts(artifacts, artifactElements, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 1);
    }

    boolean handleAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, String classPathProperty, String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        return ClassPathModifierSupport.handleAntArtifacts(this.project, this.updateHelper, this.cs, this.eval, this.refHelper, this.cpUiSupportCallback, artifacts, artifactElements, classPathProperty, projectXMLElementName, operation);
    }

    protected boolean removeLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleLibraries(libraries, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 2);
    }

    protected boolean addLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
        String classPathProperty = this.cpModifierCallback.getClassPathProperty(sourceGroup, type);
        return this.handleLibraries(libraries, classPathProperty, this.cpModifierCallback.getElementName(classPathProperty), 1);
    }

    boolean handleLibraries(Library[] libraries, String classPathProperty, String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        return ClassPathModifierSupport.handleLibraries(this.project, this.updateHelper.getAntProjectHelper(), this.cs, this.eval, this.cpUiSupportCallback, this.refHelper, libraries, classPathProperty, projectXMLElementName, operation);
    }

    public ClassPathSupport getClassPathSupport() {
        return this.cs;
    }

    public static interface Callback {
        public String getClassPathProperty(SourceGroup var1, String var2);

        public String getElementName(String var1);
    }
}

