/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DemoImages
extends Component {
    private static String[] names = new String[]{"java-logo.gif", "bld.jpg", "boat.png", "box.gif", "boxwave.gif", "clouds.jpg", "duke.gif", "duke.running.gif", "dukeplug.gif", "fight.gif", "globe.gif", "java_logo.png", "jumptojavastrip.png", "magnify.gif", "painting.gif", "remove.gif", "snooze.gif", "star7.gif", "surfing.gif", "thumbsup.gif", "tip.gif", "duke.png", "print.gif", "loop.gif", "looping.gif", "start.gif", "start2.gif", "stop.gif", "stop2.gif", "clone.gif"};
    private static Map<String, Image> cache = new ConcurrentHashMap<String, Image>(names.length);

    public DemoImages() {
        for (String string : names) {
            cache.put(string, DemoImages.getImage(string, this));
        }
    }

    public static Image getImage(String string, Component component) {
        Image image = null;
        if (cache != null && (image = cache.get(string)) != null) {
            return image;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)component.getClass().getClassLoader();
        URL uRL = uRLClassLoader.findResource("images/" + string);
        image = component.getToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
            if (mediaTracker.isErrorAny()) {
                System.out.println("Error loading image " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }
}

