/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.projects.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import org.nbheaven.sqe.core.maven.api.MavenPluginConfiguration;
import org.nbheaven.sqe.core.maven.utils.FileUtilities;
import org.nbheaven.sqe.core.maven.utils.MavenUtilities;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDIncludes;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettings;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettingsProvider;
import org.nbheaven.sqe.tools.pmd.codedefects.projects.maven.MavenDefaults;
import org.nbheaven.sqe.tools.pmd.codedefects.projects.maven.MavenPMDIncludes;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MavenPmdSettingsProvider
implements PMDSettingsProvider {
    private final Project p;
    private PMDIncludes includes;

    public MavenPmdSettingsProvider(Project project) {
        this.p = project;
        this.includes = new MavenPMDIncludes(this.p);
    }

    public PMDSettings getPMDSettings() {
        final MavenPluginConfiguration pluginConfiguration = MavenUtilities.getReportPluginConfiguration((Project)this.p, (String)"org.apache.maven.plugins", (String)"maven-pmd-plugin");
        if (pluginConfiguration.isDefinedInProject()) {
            RuleSetFactory rsf = new RuleSetFactory();
            final RuleSet toRet = new RuleSet();
            String[] ruleSets = pluginConfiguration.getStringListValue("rulesets", "ruleset");
            if (ruleSets == null) {
                ruleSets = MavenDefaults.DEFAULT_RULESETS;
            }
            List deps = MavenUtilities.findDependencyArtifacts((Project)this.p, (String)"org.apache.maven.plugins", (String)"maven-pmd-plugin", (boolean)true);
            for (String setString : ruleSets) {
                String nonLeadingSlash = setString.startsWith("/") ? setString.substring(1) : setString;
                File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.p.getProjectDirectory()), (String)setString);
                FileObject fo = null;
                if (file == null || !file.exists()) {
                    if (deps.size() > 0) {
                        FileObject root;
                        File d;
                        FileObject fileFO;
                        Iterator i$ = deps.iterator();
                        while (i$.hasNext() && (!FileUtil.isArchiveFile((FileObject)(fileFO = FileUtil.toFileObject((File)(d = (File)i$.next())))) || (root = FileUtil.getArchiveRoot((FileObject)fileFO)) == null || (fo = root.getFileObject(nonLeadingSlash)) == null)) {
                        }
                    }
                } else {
                    fo = FileUtil.toFileObject((File)file);
                }
                if (fo != null) {
                    try {
                        toRet.addRuleSet(rsf.createRuleSet(fo.getInputStream()));
                    }
                    catch (FileNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                if (setString.startsWith("/")) continue;
                try {
                    URL url = new URL(setString);
                    toRet.addRuleSet(rsf.createRuleSet(url.openStream()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return new PMDSettings(){

                public void activateRule(Rule rule) {
                }

                public void deactivateRule(Rule rule) {
                }

                public boolean isRuleActive(Rule rule) {
                    return true;
                }

                public RuleSet getActiveRules() {
                    RuleSet activeRuleSet = new RuleSet();
                    int minimumPriority = 5;
                    String priorityLevelString = pluginConfiguration.getValue("minimumPriority");
                    if (priorityLevelString != null) {
                        try {
                            minimumPriority = Integer.parseInt(priorityLevelString);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    for (Rule rule : toRet.getRules()) {
                        if (rule.getPriority() > minimumPriority) continue;
                        activeRuleSet.addRule(rule);
                    }
                    return activeRuleSet;
                }
            };
        }
        return null;
    }

    public PMDIncludes getPMDIncludes() {
        return this.includes;
    }
}

