/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.ServerSocketFactory;

public abstract class JSSESocketFactory
extends ServerSocketFactory {
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static boolean defaultClientAuth = false;
    static String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final String defaultKeyPass = "changeit";
    static Log log = LogFactory.getLog((Class)(class$org$apache$tomcat$util$net$jsse$JSSESocketFactory == null ? (class$org$apache$tomcat$util$net$jsse$JSSESocketFactory = JSSESocketFactory.class$("org.apache.tomcat.util.net.jsse.JSSESocketFactory")) : class$org$apache$tomcat$util$net$jsse$JSSESocketFactory));
    protected boolean initialized;
    protected String clientAuth = "false";
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$jsse$JSSESocketFactory;

    public ServerSocket createSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
            this.configureClientAuth(asock);
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        Object[] enabledCiphers = null;
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabledCiphers = new String[vec.size()];
                vec.copyInto(enabledCiphers);
            }
        }
        return enabledCiphers;
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, keystoreFile, pass);
    }

    protected KeyStore getTrustStore(String keystoreType) throws IOException {
        String truststoreType;
        String trustStorePassword;
        KeyStore trustStore = null;
        String trustStoreFile = (String)this.attributes.get("truststoreFile");
        if (trustStoreFile == null) {
            trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Truststore = " + trustStoreFile));
        }
        if ((trustStorePassword = (String)this.attributes.get("truststorePass")) == null) {
            trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (trustStorePassword == null) {
            trustStorePassword = this.getKeystorePassword();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustPass = " + trustStorePassword));
        }
        if ((truststoreType = (String)this.attributes.get("truststoreType")) == null) {
            truststoreType = keystoreType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustType = " + truststoreType));
        }
        if (trustStoreFile != null && trustStorePassword != null) {
            trustStore = this.getStore(truststoreType, trustStoreFile, trustStorePassword);
        }
        return trustStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        FileInputStream istream = null;
        try {
            try {
                ks = KeyStore.getInstance(type);
                istream = new FileInputStream(path);
                ks.load(istream, pass.toCharArray());
                ((InputStream)istream).close();
                return ks;
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (istream == null) throw throwable;
            try {
                ((InputStream)istream).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    abstract void init() throws IOException;

    protected abstract String[] getEnabledProtocols(SSLServerSocket var1, String var2);

    protected abstract void setEnabledProtocols(SSLServerSocket var1, String[] var2);

    protected abstract void configureClientAuth(SSLServerSocket var1);

    protected abstract void configureClientAuth(SSLSocket var1);

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.attributes.get("ciphers") != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        this.configureClientAuth(socket);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

