/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.util.NbBundle;

public class ComponentUsagesChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext context) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        this.checkCCCalls(hints, context);
        return hints;
    }

    private void checkCCCalls(final List<Hint> hints, final RuleContext context) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        final Snapshot snapshot = result.getSnapshot();
        Map declaredLibraries = LibraryUtils.getDeclaredLibraries((HtmlParsingResult)result);
        CharSequence documentContent = null;
        for (String declaredLibraryNamespace : declaredLibraries.keySet()) {
            final Library lib = (Library)declaredLibraries.get(declaredLibraryNamespace);
            Node root = result.root(declaredLibraryNamespace);
            if (root == null) continue;
            if (documentContent == null) {
                documentContent = this.getSourceText(snapshot.getSource());
            }
            final CharSequence docText = documentContent;
            ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag openTag = (OpenTag)node;
                    String tagName = ((Object)openTag.unqualifiedName()).toString();
                    LibraryComponent component = lib.getComponent(tagName);
                    if (component == null) {
                        Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_CC_COMPONENT", (Object)lib.getDisplayName(), (Object)tagName), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.from(), node.to()), Collections.EMPTY_LIST, 50);
                        hints.add(hint);
                    } else {
                        Tag tag = component.getTag();
                        if (tag != null) {
                            if (!tag.hasNonGenenericAttributes()) {
                                return;
                            }
                            Collection attrs = tag.getAttributes();
                            for (org.netbeans.modules.web.jsfapi.api.Attribute attr : attrs) {
                                if (!attr.isRequired() || openTag.getAttribute(attr.getName()) != null) continue;
                                Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_REQUIRED_ATTRIBUTE", (Object)attr.getName()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.from(), node.to()), Collections.EMPTY_LIST, 50);
                                hints.add(hint);
                            }
                            for (Attribute nodeAttr : openTag.attributes()) {
                                String nodeAttrName = ((Object)nodeAttr.name()).toString();
                                if (nodeAttr.namespacePrefix() != null || tag.getAttribute(nodeAttrName) != null || "xmlns".equals(nodeAttrName.toLowerCase(Locale.ENGLISH))) continue;
                                Hint hint = new Hint((Rule)HintsProvider.DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_ATTRIBUTE", (Object)nodeAttr.name(), (Object)tag.getName()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, nodeAttr.from(), nodeAttr.to()), Collections.EMPTY_LIST, 50);
                                hints.add(hint);
                            }
                        }
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
        }
    }
}

