/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets.mojarra;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.DocumentOrderingWrapper;
import com.sun.faces.config.FacesConfigInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.MetaInfFaceletTaglibraryConfigProvider;
import com.sun.faces.config.configprovider.MetaInfFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.MojarraFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.WebFaceletTaglibResourceProvider;
import com.sun.faces.config.configprovider.WebFacesConfigResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.BehaviorConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FaceletTaglibConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.AnnotationProviderFactory;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.ConfigurationResourceProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private static final List<ConfigurationResourceProvider> FACES_CONFIG_RESOURCE_PROVIDERS;
    private static final List<ConfigurationResourceProvider> FACELET_TAGLIBRARY_RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final ConfigManager CONFIG_MANAGER;
    private static final String ANNOTATIONS_SCAN_TASK_KEY;
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private static final ConfigProcessor FACES_CONFIG_PROCESSOR_CHAIN;
    private static final ConfigProcessor FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN;
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";

    public static ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public void initialize(ServletContext servletContext) {
        if (!this.hasBeenInitialized(servletContext)) {
            this.initializedContexts.add(servletContext);
            ExecutorService executorService = null;
            try {
                WebConfiguration webConfiguration = WebConfiguration.getInstance((ServletContext)servletContext);
                boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
                if (ConfigManager.useThreads(servletContext)) {
                    executorService = ConfigManager.createExecutorService();
                }
                DocumentInfo[] documentInfoArray = ConfigManager.getConfigDocuments(servletContext, this.getFacesConfigResourceProviders(), executorService, bl);
                FacesConfigInfo facesConfigInfo = new FacesConfigInfo(documentInfoArray[documentInfoArray.length - 1]);
                documentInfoArray = this.sortDocuments(documentInfoArray, facesConfigInfo);
                boolean bl2 = this.isFaceletsDisabled(webConfiguration, facesConfigInfo);
                if (!facesConfigInfo.isWebInfFacesConfig() || !facesConfigInfo.isMetadataComplete()) {
                    Future<Map<Class<? extends Annotation>, Set<Class<?>>>> future;
                    Set<URI> set = ConfigManager.getAnnotationScanURIs(documentInfoArray);
                    if (executorService != null) {
                        future = executorService.submit(new AnnotationScanTask(servletContext, set));
                        this.pushTaskToContext(servletContext, future);
                    } else {
                        future = new FutureTask(new AnnotationScanTask(servletContext, set));
                        ((FutureTask)future).run();
                    }
                    this.pushTaskToContext(servletContext, future);
                }
                FACES_CONFIG_PROCESSOR_CHAIN.process(null, documentInfoArray);
                if (!bl2) {
                    FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN.process(null, ConfigManager.getConfigDocuments(servletContext, this.getFaceletConfigResourceProviders(), executorService, bl));
                }
                this.publishPostConfigEvent();
            }
            catch (Exception exception) {
                this.releaseFactories();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unsanitized stacktrace from failed start...", exception);
                }
                Throwable throwable = this.unwind(exception);
                throw new ConfigurationException("CONFIGURATION FAILED! " + throwable.getMessage(), throwable);
            }
            finally {
                if (executorService != null) {
                    executorService.shutdown();
                }
                servletContext.removeAttribute(ANNOTATIONS_SCAN_TASK_KEY);
            }
        }
    }

    public void destory(ServletContext servletContext) {
        this.releaseFactories();
        this.initializedContexts.remove(servletContext);
    }

    public boolean hasBeenInitialized(ServletContext servletContext) {
        return this.initializedContexts.contains(servletContext);
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getApplicationMap();
        Future future = (Future)map.get(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return future != null ? (Map)future.get() : Collections.emptyMap();
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private static Set<URI> getAnnotationScanURIs(DocumentInfo[] documentInfoArray) {
        HashSet<URI> hashSet = new HashSet<URI>(documentInfoArray.length);
        HashSet<String> hashSet2 = new HashSet<String>(documentInfoArray.length);
        for (DocumentInfo documentInfo : documentInfoArray) {
            FacesConfigInfo facesConfigInfo;
            String string;
            Matcher matcher = JAR_PATTERN.matcher(documentInfo.getSourceURI().toString());
            if (!matcher.matches() || hashSet2.contains(string = matcher.group(2)) || (facesConfigInfo = new FacesConfigInfo(documentInfo)).isMetadataComplete()) continue;
            hashSet.add(documentInfo.getSourceURI());
            hashSet2.add(string);
        }
        return hashSet;
    }

    private static boolean useThreads(ServletContext servletContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance((ServletContext)servletContext);
        return webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private List<ConfigurationResourceProvider> getFacesConfigResourceProviders() {
        return this.getConfigurationResourceProviders(FACES_CONFIG_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FacesConfig);
    }

    private List<ConfigurationResourceProvider> getFaceletConfigResourceProviders() {
        return this.getConfigurationResourceProviders(FACELET_TAGLIBRARY_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FaceletConfig);
    }

    private List<ConfigurationResourceProvider> getConfigurationResourceProviders(List<ConfigurationResourceProvider> list, ConfigurationResourceProviderFactory.ProviderType providerType) {
        ConfigurationResourceProvider[] configurationResourceProviderArray = ConfigurationResourceProviderFactory.createProviders((ConfigurationResourceProviderFactory.ProviderType)providerType);
        if (configurationResourceProviderArray.length == 0) {
            return list;
        }
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>();
        arrayList.addAll(list);
        arrayList.addAll(list.size() - 1, Arrays.asList(configurationResourceProviderArray));
        return Collections.unmodifiableList(arrayList);
    }

    private DocumentInfo[] sortDocuments(DocumentInfo[] documentInfoArray, FacesConfigInfo facesConfigInfo) {
        int n = facesConfigInfo.isWebInfFacesConfig() ? documentInfoArray.length - 1 : documentInfoArray.length;
        List list = facesConfigInfo.getAbsoluteOrdering();
        if (n > 1) {
            ArrayList<DocumentOrderingWrapper> arrayList = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < n; ++i) {
                arrayList.add(new DocumentOrderingWrapper(documentInfoArray[i]));
            }
            DocumentOrderingWrapper[] documentOrderingWrapperArray = arrayList.toArray(new DocumentOrderingWrapper[arrayList.size()]);
            if (list == null) {
                DocumentOrderingWrapper.sort((DocumentOrderingWrapper[])documentOrderingWrapperArray);
                for (int i = 1; i < n; ++i) {
                    documentInfoArray[i] = documentOrderingWrapperArray[i - 1].getDocument();
                }
                return documentInfoArray;
            }
            DocumentOrderingWrapper[] documentOrderingWrapperArray2 = DocumentOrderingWrapper.sort((DocumentOrderingWrapper[])documentOrderingWrapperArray, (List)list);
            DocumentInfo[] documentInfoArray2 = new DocumentInfo[facesConfigInfo.isWebInfFacesConfig() ? documentOrderingWrapperArray2.length + 2 : documentOrderingWrapperArray2.length + 1];
            for (int i = 1; i < n; ++i) {
                documentInfoArray2[i] = documentOrderingWrapperArray2[i - 1].getDocument();
            }
            documentInfoArray2[0] = documentInfoArray[0];
            if (facesConfigInfo.isWebInfFacesConfig()) {
                documentInfoArray2[documentInfoArray2.length - 1] = documentInfoArray[documentInfoArray.length - 1];
            }
            return documentInfoArray2;
        }
        return documentInfoArray;
    }

    private boolean isFaceletsDisabled(WebConfiguration webConfiguration, FacesConfigInfo facesConfigInfo) {
        boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (!bl) {
            bl = !facesConfigInfo.isVersionGreaterOrEqual(2.0);
            webConfiguration.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, bl);
        }
        return bl;
    }

    private void pushTaskToContext(ServletContext servletContext, Future<Map<Class<? extends Annotation>, Set<Class<?>>>> future) {
        servletContext.setAttribute(ANNOTATIONS_SCAN_TASK_KEY, future);
    }

    private void publishPostConfigEvent() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, (Object)application);
    }

    public static DocumentInfo[] getConfigDocuments(ServletContext servletContext, List<ConfigurationResourceProvider> list, ExecutorService executorService, boolean bl) {
        Object object;
        ArrayList<FutureTask<Collection<URI>>> arrayList = new ArrayList<FutureTask<Collection<URI>>>(list.size());
        for (ConfigurationResourceProvider object32 : list) {
            FutureTask<Collection<URI>> futureTask = new FutureTask<Collection<URI>>(new URITask(object32, servletContext));
            arrayList.add(futureTask);
            if (executorService != null) {
                executorService.execute(futureTask);
                continue;
            }
            futureTask.run();
        }
        ArrayList arrayList2 = new ArrayList(list.size() << 1);
        for (FutureTask futureTask : arrayList) {
            try {
                object = (Collection)futureTask.get();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    URI uRI = (URI)iterator.next();
                    FutureTask<DocumentInfo> futureTask2 = new FutureTask<DocumentInfo>(new ParseTask(bl, uRI.toURL()));
                    arrayList2.add(futureTask2);
                    if (executorService != null) {
                        executorService.execute(futureTask2);
                        continue;
                    }
                    futureTask2.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException((Throwable)exception);
            }
        }
        ArrayList arrayList3 = new ArrayList(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (FutureTask)iterator.next();
            try {
                arrayList3.add(((FutureTask)object).get());
            }
            catch (ExecutionException executionException) {
                Logger.getAnonymousLogger().log(Level.INFO, "Error parsing facelets library descriptor", executionException);
            }
            catch (InterruptedException interruptedException) {}
        }
        return arrayList3.toArray(new DocumentInfo[arrayList3.size()]);
    }

    private static ExecutorService createExecutorService() {
        int n = Runtime.getRuntime().availableProcessors();
        if (n > 5) {
            n = 5;
        }
        return Executors.newFixedThreadPool(n);
    }

    private Throwable unwind(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null && (throwable2 = this.unwind(throwable.getCause())) == null) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException facesException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", facesException);
            }
        }
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        ANNOTATIONS_SCAN_TASK_KEY = ConfigManager.class.getName() + "_ANNOTATION_SCAN_TASK";
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(new MojarraFacesConfigResourceProvider());
        arrayList.add(new MetaInfFacesConfigResourceProvider());
        arrayList.add(new WebFacesConfigResourceProvider());
        FACES_CONFIG_RESOURCE_PROVIDERS = Collections.unmodifiableList(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(3);
        arrayList2.add(new MetaInfFaceletTaglibraryConfigProvider());
        arrayList2.add(new WebFaceletTaglibResourceProvider());
        FACELET_TAGLIBRARY_RESOURCE_PROVIDERS = Collections.unmodifiableList(arrayList2);
        ConfigProcessor[] configProcessorArray = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor(), new BehaviorConfigProcessor()};
        for (int i = 0; i < configProcessorArray.length; ++i) {
            ConfigProcessor configProcessor = configProcessorArray[i];
            if (i + 1 >= configProcessorArray.length) continue;
            configProcessor.setNext(configProcessorArray[i + 1]);
        }
        FACES_CONFIG_PROCESSOR_CHAIN = configProcessorArray[0];
        FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN = new FaceletTaglibConfigProcessor();
    }

    private static class AnnotationScanTask
    implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private ServletContext sc;
        private Set<URI> uris;

        public AnnotationScanTask(ServletContext servletContext, Set<URI> set) {
            this.sc = servletContext;
            this.uris = set;
        }

        @Override
        public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
            Timer timer = Timer.getInstance();
            if (timer != null) {
                timer.startTiming();
            }
            AnnotationProvider annotationProvider = AnnotationProviderFactory.createAnnotationProvider((ServletContext)this.sc);
            Map map = annotationProvider.getAnnotatedClasses(this.uris);
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Configuration annotation scan complete.");
            }
            return map;
        }
    }

    private static class ParseTask
    implements Callable<DocumentInfo> {
        private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private URL documentURL;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(boolean bl, URL uRL) throws Exception {
            this.documentURL = uRL;
            this.factory = DbfFactory.getFactory();
            this.validating = bl;
        }

        @Override
        public DocumentInfo call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document document = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURL.toExternalForm());
                }
                return new DocumentInfo(document, new URI(this.documentURL.toExternalForm()));
            }
            catch (Exception exception) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURL.toExternalForm(), exception.getMessage()), (Throwable)exception);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Document getDocument() throws Exception {
            Document document;
            Object object;
            DocumentBuilder documentBuilder = this.getNonValidatingBuilder();
            InputSource inputSource = new InputSource(ParseTask.getInputStream(this.documentURL));
            inputSource.setSystemId(this.documentURL.toExternalForm());
            Document document2 = documentBuilder.parse(inputSource);
            String string = document2.getDocumentElement().getNamespaceURI();
            if (this.validating && string != null) {
                object = new DOMSource(document2, this.documentURL.toExternalForm());
                Element element = ((Document)((DOMSource)object).getNode()).getDocumentElement();
                if (JAVAEE_SCHEMA_DEFAULT_NS.equals(string)) {
                    DbfFactory.FacesSchema facesSchema;
                    Attr attr = (Attr)element.getAttributes().getNamedItem("version");
                    if (attr == null) throw new ConfigurationException("No document version available.");
                    String string2 = attr.getValue();
                    if ("2.0".equals(string2)) {
                        facesSchema = "facelet-taglib".equals(element.getLocalName()) ? DbfFactory.FacesSchema.FACELET_TAGLIB_20 : DbfFactory.FacesSchema.FACES_20;
                    } else {
                        if (!"1.2".equals(string2)) throw new ConfigurationException("Unknown Schema version: " + string2);
                        facesSchema = DbfFactory.FacesSchema.FACES_12;
                    }
                    DocumentBuilder documentBuilder2 = this.getBuilderForSchema(facesSchema);
                    if (documentBuilder2.isValidating()) {
                        documentBuilder2.getSchema().newValidator().validate((Source)object);
                        document = (Document)((DOMSource)object).getNode();
                    } else {
                        document = (Document)((DOMSource)object).getNode();
                    }
                } else {
                    DbfFactory.FacesSchema facesSchema;
                    DOMResult dOMResult = new DOMResult();
                    Transformer transformer = ParseTask.getTransformer(string);
                    transformer.transform((Source)object, dOMResult);
                    ((Document)dOMResult.getNode()).setDocumentURI(((Document)((DOMSource)object).getNode()).getDocumentURI());
                    if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(string)) {
                        facesSchema = DbfFactory.FacesSchema.FACES_11;
                    } else {
                        if (!ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(string)) throw new IllegalStateException();
                        facesSchema = DbfFactory.FacesSchema.FACELET_TAGLIB_20;
                    }
                    DocumentBuilder documentBuilder3 = this.getBuilderForSchema(facesSchema);
                    if (documentBuilder3.isValidating()) {
                        documentBuilder3.getSchema().newValidator().validate(new DOMSource(dOMResult.getNode()));
                        document = (Document)dOMResult.getNode();
                    } else {
                        document = (Document)dOMResult.getNode();
                    }
                }
            } else {
                document = document2;
            }
            if (!this.documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) return document;
            object = document.createAttribute(ConfigManager.WEB_INF_MARKER);
            object.setValue("true");
            document.getDocumentElement().getAttributes().setNamedItem((Node)object);
            return document;
        }

        private static Transformer getTransformer(String string) throws Exception {
            String string2;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(string)) {
                string2 = ConfigManager.FACES_TO_1_1_PRIVATE_XSL;
            } else if (ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(string)) {
                string2 = ConfigManager.FACELETS_TO_2_0_XSL;
            } else {
                throw new IllegalStateException();
            }
            return transformerFactory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(string2))));
        }

        private static InputStream getInputStream(URL uRL) throws IOException {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            return new BufferedInputStream(uRLConnection.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory documentBuilderFactory = DbfFactory.getFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler((ErrorHandler)DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }

        private DocumentBuilder getBuilderForSchema(DbfFactory.FacesSchema facesSchema) throws Exception {
            try {
                this.factory.setSchema(facesSchema.getSchema());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler((ErrorHandler)DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }
    }

    private static class URITask
    implements Callable<Collection<URI>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URITask(ConfigurationResourceProvider configurationResourceProvider, ServletContext servletContext) {
            this.provider = configurationResourceProvider;
            this.sc = servletContext;
        }

        @Override
        public Collection<URI> call() throws Exception {
            return this.provider.getResources(this.sc);
        }
    }
}

