/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.beans.api.model.support.WebBeansModelSupport;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.openide.filesystems.FileObject;

public final class WebBeansELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "NamedBeans";

    public String getBeanClass(String beanName, FileObject target, ResolverContext context) {
        for (WebBeansModelSupport.WebBean bean : this.getWebBeans(target, context)) {
            if (!beanName.equals(bean.getName())) continue;
            return bean.getBeanClassName();
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (WebBeansModelSupport.WebBean bean : this.getWebBeans(target, context)) {
            if (!clazz.equals(bean.getBeanClassName())) continue;
            return bean.getName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        List<WebBeansModelSupport.WebBean> beans = this.getWebBeans(target, context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (WebBeansModelSupport.WebBean bean : beans) {
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getName(), (String)bean.getBeanClassName()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    private List<WebBeansModelSupport.WebBean> getWebBeans(FileObject target, ResolverContext context) {
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(target);
        if (jsfSupport == null) {
            return Collections.emptyList();
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, (Object)WebBeansModelSupport.getNamedBeans(jsfSupport.getWebBeansModel()));
        }
        return (List)context.getContent(CONTENT_NAME);
    }
}

