/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.netbeans.modules.web.jsf.editor.el.JsfVariablesModel;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class JsfELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "JsfBeans";
    private static final String OBJECT_NAME__CC = "cc";
    private static final String ATTR_NAME__ATTRS = "attrs";
    private static final String ATTR_NAME__ID = "id";
    private static final String ATTR_NAME__RENDERED = "rendered";
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ATTRS = ELVariableResolver.VariableInfo.createResolvedVariable((String)"attrs", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ID = ELVariableResolver.VariableInfo.createResolvedVariable((String)"id", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__RENDERED = ELVariableResolver.VariableInfo.createResolvedVariable((String)"rendered", (String)Object.class.getName());

    public String getBeanClass(String string, FileObject fileObject, ResolverContext resolverContext) {
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(fileObject, resolverContext)) {
            if (!string.equals(facesManagedBean.getManagedBeanName())) continue;
            return facesManagedBean.getManagedBeanClass();
        }
        return null;
    }

    public String getBeanName(String string, FileObject fileObject, ResolverContext resolverContext) {
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(fileObject, resolverContext)) {
            if (!string.equals(facesManagedBean.getManagedBeanClass())) continue;
            return facesManagedBean.getManagedBeanName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject fileObject, ResolverContext resolverContext) {
        List<FacesManagedBean> list = this.getJsfManagedBeans(fileObject, resolverContext);
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>(list.size());
        for (FacesManagedBean facesManagedBean : list) {
            if (facesManagedBean.getManagedBeanClass() == null || facesManagedBean.getManagedBeanName() == null) continue;
            arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)facesManagedBean.getManagedBeanName(), (String)facesManagedBean.getManagedBeanClass()));
        }
        return arrayList;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int n, ResolverContext resolverContext) {
        List<JsfVariableContext> list = this.getAllJsfVariables(snapshot, n);
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>(list.size());
        for (JsfVariableContext jsfVariableContext : list) {
            String string = jsfVariableContext.getResolvedExpression();
            if (string == null) continue;
            arrayList.add(ELVariableResolver.VariableInfo.createUnresolvedVariable((String)jsfVariableContext.getVariableName(), (String)string));
        }
        return arrayList;
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String string, Snapshot snapshot, ResolverContext resolverContext) {
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>(3);
        if (OBJECT_NAME__CC.equals(string)) {
            arrayList.add(VARIABLE_INFO__ID);
            arrayList.add(VARIABLE_INFO__RENDERED);
            arrayList.add(VARIABLE_INFO__ATTRS);
        } else if (ATTR_NAME__ATTRS.equals(string)) {
            arrayList.add(VARIABLE_INFO__ID);
            arrayList.add(VARIABLE_INFO__RENDERED);
            final JsfPageModelFactory jsfPageModelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
            assert (jsfPageModelFactory != null);
            final AtomicReference atomicReference = new AtomicReference();
            try {
                ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                        if (result instanceof HtmlParserResult) {
                            atomicReference.set((CompositeComponentModel)jsfPageModelFactory.getModel((HtmlParserResult)result));
                        }
                    }
                });
                CompositeComponentModel compositeComponentModel = (CompositeComponentModel)atomicReference.get();
                if (compositeComponentModel != null) {
                    Collection<Map<String, String>> collection = compositeComponentModel.getExistingInterfaceAttributes();
                    for (Map<String, String> map : collection) {
                        String string2 = map.get("name");
                        if (string2 == null) continue;
                        arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)string2, (String)Object.class.getName()));
                    }
                }
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        return arrayList;
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String string, Snapshot snapshot, ResolverContext resolverContext) {
        ArrayList<ELVariableResolver.VariableInfo> arrayList = new ArrayList<ELVariableResolver.VariableInfo>();
        for (FacesManagedBean facesManagedBean : this.getJsfManagedBeans(snapshot.getSource().getFileObject(), resolverContext)) {
            if (facesManagedBean.getManagedBeanClass() == null || facesManagedBean.getManagedBeanName() != null || !string.equals(facesManagedBean.getManagedBeanScopeString())) continue;
            arrayList.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)facesManagedBean.getManagedBeanName(), (String)facesManagedBean.getManagedBeanClass()));
        }
        return arrayList;
    }

    private List<FacesManagedBean> getJsfManagedBeans(FileObject fileObject, ResolverContext resolverContext) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        if (resolverContext.getContent(CONTENT_NAME) == null) {
            resolverContext.setContent(CONTENT_NAME, (Object)JSFBeanCache.getBeans((Project)project));
        }
        return (List)resolverContext.getContent(CONTENT_NAME);
    }

    private List<JsfVariableContext> getAllJsfVariables(Snapshot snapshot, final int n) {
        final ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (result instanceof HtmlParserResult) {
                        JsfVariablesModel jsfVariablesModel = JsfVariablesModel.getModel((HtmlParserResult)result, resultIterator.getSnapshot());
                        List<JsfVariableContext> list = jsfVariablesModel.getAllAvailableVariables(n, false);
                        arrayList.addAll(list);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return arrayList;
    }
}

