/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.JsfUtils;
import org.netbeans.modules.web.jsfapi.spi.InputTextTagValueProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FaceletsInputTextTagValueProvider
implements InputTextTagValueProvider {
    private static final String INPUT_TEXT_TAG_NAME = "inputText";
    private static final String VALUE_ATTR_NAME = "value";

    public Map<String, String> getInputTextValuesMap(FileObject fo) {
        try {
            if (!JsfUtils.isFaceletsFile((FileObject)fo)) {
                return null;
            }
            StyledDocument doc = DataLoadersBridge.getDefault().getDocument(fo);
            if (doc == null) {
                return null;
            }
            final AtomicReference result = new AtomicReference();
            Source source = Source.create((Document)doc);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (ri != null) {
                        result.set((HtmlParsingResult)ri.getParserResult());
                    }
                }
            });
            HtmlParsingResult hresult = (HtmlParsingResult)result.get();
            if (hresult == null) {
                return null;
            }
            if (hresult.getNamespaces().containsKey(DefaultLibraryInfo.HTML.getNamespace())) {
                String htmlLibPrefix = (String)hresult.getNamespaces().get(DefaultLibraryInfo.HTML.getNamespace());
                if (htmlLibPrefix == null) {
                    htmlLibPrefix = DefaultLibraryInfo.HTML.getDefaultPrefix();
                }
                String tagName = htmlLibPrefix + '.' + INPUT_TEXT_TAG_NAME;
                Collection<OpenTag> foundNodes = this.findValue(hresult.root(DefaultLibraryInfo.HTML.getNamespace()).children(), tagName, new ArrayList<OpenTag>());
                HashMap<String, String> map = new HashMap<String, String>();
                for (OpenTag node : foundNodes) {
                    CharSequence value;
                    Attribute attr = node.getAttribute(VALUE_ATTR_NAME);
                    if (attr == null || (value = attr.unquotedValue()) == null) continue;
                    String svalue = ((Object)value).toString();
                    String key = this.generateKey(svalue, map);
                    map.put(key, svalue);
                }
                return map;
            }
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private Collection<OpenTag> findValue(Collection<Element> nodes, String tagName, Collection<OpenTag> foundNodes) {
        if (nodes == null) {
            return foundNodes;
        }
        for (Element e : nodes) {
            if (e.type() != ElementType.OPEN_TAG) continue;
            OpenTag openTag = (OpenTag)e;
            if (LexerUtils.equals((CharSequence)tagName, (CharSequence)openTag.name(), (boolean)true, (boolean)false)) {
                foundNodes.add(openTag);
                continue;
            }
            foundNodes = this.findValue(openTag.children(), tagName, foundNodes);
        }
        return foundNodes;
    }

    private String generateKey(String value, Map<String, String> properties) {
        if (value.startsWith("#{")) {
            value = value.substring(2, value.length() - 1);
        }
        String result = value.substring(value.lastIndexOf(".") + 1, value.length()).toLowerCase();
        int i = 0;
        String tmp = result;
        while (properties.get(tmp) != null) {
            tmp = result + ++i;
        }
        return result;
    }
}

