/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageHighlightsContainer;
import org.netbeans.modules.gsf.codecoverage.CoverageHighlightsLayerFactory;
import org.netbeans.modules.gsf.codecoverage.CoverageReportTopComponent;
import org.netbeans.modules.gsf.codecoverage.CoverageSideBar;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbPreferences;

public class CoverageManagerImpl
implements CoverageManager {
    public static final String COVERAGE_INSTANCE_FILE = "coverage.instance";
    private static final String MIME_TYPE = "mimeType";
    private static final String COVERAGE_DOC_PROPERTY = "coverage";
    private static final String PREF_EDITOR_BAR = "editorBar";
    private Set<String> enabledMimeTypes = new HashSet<String>();
    private Map<Project, CoverageReportTopComponent> showingReports = new HashMap<Project, CoverageReportTopComponent>();
    private Boolean showEditorBar;

    static CoverageManagerImpl getInstance() {
        return (CoverageManagerImpl)CoverageManager.INSTANCE;
    }

    @Override
    public void setEnabled(final Project project, final boolean enabled) {
        final CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider == null) {
            return;
        }
        Set<String> mimeTypes = provider.getMimeTypes();
        if (enabled) {
            this.enabledMimeTypes.addAll(mimeTypes);
        } else {
            this.enabledMimeTypes.removeAll(mimeTypes);
        }
        provider.setEnabled(enabled);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CoverageManagerImpl.this.resultsUpdated(project, provider);
                if (!enabled) {
                    for (JTextComponent target : EditorRegistry.componentList()) {
                        Document document = target.getDocument();
                        CoverageSideBar sb = CoverageSideBar.getSideBar(document);
                        if (sb == null) continue;
                        sb.showCoveragePanel(false);
                    }
                }
            }
        });
    }

    @Override
    public boolean isAggregating(Project project) {
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider != null) {
            return provider.isAggregating();
        }
        return false;
    }

    public void setAggregating(Project project, boolean aggregating) {
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider == null) {
            return;
        }
        provider.setAggregating(aggregating);
    }

    void focused(FileObject fo, JTextComponent target) {
        CoverageProvider provider;
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null && (provider = CoverageManagerImpl.getProvider(project)) != null && provider.isEnabled()) {
            try {
                EditorCookie ec = (EditorCookie)DataLoadersBridge.getDefault().getCookie(fo, EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.getDocument();
                    if (doc == null) {
                        return;
                    }
                    doc.putProperty(COVERAGE_DOC_PROPERTY, null);
                    CoverageHighlightsContainer container = CoverageHighlightsLayerFactory.getContainer(doc);
                    if (container != null) {
                        container.refresh();
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    void showFile(Project project, FileCoverageSummary result) {
        FileObject fo = result.getFile();
        if (fo == null) {
            String display = result.getDisplayName();
            File file = new File(display);
            fo = file.exists() ? FileUtil.toFileObject((File)file) : project.getProjectDirectory().getFileObject(display.replace('\\', '/'));
        }
        if (fo != null) {
            GsfUtilities.open((FileObject)fo, (int)-1, null);
        }
    }

    static CoverageProvider getProvider(Project project) {
        if (project != null) {
            return (CoverageProvider)project.getLookup().lookup(CoverageProvider.class);
        }
        return null;
    }

    @Override
    public boolean isEnabled(Project project) {
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider != null) {
            return provider.isEnabled();
        }
        return false;
    }

    public boolean isEnabled(String mimeType) {
        return this.enabledMimeTypes.contains(mimeType);
    }

    FileCoverageDetails getDetails(Project project, FileObject fileObject, Document doc) {
        CoverageProvider provider;
        if (project != null && (provider = CoverageManagerImpl.getProvider(project)) != null && provider.isEnabled()) {
            FileCoverageDetails hitCounts = (FileCoverageDetails)doc.getProperty(COVERAGE_DOC_PROPERTY);
            if (hitCounts == null) {
                CoverageSideBar sb;
                hitCounts = provider.getDetails(fileObject, doc);
                doc.putProperty(COVERAGE_DOC_PROPERTY, hitCounts);
                if (this.getShowEditorBar() && (sb = CoverageSideBar.getSideBar(doc)) != null) {
                    sb.showCoveragePanel(true);
                    sb.setCoverage(hitCounts);
                }
                return hitCounts;
            }
            return hitCounts;
        }
        return null;
    }

    @Override
    public void resultsUpdated(Project project, CoverageProvider provider) {
        Set<String> mimeTypes = provider.getMimeTypes();
        for (JTextComponent target : EditorRegistry.componentList()) {
            FileObject fo;
            Document document = target.getDocument();
            String mimeType = (String)document.getProperty(MIME_TYPE);
            if (mimeType == null || !mimeTypes.contains(mimeType) || (fo = GsfUtilities.findFileObject((Document)document)) == null || FileOwnerQuery.getOwner((FileObject)fo) != project) continue;
            FileCoverageDetails hitCounts = (FileCoverageDetails)document.getProperty(COVERAGE_DOC_PROPERTY);
            if (hitCounts == null) {
                document.putProperty(COVERAGE_DOC_PROPERTY, null);
            }
            if (this.isEnabled(project)) {
                this.focused(fo, target);
                continue;
            }
            CoverageHighlightsContainer container = CoverageHighlightsLayerFactory.getContainer(document);
            if (container == null) continue;
            container.refresh();
        }
        final CoverageReportTopComponent report = this.showingReports.get(project);
        if (report != null) {
            final List<FileCoverageSummary> coverage = provider.getResults();
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    report.updateData(coverage);
                }
            });
        }
    }

    public void clear(Project project) {
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider != null) {
            provider.clear();
            this.resultsUpdated(project, provider);
        }
    }

    void closedReport(Project project) {
        this.showingReports.remove(project);
    }

    public void showReport(Project project) {
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider != null) {
            List<FileCoverageSummary> results = provider.getResults();
            CoverageReportTopComponent report = this.showingReports.get(project);
            if (report == null) {
                report = new CoverageReportTopComponent(project, results);
                this.showingReports.put(project, report);
                report.open();
            }
            report.toFront();
            report.requestVisible();
        }
    }

    public boolean getShowEditorBar() {
        if (this.showEditorBar == null) {
            this.showEditorBar = NbPreferences.forModule(CoverageManager.class).getBoolean(PREF_EDITOR_BAR, true);
        }
        return this.showEditorBar == Boolean.TRUE;
    }

    public void setShowEditorBar(boolean on) {
        this.showEditorBar = on;
        NbPreferences.forModule(CoverageManager.class).putBoolean(PREF_EDITOR_BAR, on);
        for (JTextComponent target : EditorRegistry.componentList()) {
            Document document = target.getDocument();
            CoverageSideBar sb = CoverageSideBar.getSideBar(document);
            if (sb == null) continue;
            sb.showCoveragePanel(on);
        }
    }
}

