/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardPanel;
import org.netbeans.modules.web.examples.WebSampleProjectGenerator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaEESamplesWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    protected WizardDescriptor wiz;

    public static JavaEESamplesWizardIterator createIterator() {
        return new JavaEESamplesWizardIterator();
    }

    protected WizardDescriptor.Panel[] createPanels() {
        boolean specifyPrjName = "web".equals(Templates.getTemplate((WizardDescriptor)this.wiz).getAttribute("prjType"));
        return new WizardDescriptor.Panel[]{new JavaEESamplesWizardPanel(false, specifyPrjName)};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start(2);
        handle.progress(NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_NewSampleProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        String name = (String)this.wiz.getProperty("name");
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = null;
        if ("web".equals(template.getAttribute("prjType"))) {
            dir = WebSampleProjectGenerator.createProjectFromTemplate((FileObject)template, (File)dirF, (String)name);
        } else {
            JavaEESamplesWizardIterator.createFolder(dirF);
            dir = FileUtil.toFileObject((File)dirF);
            JavaEESamplesWizardIterator.unZipFile(template.getInputStream(), dir);
            WebSampleProjectGenerator.configureServer((FileObject)dir);
            for (FileObject child : dir.getChildren()) {
                WebSampleProjectGenerator.configureServer((FileObject)child);
            }
        }
        ProjectManager.getDefault().clearNonProjectCache();
        handle.progress(NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_NewSampleProjectWizardIterator_WizardProgress_PreparingToOpen"), 2);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        handle.finish();
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        wiz.putProperty("name", (Object)template.getName());
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_Order", (Object[])new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)});
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream source, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                FileLock lock = fo.lock();
                try {
                    OutputStream out = fo.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)str, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            source.close();
        }
    }

    private static FileObject createFolder(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            JavaEESamplesWizardIterator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }
}

